/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.bridge;

import com.insightful.splusserver.api.bridge.ICommonServerBridge;
import com.insightful.splusserver.domain.Authentication;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.UrlUtil;
import com.insightful.splusserver.util.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public abstract class CommonServerBridge
implements ICommonServerBridge {
    private static final int SOCKET_TIMEOUT_MS = 60000;
    private static final int CONNECTION_TIMEOUT_MS = 60000;
    private String mServiceUrl = null;
    private String mUserName = null;
    private String mPassword = null;
    private String mSessionId = null;
    private final HttpClient httpClient;

    public CommonServerBridge() {
        SimpleHttpConnectionManager mgr = new SimpleHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setSoTimeout(60000);
        params.setConnectionTimeout(60000);
        mgr.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)mgr);
        this.httpClient.getParams().setAuthenticationPreemptive(true);
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public void setUserName(String userName) {
        this.mUserName = userName;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public Boolean validateUserCredentials() throws BridgeException {
        Boolean result = Boolean.FALSE;
        try {
            String url = this.getServiceUrl() + "/api/authentication/validateUserCredentials?j_username=" + this.mUserName + "&j_password=" + this.mPassword;
            String stringResult = this.readUrlResult(url);
            result = this.checkValidation(stringResult.toString());
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public Boolean validateUserCredentials(String userName, String password) throws BridgeException {
        Boolean result = Boolean.FALSE;
        try {
            String url = this.getServiceUrl() + "/api/authentication/validateUserCredentials?j_username=" + userName + "&j_password=" + password;
            String stringResult = this.readUrlResult(url);
            result = this.checkValidation(stringResult);
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    Boolean checkValidation(String xml) {
        Boolean result = Boolean.FALSE;
        try {
            Authentication auth = (Authentication)XmlUtil.unmarshal(Authentication.class, xml);
            result = new Boolean(auth.getStatus());
        }
        catch (MarshalException e) {
        }
        catch (MappingException e) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public String loginRequest() throws BridgeException {
        String result = null;
        try {
            String url = this.getServiceUrl() + "/public/validateUserCredentials.html?j_username=" + this.mUserName + "&j_password=" + this.mPassword;
            result = this.readUrlResult(url);
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public String[] getUserRoles() throws BridgeException {
        String[] userRoles = new String[]{};
        return userRoles;
    }

    public String getServiceUrl() {
        return this.mServiceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.mServiceUrl = UrlUtil.createUrlStringFromHostAndPath(serviceUrl, "SplusServer");
    }

    protected abstract Log getLogger();

    protected Boolean ping() throws ServerNotRespondingException {
        Boolean result = Boolean.TRUE;
        try {
            String url = this.getServiceUrl() + "/api/public/" + "ping";
            result = Boolean.parseBoolean(this.readUrlResult(url));
        }
        catch (IOException e) {
            throw new ServerNotRespondingException();
        }
        return result;
    }

    protected String readUrlResult(String url) throws IOException {
        if (this.mUserName != null && this.mPassword != null) {
            HttpState state = this.httpClient.getState();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.mUserName, this.mPassword);
            state.setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        GetMethod method = new GetMethod(url);
        String result = null;
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            result = method.getResponseBodyAsString();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    public void setTimeouts() {
        HttpConnectionManagerParams params = this.httpClient.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(60000);
        params.setSoTimeout(60000);
        this.httpClient.getHttpConnectionManager().setParams(params);
    }

    public void resetTimeouts() {
        HttpConnectionManagerParams params = this.httpClient.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(0);
        params.setSoTimeout(0);
        this.httpClient.getHttpConnectionManager().setParams(params);
    }
}

