/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.util;

import com.insightful.splusserver.configuration.ServerPropertyManager;
import com.insightful.splusserver.domain.SplusDataResult;
import java.io.Reader;
import java.io.StringReader;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class XmlUtil {
    public static Object unmarshal(Class clazz, String xml) throws MarshalException, MappingException, ValidationException {
        Unmarshaller unm = new Unmarshaller(clazz);
        unm.setMapping(ServerPropertyManager.getXmlMapping());
        StringReader sr = new StringReader(xml);
        return unm.unmarshal((Reader)sr);
    }

    public static SplusDataResult unmarshalSplusDataResult(String xml) throws MarshalException, MappingException, ValidationException {
        Unmarshaller unm = new Unmarshaller(SplusDataResult.class);
        unm.setMapping(ServerPropertyManager.getXmlMapping());
        StringReader sr = new StringReader(xml);
        SplusDataResult sResult = (SplusDataResult)unm.unmarshal((Reader)sr);
        if (sResult.hasTextOutput().booleanValue()) {
            sResult.setTextOutput(XmlUtil.getCdata("SplusTextOutput", xml));
        }
        if (sResult.hasError().booleanValue()) {
            sResult.setError(XmlUtil.getCdata("SplusError", xml));
        }
        return sResult;
    }

    static String getCdata(String tag, String xml) {
        String result = null;
        String beginTag = String.format("<%s>", tag);
        String endTag = String.format("</%s>", tag);
        int beginIndex = xml.indexOf(beginTag);
        int endIndex = xml.indexOf(endTag);
        if (beginIndex > -1 && endIndex > -1) {
            String tagContent = xml.substring(beginIndex += beginTag.length(), endIndex);
            String beginCdata = "<![CDATA[";
            String endCdata = "]]>";
            beginIndex = tagContent.indexOf(beginCdata);
            endIndex = tagContent.indexOf(endCdata);
            if (beginIndex > -1 && endIndex > -1) {
                result = tagContent.substring(beginIndex += beginCdata.length(), endIndex);
            }
        }
        return result;
    }
}

