/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.iterator;

import com.sun.media.jai.iterator.RectIterCSMByte;
import com.sun.media.jai.iterator.RectIterCSMFloat;
import com.sun.media.jai.iterator.RectIterFallback;
import com.sun.media.jai.iterator.WrapperRI;
import com.sun.media.jai.iterator.WrapperWRI;
import com.sun.media.jai.iterator.WritableRectIterCSMByte;
import com.sun.media.jai.iterator.WritableRectIterCSMFloat;
import com.sun.media.jai.iterator.WritableRectIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.WritableRectIter;

public class RectIterFactory {
    private RectIterFactory() {
    }

    public static RectIter create(Raster raster, Rectangle rectangle) {
        WrapperRI wrapperRI = new WrapperRI(raster);
        return RectIterFactory.create(wrapperRI, rectangle);
    }

    public static RectIter create(RenderedImage renderedImage, Rectangle rectangle) {
        SampleModel sampleModel;
        if (rectangle == null) {
            rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        }
        if ((sampleModel = renderedImage.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sampleModel.getDataType()) {
                case 0: {
                    return new RectIterCSMByte(renderedImage, rectangle);
                }
                case 4: {
                    return new RectIterCSMFloat(renderedImage, rectangle);
                }
            }
        }
        return new RectIterFallback(renderedImage, rectangle);
    }

    public static WritableRectIter createWritable(WritableRaster writableRaster, Rectangle rectangle) {
        WrapperWRI wrapperWRI = new WrapperWRI(writableRaster);
        return RectIterFactory.createWritable(wrapperWRI, rectangle);
    }

    public static WritableRectIter createWritable(WritableRenderedImage writableRenderedImage, Rectangle rectangle) {
        SampleModel sampleModel;
        if (rectangle == null) {
            rectangle = new Rectangle(writableRenderedImage.getMinX(), writableRenderedImage.getMinY(), writableRenderedImage.getWidth(), writableRenderedImage.getHeight());
        }
        if ((sampleModel = writableRenderedImage.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sampleModel.getDataType()) {
                case 0: {
                    return new WritableRectIterCSMByte(writableRenderedImage, rectangle);
                }
                case 4: {
                    return new WritableRectIterCSMFloat(writableRenderedImage, rectangle);
                }
            }
        }
        return new WritableRectIterFallback(writableRenderedImage, rectangle);
    }
}

