/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import java.util.Enumeration;
import java.util.Hashtable;

class TagSet {
    protected Hashtable m_vecTags = new Hashtable();
    protected boolean m_changed = false;

    public void clearChanged() {
        this.m_changed = false;
    }

    public boolean hasChanged() {
        return this.m_changed;
    }

    public synchronized void add(String string) {
        if (string == null) {
            return;
        }
        if (!this.m_vecTags.containsKey(string)) {
            this.m_vecTags.put(string, string);
            this.m_changed = true;
        }
    }

    public synchronized void add(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(stringArray[i]);
        }
    }

    public synchronized void remove(String string) {
        if (string == null) {
            return;
        }
        if (this.m_vecTags.containsKey(string)) {
            this.m_vecTags.remove(string);
            this.m_changed = true;
        }
    }

    public synchronized void toggle(String string) {
        if (string == null) {
            return;
        }
        if (this.contains(string)) {
            this.remove(string);
        } else {
            this.add(string);
        }
    }

    public synchronized void toggle(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.toggle(stringArray[i]);
        }
    }

    public synchronized void clear() {
        if (!this.m_vecTags.isEmpty()) {
            this.m_vecTags.clear();
            this.m_changed = true;
        }
    }

    public boolean isEmpty() {
        return this.m_vecTags.isEmpty();
    }

    public synchronized boolean contains(String string) {
        return string != null && this.m_vecTags.containsKey(string);
    }

    public synchronized String[] getSelectedTagArray() {
        int n = this.m_vecTags.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.m_vecTags.keys();
        for (int i = 0; i < n && enumeration.hasMoreElements(); ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public synchronized void setSelectedTagArray(String[] stringArray) {
        this.clear();
        this.add(stringArray);
    }
}

