/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.core.model;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.debug.core.SplusDebugPlugin;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugElement;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugEvent;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugLineBreakpoint;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugManager;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugStackFrame;
import com.insightful.splus.eclipse.debug.core.model.SplusDebugTarget;
import com.insightful.splus.eclipse.debug.core.model.SplusEclipseDebugListener;
import java.util.Vector;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class SplusDebugThread
extends SplusDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;
    private Vector listeners = new Vector();
    private boolean m_callStack = false;
    private String m_breakInfo = "Thread[1]";
    private long[] m_breakAddress = null;
    private SplusDebugStackFrame[] m_callStackFrames = new SplusDebugStackFrame[0];

    public SplusDebugThread(SplusDebugTarget splusDebugTarget) {
        super(splusDebugTarget);
    }

    public synchronized IStackFrame[] getStackFrames() throws DebugException {
        if (this.m_callStack) {
            return this.m_callStackFrames;
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public synchronized IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] iStackFrameArray = this.getStackFrames();
        if (iStackFrameArray != null && iStackFrameArray.length > 0) {
            return iStackFrameArray[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return this.m_breakInfo;
    }

    public long[] getAddress() {
        return this.m_breakAddress;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] iBreakpointArray) {
        this.fBreakpoints = iBreakpointArray;
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.reset();
        SplusDebugPlugin.getDefault().getDebugManager().doResume(this.fTarget.getExpressionID());
        this.notifyListeners(5);
    }

    public void suspend() throws DebugException {
        this.reset();
        SplusDebugPlugin.getDefault().getDebugManager().doPause(this.fTarget.getExpressionID());
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        this.reset();
        SplusDebugPlugin.getDefault().getDebugManager().doStepIn(this.fTarget.getExpressionID());
    }

    public void stepOver() throws DebugException {
        this.reset();
        SplusDebugPlugin.getDefault().getDebugManager().doStep(this.fTarget.getExpressionID());
    }

    public void stepReturn() throws DebugException {
        this.reset();
        SplusDebugPlugin.getDefault().getDebugManager().doStepOut(this.fTarget.getExpressionID());
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setStepping(boolean bl) {
        this.fStepping = bl;
    }

    public void addDebugListener(SplusEclipseDebugListener splusEclipseDebugListener) {
        this.listeners.add(splusEclipseDebugListener);
    }

    public void removeDebugListener(SplusEclipseDebugListener splusEclipseDebugListener) {
        this.listeners.remove(splusEclipseDebugListener);
    }

    private void notifyListeners(int n) {
        SplusDebugEvent splusDebugEvent = new SplusDebugEvent(n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SplusEclipseDebugListener)this.listeners.get(i)).debugEventOccurred(splusDebugEvent);
        }
    }

    public synchronized void reset() {
        this.m_callStack = false;
        this.fTarget.reset();
    }

    public synchronized void setBreakpoint() {
        this.m_breakInfo = SplusDebugPlugin.getDefault().getDebugManager().getBreakInfo();
        this.m_breakAddress = SplusDebugPlugin.getDefault().getDebugManager().getBreakAddress();
        try {
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            IStackFrame[] iStackFrameArray = this.getStackFrames();
            String string = iStackFrameArray.length != 0 ? ((SplusDebugStackFrame)iStackFrameArray[0]).getSourceName() : "";
            this.setBreakpoints(null);
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                if (!(iBreakpointArray[i] instanceof SplusDebugLineBreakpoint) || !((SplusDebugLineBreakpoint)iBreakpointArray[i]).getBreakpointFunction().equals(string)) continue;
                long[] lArray = ((SplusDebugLineBreakpoint)iBreakpointArray[i]).getBreakpointAddress();
                boolean bl = true;
                for (int j = 0; bl && j < lArray.length && j < this.m_breakAddress.length; ++j) {
                    bl = lArray[j] - 1L == this.m_breakAddress[j];
                }
                if (!bl) continue;
                this.setBreakpoints(new IBreakpoint[]{iBreakpointArray[i]});
                break;
            }
        }
        catch (DebugException debugException) {
            debugException.printStackTrace();
        }
        this.notifyListeners(1);
    }

    public synchronized void setCallStack() {
        SplusDebugManager splusDebugManager = SplusDebugPlugin.getDefault().getDebugManager();
        int n = splusDebugManager.getNumCalls();
        int n2 = 0;
        if (n != 0) {
            if (SplusEditorPlugin.getDefault().getConsoleDocument().sendToOutput()) {
                if (n >= 6) {
                    n -= 6;
                    n2 = 6;
                }
            } else if (n >= 2) {
                n -= 2;
                n2 = 2;
            }
            this.m_callStackFrames = new SplusDebugStackFrame[n];
            int n3 = 0;
            int n4 = n2;
            int n5 = n - 1;
            while (n3 < n) {
                String string = splusDebugManager.getCallName(n4);
                String string2 = splusDebugManager.getContainerCallName(n4);
                String string3 = splusDebugManager.getCall(n4);
                this.m_callStackFrames[n5--] = new SplusDebugStackFrame(this, string, string2, string3, n3);
                ++n3;
                ++n4;
            }
            this.m_callStack = true;
            this.notifyListeners(7);
        }
    }
}

