/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.combination;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinableAxis;
import com.jrefinery.chart.combination.NumberAxisRange;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class CombinedVerticalNumberAxis
extends VerticalNumberAxis
implements CombinableAxis {
    private VerticalNumberAxis axis = null;
    private boolean visible = true;
    private double reserveWidth = 0.0;

    public CombinedVerticalNumberAxis(VerticalNumberAxis verticalNumberAxis) {
        this(verticalNumberAxis, true);
    }

    public CombinedVerticalNumberAxis(VerticalNumberAxis verticalNumberAxis, boolean bl) {
        super(verticalNumberAxis.getLabel(), verticalNumberAxis.getLabelFont(), verticalNumberAxis.getLabelPaint(), verticalNumberAxis.getLabelInsets(), verticalNumberAxis.isVerticalLabel(), verticalNumberAxis.isTickLabelsVisible(), verticalNumberAxis.getTickLabelFont(), verticalNumberAxis.getTickLabelPaint(), verticalNumberAxis.getTickLabelInsets(), verticalNumberAxis.isTickMarksVisible(), verticalNumberAxis.getTickMarkStroke(), verticalNumberAxis.isAutoRange(), verticalNumberAxis.autoRangeIncludesZero(), verticalNumberAxis.autoRangeStickyZero(), verticalNumberAxis.getAutoRangeMinimumSize(), verticalNumberAxis.getMinimumAxisValue(), verticalNumberAxis.getMaximumAxisValue(), verticalNumberAxis.isInverted(), verticalNumberAxis.isAutoTickUnitSelection(), verticalNumberAxis.getTickUnit(), verticalNumberAxis.isGridLinesVisible(), verticalNumberAxis.getGridStroke(), verticalNumberAxis.getGridPaint(), verticalNumberAxis.isCrosshairVisible(), verticalNumberAxis.getCrosshairValue(), verticalNumberAxis.getCrosshairStroke(), verticalNumberAxis.getCrosshairPaint());
        this.axis = verticalNumberAxis;
        this.visible = bl;
        this.setCrosshairVisible(verticalNumberAxis.isCrosshairVisible());
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.visible) {
            this.axis.draw(graphics2D, rectangle2D, rectangle2D2);
        } else if (this.gridLinesVisible) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setPaint(this.gridPaint);
            double d = rectangle2D2.getX();
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
                Line2D.Double double_ = new Line2D.Double(d, f, rectangle2D2.getMaxX(), f);
                graphics2D.draw(double_);
            }
        }
    }

    public void setReserveDimension(double d) {
        this.reserveWidth = d;
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.reserveWidth > 0.0) {
            return this.reserveWidth;
        }
        return this.axis.reserveWidth(graphics2D, plot, rectangle2D);
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), this.reserveWidth(graphics2D, plot, rectangle2D), rectangle2D.getHeight() - d);
    }

    public Axis getParentAxis() {
        return this.axis;
    }

    public AxisRange getRange() {
        this.autoAdjustRange();
        return new NumberAxisRange(new Double(this.getMinimumAxisValue()), new Double(this.getMaximumAxisValue()));
    }

    public void setRange(AxisRange axisRange) {
        this.setAutoRange(false);
        Number number = (Number)axisRange.getMin();
        Number number2 = (Number)axisRange.getMax();
        this.setMinimumAxisValue(number.doubleValue());
        this.setMaximumAxisValue(number2.doubleValue());
        if (this.visible) {
            VerticalNumberAxis verticalNumberAxis = (VerticalNumberAxis)this.getParentAxis();
            verticalNumberAxis.setAutoRange(false);
            verticalNumberAxis.setMinimumAxisValue(number.doubleValue());
            verticalNumberAxis.setMaximumAxisValue(number2.doubleValue());
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

