/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public abstract class AbstractLayoutManager
implements LayoutManager,
Constants {
    protected LayoutManager parentLM = null;
    protected List childLMs = null;
    protected ListIterator fobjIter = null;
    protected Map markers = null;
    private boolean bFinished = false;
    protected LayoutManager curChildLM = null;
    protected ListIterator childLMiter = null;
    protected static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$LayoutManager == null ? (class$org$apache$fop$layoutmgr$LayoutManager = AbstractLayoutManager.class$("org.apache.fop.layoutmgr.LayoutManager")) : class$org$apache$fop$layoutmgr$LayoutManager);
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$LayoutManager;

    public AbstractLayoutManager() {
    }

    public AbstractLayoutManager(FObj fo) {
        if (fo == null) {
            throw new IllegalStateException("Null formatting object found.");
        }
        this.markers = fo.getMarkers();
        this.fobjIter = fo.getChildNodes();
        this.childLMiter = new LMiter(this);
    }

    public void setParent(LayoutManager lm) {
        this.parentLM = lm;
    }

    public LayoutManager getParent() {
        return this.parentLM;
    }

    protected LayoutManager getChildLM() {
        if (this.curChildLM != null && !this.curChildLM.isFinished()) {
            return this.curChildLM;
        }
        if (this.childLMiter.hasNext()) {
            this.curChildLM = (LayoutManager)this.childLMiter.next();
            return this.curChildLM;
        }
        return null;
    }

    protected void reset(Position pos) {
        LayoutManager lm;
        LayoutManager layoutManager = lm = pos != null ? pos.getLM() : null;
        if (this.curChildLM != lm) {
            if (!this.childLMiter.hasPrevious() || this.curChildLM != (LayoutManager)this.childLMiter.previous()) {
                // empty if block
            }
            while (this.curChildLM != lm && this.childLMiter.hasPrevious()) {
                this.curChildLM.resetPosition(null);
                this.curChildLM = (LayoutManager)this.childLMiter.previous();
            }
            this.childLMiter.next();
        }
        if (this.curChildLM != null) {
            this.curChildLM.resetPosition(pos);
        }
        if (this.isFinished()) {
            this.setFinished(false);
        }
    }

    public void resetPosition(Position resetPos) {
    }

    public boolean isFinished() {
        return this.bFinished;
    }

    public void setFinished(boolean fin) {
        this.bFinished = fin;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        log.warn("null implementation of getNextKnuthElements() called!");
        this.setFinished(true);
        return null;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        log.warn("null implementation of getChangeKnuthElement() called!");
        return null;
    }

    public Area getParentArea(Area childArea) {
        return null;
    }

    public void addChildArea(Area childArea) {
    }

    protected List createChildLMs(int size) {
        if (this.fobjIter == null) {
            return null;
        }
        ArrayList newLMs = new ArrayList(size);
        while (this.fobjIter.hasNext() && newLMs.size() < size) {
            Object theobj = this.fobjIter.next();
            if (!(theobj instanceof FONode)) continue;
            FONode foNode = (FONode)theobj;
            if (foNode instanceof RetrieveMarker) {
                foNode = this.getPSLM().resolveRetrieveMarker((RetrieveMarker)foNode);
            }
            if (foNode == null) continue;
            this.getPSLM().getLayoutManagerMaker().makeLayoutManagers(foNode, newLMs);
        }
        return newLMs;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this.parentLM.getPSLM();
    }

    public PageViewport getCurrentPV() {
        return this.getPSLM().getCurrentPV();
    }

    public boolean createNextChildLMs(int pos) {
        List newLMs = this.createChildLMs(pos + 1 - this.childLMs.size());
        this.addChildLMs(newLMs);
        return pos < this.childLMs.size();
    }

    public List getChildLMs() {
        if (this.childLMs == null) {
            this.childLMs = new ArrayList(10);
        }
        return this.childLMs;
    }

    public void addChildLM(LayoutManager lm) {
        if (lm == null) {
            return;
        }
        lm.setParent(this);
        if (this.childLMs == null) {
            this.childLMs = new ArrayList(10);
        }
        this.childLMs.add(lm);
        log.trace(this.getClass().getName() + ": Adding child LM " + lm.getClass().getName());
    }

    public void addChildLMs(List newLMs) {
        if (newLMs == null || newLMs.size() == 0) {
            return;
        }
        ListIterator iter = newLMs.listIterator();
        while (iter.hasNext()) {
            LayoutManager lm = (LayoutManager)iter.next();
            this.addChildLM(lm);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

