/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.traits.MinOptMax;

public class MinOptMaxUtil {
    public static void restrict(MinOptMax mom, LengthRangeProperty lr) {
        if (lr.getEnum() != 9) {
            int opt;
            int max;
            int min;
            if (lr.getMinimum().getEnum() != 9 && (min = lr.getMinimum().getLength().getValue()) > mom.min) {
                mom.min = min;
                MinOptMaxUtil.fixAfterMinChanged(mom);
            }
            if (lr.getMaximum().getEnum() != 9 && (max = lr.getMaximum().getLength().getValue()) < mom.max) {
                mom.max = max;
                if (mom.max < mom.opt) {
                    mom.min = mom.opt = mom.max;
                }
            }
            if (lr.getOptimum().getEnum() != 9 && (opt = lr.getOptimum().getLength().getValue()) > mom.min) {
                mom.opt = opt;
                if (mom.opt > mom.max) {
                    mom.max = mom.opt;
                }
            }
        }
    }

    public static void extendMinimum(MinOptMax mom, int len, boolean optToLen) {
        if (mom.min < len) {
            mom.min = len;
            mom.opt = Math.max(mom.min, mom.opt);
            if (optToLen) {
                mom.opt = Math.min(mom.min, len);
            }
            mom.max = Math.max(mom.opt, mom.max);
        }
    }

    public static void fixAfterMinChanged(MinOptMax mom) {
        if (mom.min > mom.opt) {
            mom.opt = mom.min;
            if (mom.opt > mom.max) {
                mom.max = mom.opt;
            }
        }
    }

    public static MinOptMax toMinOptMax(LengthRangeProperty prop) {
        MinOptMax mom = new MinOptMax(prop.getMinimum().isAuto() ? 0 : prop.getMinimum().getLength().getValue(), prop.getOptimum().isAuto() ? 0 : prop.getOptimum().getLength().getValue(), prop.getMinimum().isAuto() ? Integer.MAX_VALUE : prop.getMaximum().getLength().getValue());
        return mom;
    }
}

