/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.geom.Rectangle2D;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.w3c.dom.Document;

public class InstreamForeignObjectLM
extends LeafNodeLayoutManager {
    private InstreamForeignObject fobj;

    public InstreamForeignObjectLM(InstreamForeignObject node) {
        super(node);
        this.fobj = node;
        Viewport areaCurrent = this.getInlineArea();
        this.setCurrentArea(areaCurrent);
        this.setAlignment(node.getVerticalAlign());
        this.setLead(areaCurrent.getBPD());
    }

    private Viewport getInlineArea() {
        int scaling;
        Length len;
        XMLObj child = (XMLObj)this.fobj.childNodes.get(0);
        boolean hasLH = false;
        int bpd = -1;
        int ipd = -1;
        boolean bpdauto = false;
        if (hasLH) {
            bpd = this.fobj.getLineHeight().getValue();
        } else {
            len = this.fobj.getBlockProgressionDimension().getOptimum().getLength();
            if (len.getEnum() != 9) {
                bpd = len.getValue();
            } else {
                len = this.fobj.getHeight();
                if (len.getEnum() != 9) {
                    bpd = len.getValue();
                }
            }
        }
        len = this.fobj.getInlineProgressionDimension().getOptimum().getLength();
        if (len.getEnum() != 9) {
            ipd = len.getValue();
        } else {
            len = this.fobj.getWidth();
            if (len.getEnum() != 9) {
                ipd = len.getValue();
            }
        }
        int cwidth = -1;
        int cheight = -1;
        len = this.fobj.getContentWidth();
        if (len.getEnum() != 9) {
            if (len.getEnum() == 125) {
                if (ipd != -1) {
                    cwidth = ipd;
                }
            } else {
                cwidth = len.getValue();
            }
        }
        if ((len = this.fobj.getContentHeight()).getEnum() != 9) {
            if (len.getEnum() == 125) {
                if (bpd != -1) {
                    cwidth = bpd;
                }
            } else {
                cheight = len.getValue();
            }
        }
        if ((scaling = this.fobj.getScaling()) == 154 || cwidth == -1 || cheight == -1) {
            if (cwidth == -1 && cheight == -1) {
                cwidth = this.fobj.getIntrinsicWidth();
                cheight = this.fobj.getIntrinsicHeight();
            } else if (cwidth == -1) {
                cwidth = (int)((double)this.fobj.getIntrinsicWidth() * (double)cheight / (double)this.fobj.getIntrinsicHeight());
            } else if (cheight == -1) {
                cheight = (int)((double)this.fobj.getIntrinsicHeight() * (double)cwidth / (double)this.fobj.getIntrinsicWidth());
            } else {
                double rat2;
                double rat1 = cwidth / this.fobj.getIntrinsicWidth();
                if (rat1 < (rat2 = (double)(cheight / this.fobj.getIntrinsicHeight()))) {
                    cheight = (int)(rat1 * (double)this.fobj.getIntrinsicHeight());
                } else if (rat1 > rat2) {
                    cwidth = (int)(rat2 * (double)this.fobj.getIntrinsicWidth());
                }
            }
        }
        if (ipd == -1) {
            ipd = cwidth;
        }
        if (bpd == -1) {
            bpd = cheight;
        }
        boolean clip = false;
        if (cwidth > ipd || cheight > bpd) {
            int overflow = this.fobj.getOverflow();
            if (overflow == 57) {
                clip = true;
            } else if (overflow == 42) {
                this.fobj.getLogger().error("Instream foreign object overflows the viewport: clipping");
                clip = true;
            }
        }
        int xoffset = this.fobj.computeXOffset(ipd, cwidth);
        int yoffset = this.fobj.computeYOffset(bpd, cheight);
        CommonBorderPaddingBackground borderProps = this.fobj.getCommonBorderPaddingBackground();
        int beforeBPD = borderProps.getPadding(0, false);
        int afterBPD = borderProps.getPadding(1, false);
        yoffset += (beforeBPD += borderProps.getBorderWidth(0, false));
        bpd += beforeBPD;
        bpd += (afterBPD += borderProps.getBorderWidth(1, false));
        int startIPD = borderProps.getPadding(2, false);
        int endIPD = borderProps.getPadding(3, false);
        ipd += startIPD;
        ipd += (endIPD += borderProps.getBorderWidth(3, false));
        Rectangle2D.Float placement = new Rectangle2D.Float(xoffset += (startIPD += borderProps.getBorderWidth(2, false)), yoffset, cwidth, cheight);
        Document doc = child.getDOMDocument();
        String ns = child.getDocumentNamespace();
        ForeignObject foreign = new ForeignObject(doc, ns);
        TraitSetter.setProducerID(foreign, this.fobj.getId());
        Viewport vp = new Viewport(foreign);
        TraitSetter.setProducerID(vp, this.fobj.getId());
        vp.setIPD(ipd);
        vp.setBPD(bpd);
        vp.setContentPosition(placement);
        vp.setClip(clip);
        vp.setOffset(0);
        TraitSetter.addBorders(vp, this.fobj.getCommonBorderPaddingBackground());
        TraitSetter.addBackground(vp, this.fobj.getCommonBorderPaddingBackground());
        return vp;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

