/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.IOException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.properties.ColorTypeProperty;
import org.apache.fop.render.awt.viewer.PreviewDialog;
import org.apache.fop.render.awt.viewer.Translator;
import org.apache.fop.render.java2d.Java2DRenderer;

public class AWTRenderer
extends Java2DRenderer
implements Pageable {
    public static final String MIME_TYPE = "application/X-awt";
    protected Translator translator = new Translator();
    public boolean debug;
    public boolean dialogDisplay = true;
    protected PreviewDialog frame;

    public void setUserAgent(FOUserAgent foUserAgent) {
        super.setUserAgent(foUserAgent);
        if (this.dialogDisplay) {
            this.createPreviewDialog();
        }
    }

    public void setPreviewDialogDisplayed(boolean show) {
        this.dialogDisplay = show;
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        super.renderPage(pageViewport);
        if (this.frame != null) {
            this.frame.setInfo();
        }
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        if (this.frame != null) {
            this.frame.setStatus(this.translator.getString("Status.Show"));
            this.frame.reload();
        }
    }

    public Dimension getPageImageSize(int pageNum) throws FOPException {
        Rectangle2D bounds = this.getPageViewport(pageNum).getViewArea();
        this.pageWidth = (int)Math.round(bounds.getWidth() / 1000.0);
        this.pageHeight = (int)Math.round(bounds.getHeight() / 1000.0);
        double scaleX = this.scaleFactor * 0.35277777910232544 / (double)this.userAgent.getPixelUnitToMillimeter();
        double scaleY = this.scaleFactor * 0.35277777910232544 / (double)this.userAgent.getPixelUnitToMillimeter();
        int bitmapWidth = (int)((double)this.pageWidth * scaleX + 0.5);
        int bitmapHeight = (int)((double)this.pageHeight * scaleY + 0.5);
        return new Dimension(bitmapWidth, bitmapHeight);
    }

    private PreviewDialog createPreviewDialog() {
        this.frame = new PreviewDialog(this.userAgent);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                System.exit(0);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.frame.setStatus(this.translator.getString("Status.Build.FO.tree"));
        this.frame.setVisible(true);
        return this.frame;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        try {
            if (pageIndex >= this.getNumberOfPages()) {
                return null;
            }
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            pageFormat.setPaper(paper);
            Rectangle2D dim = this.getPageViewport(pageIndex).getViewArea();
            double width = dim.getWidth();
            double height = dim.getHeight();
            if (width > height) {
                paper.setImageableArea(0.0, 0.0, height / 1000.0, width / 1000.0);
                paper.setSize(height / 1000.0, width / 1000.0);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, width / 1000.0, height / 1000.0);
                paper.setSize(width / 1000.0, height / 1000.0);
                pageFormat.setOrientation(1);
            }
            return pageFormat;
        }
        catch (FOPException fopEx) {
            throw new IndexOutOfBoundsException(fopEx.getMessage());
        }
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        if (this.debug) {
            this.debugBackAndBorders(area, startx, starty, width, height);
        }
        super.drawBackAndBorders(area, startx, starty, width, height);
    }

    private void debugBackAndBorders(Area area, float startx, float starty, float width, float height) {
        this.state.push();
        ColorTypeProperty ct = new ColorTypeProperty(0.7f, 0.7f, 0.7f);
        this.state.updateColor(ct, true, null);
        this.state.updateStroke(0.4f, 133);
        this.state.getGraph().draw(new Rectangle2D.Float(startx, starty, width, height));
        this.state.pop();
    }
}

