/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.server.util;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusStringDataResult;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.packages.SplusInstallLoadUpdatePackagesDialog;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.server.UiProperties;
import com.insightful.splus.eclipse.server.util.RemoteResults;
import com.insightful.splus.eclipse.server.util.SplusErrorWarningHandler;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteUtils {
    private static final String REMOTE_SETTINGS = "remoteSettings";
    private static final String SERVER_LOCATION = "com.insightful.splus.eclipse.server.remote";
    private static final String USERNAME = "com.insightful.splus.eclipse.server.username";
    private static IDialogSettings g_settings = null;
    static final String REMOTE_DECLARATION = UiProperties.getString("RemoteUtils.ServerJobPrefix");
    static final String EXECUTION_DEMARCATION = UiProperties.getString("RemoteUtils.ServerExecutionDemarcation");
    static final String STARTUP_DEMARCATION = UiProperties.getString("RemoteUtils.ServerStartupDemarcation");
    static final String REMOTE_DEMARCATION = UiProperties.getString("RemoteUtils.ServerOutputDemarcation");
    static final String REMOTE_DEMARCATION_END = UiProperties.getString("RemoteUtils.Demarcation");
    private static final String SOURCE_PREFIX = UiProperties.getString("RemoteUtils.SplusFunction_SourcePrefix");
    private static final String SOURCE_SUFFIX = UiProperties.getString("RemoteUtils.SplusFunction_SourceSuffix");

    private static IDialogSettings getDialogSettings() {
        SplusEditorPlugin splusEditorPlugin;
        IDialogSettings iDialogSettings;
        if (g_settings == null && (g_settings = (iDialogSettings = (splusEditorPlugin = SplusEditorPlugin.getDefault()).getDialogSettings()).getSection(REMOTE_SETTINGS)) == null) {
            g_settings = iDialogSettings.addNewSection(REMOTE_SETTINGS);
        }
        return g_settings;
    }

    public static String getDialogSetting(String string) {
        return RemoteUtils.getDialogSettings().get(string);
    }

    public static void setDialogSetting(String string, String string2) {
        RemoteUtils.getDialogSettings().put(string, string2);
    }

    public static void saveServerLocations(Combo combo) {
        SplusInstallLoadUpdatePackagesDialog.saveComboFromSettings((Combo)combo, (IDialogSettings)RemoteUtils.getDialogSettings(), (String)SERVER_LOCATION);
    }

    public static void loadServerLocations(Combo combo) {
        SplusInstallLoadUpdatePackagesDialog.loadComboFromSettings((Combo)combo, (IDialogSettings)RemoteUtils.getDialogSettings(), (String)SERVER_LOCATION);
    }

    public static void saveUserName(Text text) {
        RemoteUtils.getDialogSettings().put(USERNAME, text.getText());
    }

    public static void loadUserName(Text text) {
        String string = RemoteUtils.getDialogSettings().get(USERNAME);
        if (string == null) {
            string = "";
        }
        text.setText(string);
    }

    private static boolean handleErrorsAndWarnings(SplusDataResult splusDataResult, SplusErrorWarningHandler splusErrorWarningHandler) {
        boolean bl = false;
        if (splusDataResult.hasError()) {
            splusErrorWarningHandler.handleSplusError(splusDataResult);
            bl = true;
        } else if (splusDataResult.hasWarning()) {
            splusErrorWarningHandler.handleSplusWarnings(splusDataResult);
        }
        return bl;
    }

    private static String useSplusPathSeparator(String string) {
        return string.replaceAll("\\\\", "/").replace('\\', '/');
    }

    protected static String wrapSplusCodeToRetrieveOutputAndReturnValue(String string, NoConnection noConnection) {
        return SOURCE_PREFIX + noConnection.escapeSpecialCharacters(string) + SOURCE_SUFFIX;
    }

    protected static String unwrapSplusCodeToRetrieveOutputAndReturnValue(String string) {
        String string2 = string;
        if (string2.startsWith(SOURCE_PREFIX)) {
            string2 = string2.substring(SOURCE_PREFIX.length(), string2.length() - SOURCE_SUFFIX.length());
        }
        return string2;
    }

    public static RemoteResults runRemotely(String string, String string2, String string3, String string4, boolean bl, SplusErrorWarningHandler splusErrorWarningHandler) {
        DefaultConnection defaultConnection;
        SplusDataResult splusDataResult;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        String string5 = RemoteUtils.wrapSplusCodeToRetrieveOutputAndReturnValue(string4, noConnection);
        String string6 = UiProperties.getString("RemoteUtils.SplusFunction_ExpressionService_Call_Server") + string + UiProperties.getString("RemoteUtils.SplusFunction_ExpressionService_Username") + string2 + UiProperties.getString("RemoteUtils.SplusFunction_ExpressionService_Password") + string3 + UiProperties.getString("RemoteUtils.SplusFunction_ExpressionService_ExpressionString") + string5 + UiProperties.getString("RemoteUtils.SplusFunction_ExpressionService_Async") + (bl ? UiProperties.getString("RemoteUtils.SplusTrue") : UiProperties.getString("RemoteUtils.SplusFalse")) + UiProperties.getString("RemoteUtils.SplusFunction_ExpressionService_Suffix");
        RemoteResults remoteResults = null;
        if (noConnection instanceof DefaultConnection && !RemoteUtils.handleErrorsAndWarnings(splusDataResult = (defaultConnection = (DefaultConnection)noConnection).processDataQuery(string6), splusErrorWarningHandler)) {
            remoteResults = new RemoteResults(splusDataResult);
        }
        return remoteResults;
    }

    public static RemoteResults queryServer(String string, String string2, String string3, String string4, SplusErrorWarningHandler splusErrorWarningHandler) {
        DefaultConnection defaultConnection;
        SplusDataResult splusDataResult;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        String string5 = UiProperties.getString("RemoteUtils.SplusFunction_QueryExpressionService_Call_Server") + string + UiProperties.getString("RemoteUtils.SplusFunction_QueryExpressionService_Username") + string2 + UiProperties.getString("RemoteUtils.SplusFunction_QueryExpressionService_Password") + string3 + UiProperties.getString("RemoteUtils.SplusFunction_QueryExpressionService_JobId") + string4 + UiProperties.getString("RemoteUtils.SplusFunction_QueryExpressionService_Suffix");
        RemoteResults remoteResults = null;
        if (noConnection instanceof DefaultConnection && !RemoteUtils.handleErrorsAndWarnings(splusDataResult = (defaultConnection = (DefaultConnection)noConnection).processDataQuery(string5), splusErrorWarningHandler)) {
            remoteResults = new RemoteResults(splusDataResult);
        }
        return remoteResults;
    }

    public static List<RemoteResults> queryServer(String string, String string2, String string3, SplusErrorWarningHandler splusErrorWarningHandler) throws SplusBadDataException {
        DefaultConnection defaultConnection;
        SplusDataResult splusDataResult;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        String string4 = UiProperties.getString("RemoteUtils.SplusFunction_GetJobs_Call_Server") + string + UiProperties.getString("RemoteUtils.SplusFunction_GetJobs_Username") + string2 + UiProperties.getString("RemoteUtils.SplusFunction_GetJobs_Password") + string3 + UiProperties.getString("RemoteUtils.SplusFunction_GetJobs_Suffix");
        LinkedList<RemoteResults> linkedList = new LinkedList<RemoteResults>();
        if (noConnection instanceof DefaultConnection && !RemoteUtils.handleErrorsAndWarnings(splusDataResult = (defaultConnection = (DefaultConnection)noConnection).processDataQuery(string4), splusErrorWarningHandler)) {
            RemoteResults[] remoteResultsArray = RemoteResults.getRemoteResults(splusDataResult.getStringData());
            for (int i = 0; i < remoteResultsArray.length; ++i) {
                linkedList.add(remoteResultsArray[i]);
            }
        }
        return linkedList;
    }

    public static boolean uploadFile(String string, String string2, String string3, String string4, String string5, SplusErrorWarningHandler splusErrorWarningHandler) throws SplusBadDataException {
        DefaultConnection defaultConnection;
        SplusDataResult splusDataResult;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        String string6 = UiProperties.getString("RemoteUtils.SplusFunction_UploadFile_Call_Server") + string + UiProperties.getString("RemoteUtils.SplusFunction_UploadFile_Username") + string2 + UiProperties.getString("RemoteUtils.SplusFunction_UploadFile_Password") + string3 + UiProperties.getString("RemoteUtils.SplusFunction_UploadFile_RemoteDest") + RemoteUtils.useSplusPathSeparator(string4) + UiProperties.getString("RemoteUtils.SplusFunction_UploadFile_LocalLoc") + RemoteUtils.useSplusPathSeparator(string5) + UiProperties.getString("RemoteUtils.SplusFunction_UploadFile_Suffix");
        boolean bl = false;
        if (noConnection instanceof DefaultConnection && !RemoteUtils.handleErrorsAndWarnings(splusDataResult = (defaultConnection = (DefaultConnection)noConnection).processDataQuery(string6), splusErrorWarningHandler)) {
            bl = splusDataResult.getBooleanData()[0];
        }
        return bl;
    }

    public static boolean downloadFile(String string, String string2, String string3, String string4, String string5, SplusErrorWarningHandler splusErrorWarningHandler) throws SplusBadDataException {
        DefaultConnection defaultConnection;
        SplusDataResult splusDataResult;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        String string6 = UiProperties.getString("RemoteUtils.SplusFunction_DownloadFile_Call_Server") + string + UiProperties.getString("RemoteUtils.SplusFunction_DownloadFile_Username") + string2 + UiProperties.getString("RemoteUtils.SplusFunction_DownloadFile_Password") + string3 + UiProperties.getString("RemoteUtils.SplusFunction_DownloadFile_RemoteLoc") + RemoteUtils.useSplusPathSeparator(string4) + UiProperties.getString("RemoteUtils.SplusFunction_DownloadFile_LocalDest") + RemoteUtils.useSplusPathSeparator(string5) + UiProperties.getString("RemoteUtils.SplusFunction_DownloadFile_Suffix");
        boolean bl = false;
        if (noConnection instanceof DefaultConnection && !RemoteUtils.handleErrorsAndWarnings(splusDataResult = (defaultConnection = (DefaultConnection)noConnection).processDataQuery(string6), splusErrorWarningHandler)) {
            bl = splusDataResult.getBooleanData()[0];
        }
        return bl;
    }

    public static String[] getFolderContents(String string, String string2, String string3, String string4, SplusErrorWarningHandler splusErrorWarningHandler) throws SplusBadDataException {
        DefaultConnection defaultConnection;
        SplusDataResult splusDataResult;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        String string5 = UiProperties.getString("RemoteUtils.SplusFunction_GetFolderContents_Call_Server") + string + UiProperties.getString("RemoteUtils.SplusFunction_GetFolderContents_Username") + string2 + UiProperties.getString("RemoteUtils.SplusFunction_GetFolderContents_Password") + string3 + UiProperties.getString("RemoteUtils.SplusFunction_GetFolderContents_RemoteLoc") + RemoteUtils.useSplusPathSeparator(string4) + UiProperties.getString("RemoteUtils.SplusFunction_GetFolderContents_Suffix");
        String[] stringArray = null;
        if (noConnection instanceof DefaultConnection && !RemoteUtils.handleErrorsAndWarnings(splusDataResult = (defaultConnection = (DefaultConnection)noConnection).processDataQuery(string5), splusErrorWarningHandler)) {
            if (splusDataResult instanceof SplusStringDataResult) {
                stringArray = splusDataResult.getStringData();
            } else if (splusDataResult.getClass().equals(SplusDataResult.class)) {
                stringArray = new String[]{};
            } else {
                throw new SplusBadDataException(UiProperties.getString("RemoteUtils.SplusQueryProducedNoStringResults"));
            }
        }
        return stringArray;
    }

    public static void sendOutputToWorkbench(String string) {
        if (string != null) {
            Object object;
            boolean bl = SplusPreferencePage.getSendRunOutputToConsole();
            if (bl) {
                object = "\n" + string + "\n\n";
                String[] stringArray = ((String)object).split("\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i] + "\n";
                }
                ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
                consoleHistoryDocument.addOutputLines(stringArray);
                consoleHistoryDocument.getAndDisplayOutput();
            } else {
                object = SplusEditorPlugin.getDefault().getOutputDocument();
                try {
                    int n = 0;
                    int n2 = 0;
                    String string2 = System.getProperty("cummulative.output.view");
                    if (string2 == null || !string2.equals("T")) {
                        n2 = object.getLength();
                    } else {
                        n = object.getLength();
                    }
                    object.replace(n, n2, string);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            object = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (object != null) {
                try {
                    if (bl) {
                        object.getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                    } else {
                        object.getActivePage().showView("com.insightful.splus.eclipse.views.OutputView");
                    }
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                }
            }
        }
    }
}

