/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected double shapeScale = 6.0;
    protected Line2D line;

    public StandardXYItemRenderer() {
        this(1);
    }

    public StandardXYItemRenderer(int n) {
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public Shape drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, double d, CrosshairInfo crosshairInfo) {
        Object object = null;
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 != null) {
            Object object2;
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            double d3 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
            if (this.plotShapes) {
                object2 = xYPlot.getShape(n, n2, d2, d3, this.shapeScale);
                graphics2D.draw((Shape)object2);
                object = object2;
            }
            if (this.plotLines && n2 > 0) {
                object2 = xYDataset.getXValue(n, n2 - 1);
                Number number3 = xYDataset.getYValue(n, n2 - 1);
                if (number3 != null) {
                    double d4 = valueAxis.translateValueToJava2D(((Number)object2).doubleValue(), rectangle2D);
                    double d5 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D);
                    this.line.setLine(d4, d5, d2, d3);
                    graphics2D.draw(this.line);
                }
            }
            double d6 = 0.0;
            if (valueAxis.isCrosshairLockedOnData()) {
                if (valueAxis2.isCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
                } else {
                    crosshairInfo.updateCrosshairX(number.doubleValue());
                }
            } else if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(number2.doubleValue());
            }
        }
        return object;
    }
}

