/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.FFTmediaLib;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibDFTOpImage;
import com.sun.media.jai.opimage.DFTOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.MathJAI;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import javax.media.jai.operator.DFTDescriptor;

public class MlibDFTRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(new ParameterBlock())) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Integer n = (Integer)parameterBlock.getObjectParameter(0);
        Integer n2 = (Integer)parameterBlock.getObjectParameter(1);
        boolean bl = n2.equals(DFTDescriptor.REAL_TO_COMPLEX) ^ true;
        int n3 = renderedImage.getSampleModel().getNumBands();
        if ((bl && n3 == 2 || !bl && n3 == 1) && MlibDFTOpImage.isAcceptableSampleModel(renderedImage.getSampleModel())) {
            int n4 = renderedImage.getWidth();
            int n5 = renderedImage.getHeight();
            if (!MathJAI.isPositivePowerOf2(n4) || !MathJAI.isPositivePowerOf2(n5)) {
                ParameterBlock parameterBlock2 = new ParameterBlock();
                parameterBlock2.addSource(renderedImage);
                parameterBlock2.add(0);
                parameterBlock2.add(MathJAI.nextPositivePowerOf2(n4) - n4);
                parameterBlock2.add(0);
                parameterBlock2.add(MathJAI.nextPositivePowerOf2(n5) - n5);
                parameterBlock2.add(0);
                renderedImage = JAI.create("border", parameterBlock2);
            }
            return new MlibDFTOpImage(renderedImage, tileCache, imageLayout, n2, true, n);
        }
        FFTmediaLib fFTmediaLib = new FFTmediaLib(true, n, 2);
        return new DFTOpImage(renderedImage, tileCache, imageLayout, n2, fFTmediaLib);
    }
}

