/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;
import javax.media.jai.TileCache;

final class ScaleBilinearOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    Rational half = new Rational(1L, 2L);
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;
    int dwidth;
    int dheight;
    int[] xpos;
    int[] ypos;
    int[] xfracvalues;
    int[] yfracvalues;
    float[] xfracvaluesFloat;
    float[] yfracvaluesFloat;
    int srcPixelStride;
    int srcScanlineStride;

    public ScaleBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, f, f2, f3, f4, interpolation, true);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            byte[] byArray3 = byArray[n4];
            byte[] byArray4 = byArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 + this.srcScanlineStride;
                int n12 = 0;
                while (n12 < this.dwidth) {
                    int n13 = this.xfracvalues[n12];
                    int n14 = this.xpos[n12];
                    int n15 = n14 + this.srcPixelStride;
                    int n16 = byArray4[n14 + n10] & 0xFF;
                    int n17 = byArray4[n15 + n10] & 0xFF;
                    int n18 = byArray4[n14 + n11] & 0xFF;
                    int n19 = byArray4[n15 + n11] & 0xFF;
                    int n20 = (n17 - n16) * n13 + (n16 << this.subsampleBits);
                    int n21 = (n19 - n18) * n13 + (n18 << this.subsampleBits);
                    int n22 = (n21 - n20) * n9 + (n20 << this.subsampleBits) + this.round2 >> this.shift2;
                    byArray3[n8] = (byte)(n22 & 0xFF);
                    n8 += n2;
                    ++n12;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        this.dwidth = rectangle.width;
        this.dheight = rectangle.height;
        this.srcPixelStride = rasterAccessor.getPixelStride();
        this.srcScanlineStride = rasterAccessor.getScanlineStride();
        this.ypos = new int[this.dheight];
        this.xpos = new int[this.dwidth];
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 2: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 1: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 3: {
                this.preComputePositionsInt(rectangle, n, n2);
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 4: {
                this.preComputePositionsFloat(rectangle, n, n2);
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 5: {
                this.preComputePositionsFloat(rectangle, n, n2);
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            double[] dArray3 = dArray[n4];
            double[] dArray4 = dArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                double d = this.yfracvaluesFloat[n7];
                int n9 = this.ypos[n7] + n6;
                int n10 = n9 + this.srcScanlineStride;
                int n11 = 0;
                while (n11 < this.dwidth) {
                    double d2 = this.xfracvaluesFloat[n11];
                    int n12 = this.xpos[n11];
                    int n13 = n12 + this.srcPixelStride;
                    double d3 = dArray4[n12 + n9];
                    double d4 = dArray4[n13 + n9];
                    double d5 = dArray4[n12 + n10];
                    double d6 = dArray4[n13 + n10];
                    double d7 = (d4 - d3) * d2 + d3;
                    double d8 = (d6 - d5) * d2 + d5;
                    dArray3[n8] = (d8 - d7) * d + d7;
                    n8 += n2;
                    ++n11;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n6 = 0;
        while (n6 < n) {
            float[] fArray3 = fArray[n6];
            float[] fArray4 = fArray2[n6];
            int n7 = nArray[n6];
            int n8 = nArray2[n6];
            int n9 = 0;
            while (n9 < this.dheight) {
                int n10 = n7;
                float f = this.yfracvaluesFloat[n9];
                int n11 = this.ypos[n9] + n8;
                int n12 = n11 + n5;
                int n13 = 0;
                while (n13 < this.dwidth) {
                    float f2 = this.xfracvaluesFloat[n13];
                    int n14 = this.xpos[n13];
                    int n15 = n14 + n4;
                    float f3 = fArray4[n14 + n11];
                    float f4 = fArray4[n15 + n11];
                    float f5 = fArray4[n14 + n12];
                    float f6 = fArray4[n15 + n12];
                    float f7 = (f4 - f3) * f2 + f3;
                    float f8 = (f6 - f5) * f2 + f5;
                    fArray3[n10] = (f8 - f7) * f + f7;
                    n10 += n2;
                    ++n13;
                }
                n7 += n3;
                ++n9;
            }
            ++n6;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            int[] nArray5 = nArray[n4];
            int[] nArray6 = nArray3[n4];
            int n5 = nArray2[n4];
            int n6 = nArray4[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 + this.srcScanlineStride;
                int n12 = 0;
                while (n12 < this.dwidth) {
                    int n13 = this.xfracvalues[n12];
                    int n14 = this.xpos[n12];
                    int n15 = n14 + this.srcPixelStride;
                    int n16 = nArray6[n14 + n10];
                    int n17 = nArray6[n15 + n10];
                    int n18 = nArray6[n14 + n11];
                    int n19 = nArray6[n15 + n11];
                    int n20 = (n17 - n16) * n13 + (n16 << this.subsampleBits);
                    int n21 = (n19 - n18) * n13 + (n18 << this.subsampleBits);
                    nArray5[n8] = (n21 - n20) * n9 + (n20 << this.subsampleBits) + this.round2 >> this.shift2;
                    n8 += n2;
                    ++n12;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        this.yfracvaluesFloat = new float[this.dheight];
        long l = n4;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n5 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n5 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        this.xfracvaluesFloat = new float[this.dwidth];
        long l6 = n3;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n6 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n6 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n7 = 0;
        while (n7 < this.dwidth) {
            this.xpos[n7] = (n6 - n) * this.srcPixelStride;
            this.xfracvaluesFloat[n7] = (float)l8 / (float)l9;
            n6 = (int)((long)n6 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n6;
                l8 -= l9;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.dheight) {
            this.ypos[n8] = (n5 - n2) * this.srcScanlineStride;
            this.yfracvaluesFloat[n8] = (float)l3 / (float)l4;
            n5 = (int)((long)n5 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n5;
                l3 -= l4;
            }
            ++n8;
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        this.yfracvalues = new int[this.dheight];
        long l = n4;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n5 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n5 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        this.xfracvalues = new int[this.dwidth];
        long l6 = n3;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n6 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n6 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n7 = 0;
        while (n7 < this.dwidth) {
            this.xpos[n7] = (n6 - n) * this.srcPixelStride;
            this.xfracvalues[n7] = (int)((float)l8 / (float)l9 * (float)this.one);
            n6 = (int)((long)n6 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n6;
                l8 -= l9;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.dheight) {
            this.ypos[n8] = (n5 - n2) * this.srcScanlineStride;
            this.yfracvalues[n8] = (int)((float)l3 / (float)l4 * (float)this.one);
            n5 = (int)((long)n5 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n5;
                l3 -= l4;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 + this.srcScanlineStride;
                int n12 = 0;
                while (n12 < this.dwidth) {
                    int n13 = this.xfracvalues[n12];
                    int n14 = this.xpos[n12];
                    int n15 = n14 + this.srcPixelStride;
                    short s = sArray4[n14 + n10];
                    short s2 = sArray4[n15 + n10];
                    short s3 = sArray4[n14 + n11];
                    short s4 = sArray4[n15 + n11];
                    int n16 = (s2 - s) * n13 + (s << this.subsampleBits);
                    int n17 = (s4 - s3) * n13 + (s3 << this.subsampleBits);
                    int n18 = (n17 - n16) * n9 + (n16 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n8] = (short)n18;
                    n8 += n2;
                    ++n12;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n5;
                int n9 = this.yfracvalues[n7];
                int n10 = this.ypos[n7] + n6;
                int n11 = n10 + this.srcScanlineStride;
                int n12 = 0;
                while (n12 < this.dwidth) {
                    int n13 = this.xfracvalues[n12];
                    int n14 = this.xpos[n12];
                    int n15 = n14 + this.srcPixelStride;
                    int n16 = sArray4[n14 + n10] & 0xFFFF;
                    int n17 = sArray4[n15 + n10] & 0xFFFF;
                    int n18 = sArray4[n14 + n11] & 0xFFFF;
                    int n19 = sArray4[n15 + n11] & 0xFFFF;
                    int n20 = (n17 - n16) * n13 + (n16 << this.subsampleBits);
                    int n21 = (n19 - n18) * n13 + (n18 << this.subsampleBits);
                    int n22 = (n21 - n20) * n9 + (n20 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n8] = (short)(n22 & 0xFFFF);
                    n8 += n2;
                    ++n12;
                }
                n5 += n3;
                ++n7;
            }
            ++n4;
        }
    }
}

