/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;
import javax.media.jai.TileCache;

final class ScaleNearestOpImage
extends ScaleOpImage {
    int dwidth;
    int dheight;
    int[] xvalues;
    int[] yvalues;
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleNearestOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, borderExtender, tileCache, imageLayout, f, f2, f3, f4, interpolation, true);
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            if (imageLayout != null) {
                this.sampleModel = imageLayout.getSampleModel(renderedImage);
                this.colorModel = imageLayout.getColorModel(renderedImage);
            } else {
                this.sampleModel = renderedImage.getSampleModel();
                this.colorModel = renderedImage.getColorModel();
            }
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n = rasterAccessor2.getPixelStride();
        int n2 = rasterAccessor2.getScanlineStride();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            byte[] byArray3 = byArray[n4];
            byte[] byArray4 = byArray2[n4];
            int n5 = nArray2[n4];
            int n6 = nArray[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n6;
                int n9 = this.yvalues[n7] + n5;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    int n11 = this.xvalues[n10];
                    int n12 = n11 + n9;
                    byArray3[n8] = byArray4[n12];
                    n8 += n;
                    ++n10;
                }
                n6 += n2;
                ++n7;
            }
            ++n4;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        this.dwidth = rectangle.width;
        this.dheight = rectangle.height;
        this.xvalues = new int[this.dwidth];
        long l = n5;
        long l2 = 1L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l = 2L * l + (l2 *= this.transXRationalDenom);
        l2 *= 2L;
        int n7 = Rational.floor(l *= this.invScaleXRationalNum, l2 *= this.invScaleXRationalDenom);
        long l3 = l % l2;
        if (n7 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleXRationalDenom;
        l3 *= this.invScaleXRationalDenom;
        long l5 = this.invScaleXFrac * l2;
        int n8 = 0;
        while (n8 < this.dwidth) {
            this.xvalues[n8] = (n7 - n) * n4;
            n7 = (int)((long)n7 + this.invScaleXInt);
            if ((l3 += l5) >= l4) {
                ++n7;
                l3 -= l4;
            }
            ++n8;
        }
        this.yvalues = new int[this.dheight];
        long l6 = n6;
        long l7 = 1L;
        l6 = l6 * this.transYRationalDenom - this.transYRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transYRationalDenom);
        l7 *= 2L;
        int n9 = Rational.floor(l6 *= this.invScaleYRationalNum, l7 *= this.invScaleYRationalDenom);
        long l8 = l6 % l7;
        if (n9 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleYRationalDenom;
        l8 *= this.invScaleYRationalDenom;
        long l10 = this.invScaleYFrac * l7;
        int n10 = 0;
        while (n10 < this.dheight) {
            this.yvalues[n10] = (n9 - n2) * n3;
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l8 += l10) >= l9) {
                ++n9;
                l8 -= l9;
            }
            ++n10;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            double[] dArray3 = dArray[n4];
            double[] dArray4 = dArray2[n4];
            int n5 = nArray2[n4];
            int n6 = nArray[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n6;
                int n9 = this.yvalues[n7] + n5;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    int n11 = this.xvalues[n10];
                    int n12 = n11 + n9;
                    dArray3[n8] = dArray4[n12];
                    n8 += n2;
                    ++n10;
                }
                n6 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            float[] fArray3 = fArray[n4];
            float[] fArray4 = fArray2[n4];
            int n5 = nArray2[n4];
            int n6 = nArray[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n6;
                int n9 = this.yvalues[n7] + n5;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    int n11 = this.xvalues[n10];
                    int n12 = n11 + n9;
                    fArray3[n8] = fArray4[n12];
                    n8 += n2;
                    ++n10;
                }
                n6 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n2 = rasterAccessor2.getPixelStride();
        int n3 = rasterAccessor2.getScanlineStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            int[] nArray5 = nArray[n4];
            int[] nArray6 = nArray4[n4];
            int n5 = nArray3[n4];
            int n6 = nArray2[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n6;
                int n9 = this.yvalues[n7] + n5;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    int n11 = this.xvalues[n10];
                    int n12 = n11 + n9;
                    nArray5[n8] = nArray6[n12];
                    n8 += n2;
                    ++n10;
                }
                n6 += n3;
                ++n7;
            }
            ++n4;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2) {
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n = rasterAccessor2.getPixelStride();
        int n2 = rasterAccessor2.getScanlineStride();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            short[] sArray3 = sArray[n4];
            short[] sArray4 = sArray2[n4];
            int n5 = nArray2[n4];
            int n6 = nArray[n4];
            int n7 = 0;
            while (n7 < this.dheight) {
                int n8 = n6;
                int n9 = this.yvalues[n7] + n5;
                int n10 = 0;
                while (n10 < this.dwidth) {
                    int n11 = this.xvalues[n10];
                    int n12 = n11 + n9;
                    sArray3[n8] = sArray4[n12];
                    n8 += n;
                    ++n10;
                }
                n6 += n2;
                ++n7;
            }
            ++n4;
        }
    }
}

