/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import javax.media.jai.RasterAccessor;

public final class ImageUtil {
    private static final float FLOAT_MIN = -3.4028235E38f;
    public static final int BYTE_MASK = 255;
    public static final int USHORT_MASK = 65535;

    public static final byte clampByte(int n) {
        return n > 255 ? (byte)-1 : (n >= 0 ? (byte)n : (byte)0);
    }

    public static final byte clampByteNegative(int n) {
        return n < 0 ? (byte)0 : (byte)n;
    }

    public static final byte clampBytePositive(int n) {
        return (byte)(n > 255 ? -1 : (byte)n);
    }

    public static final float clampFloat(double d) {
        return d > 3.4028234663852886E38 ? Float.MAX_VALUE : (d >= -3.4028234663852886E38 ? (float)d : -3.4028235E38f);
    }

    public static final int clampInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l >= Integer.MIN_VALUE ? (int)l : Integer.MIN_VALUE);
    }

    public static final byte clampRoundByte(double d) {
        return d > 255.0 ? (byte)-1 : (d >= 0.0 ? (byte)(d + 0.5) : (byte)0);
    }

    public static final byte clampRoundByte(float f) {
        return f > 255.0f ? (byte)-1 : (f >= 0.0f ? (byte)(f + 0.5f) : (byte)0);
    }

    public static final int clampRoundInt(double d) {
        return d > 2.147483647E9 ? Integer.MAX_VALUE : (d >= -2.147483648E9 ? (int)Math.floor(d + 0.5) : Integer.MIN_VALUE);
    }

    public static final int clampRoundInt(float f) {
        return f > 2.1474836E9f ? Integer.MAX_VALUE : (f >= -2.1474836E9f ? (int)Math.floor(f + 0.5f) : Integer.MIN_VALUE);
    }

    public static final short clampRoundShort(double d) {
        return (short)(d > 32767.0 ? Short.MAX_VALUE : (d >= -32768.0 ? (int)((int)Math.floor(d + 0.5)) : Short.MIN_VALUE));
    }

    public static final short clampRoundShort(float f) {
        return (short)(f > 32767.0f ? Short.MAX_VALUE : (f >= -32768.0f ? (int)((int)Math.floor(f + 0.5f)) : Short.MIN_VALUE));
    }

    public static final short clampRoundUShort(double d) {
        return d > 65535.0 ? (short)-1 : (d >= 0.0 ? (short)(d + 0.5) : (short)0);
    }

    public static final short clampRoundUShort(float f) {
        return f > 65535.0f ? (short)-1 : (f >= 0.0f ? (short)(f + 0.5f) : (short)0);
    }

    public static final short clampShort(int n) {
        return (short)(n > Short.MAX_VALUE ? Short.MAX_VALUE : (n >= Short.MIN_VALUE ? (int)n : Short.MIN_VALUE));
    }

    public static final short clampUShort(int n) {
        return n > 65535 ? (short)-1 : (n >= 0 ? (short)n : (short)0);
    }

    public static final short clampUShortNegative(int n) {
        return n < 0 ? (short)0 : (short)n;
    }

    public static final short clampUShortPositive(int n) {
        return (short)(n > 65535 ? -1 : (short)n);
    }

    public static final void copyRaster(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getWidth() * n3;
        int n6 = rasterAccessor2.getHeight() * n4;
        int n7 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                byte[][] byArray = rasterAccessor.getByteDataArrays();
                byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
                int n8 = 0;
                while (n8 < n7) {
                    byte[] byArray3 = byArray[n8];
                    byte[] byArray4 = byArray2[n8];
                    int n9 = nArray2[n8] + n6;
                    int n10 = nArray2[n8];
                    int n11 = nArray[n8];
                    while (n10 < n9) {
                        int n12 = n10 + n5;
                        int n13 = n10;
                        int n14 = n11;
                        while (n13 < n12) {
                            byArray4[n13] = byArray3[n14];
                            n13 += n3;
                            n14 += n;
                        }
                        n10 += n4;
                        n11 += n2;
                    }
                    ++n8;
                }
                break;
            }
            case 1: 
            case 2: {
                short[][] sArray = rasterAccessor.getShortDataArrays();
                short[][] sArray2 = rasterAccessor2.getShortDataArrays();
                int n15 = 0;
                while (n15 < n7) {
                    short[] sArray3 = sArray[n15];
                    short[] sArray4 = sArray2[n15];
                    int n16 = nArray2[n15] + n6;
                    int n17 = nArray2[n15];
                    int n18 = nArray[n15];
                    while (n17 < n16) {
                        int n19 = n17 + n5;
                        int n20 = n17;
                        int n21 = n18;
                        while (n20 < n19) {
                            sArray4[n20] = sArray3[n21];
                            n20 += n3;
                            n21 += n;
                        }
                        n17 += n4;
                        n18 += n2;
                    }
                    ++n15;
                }
                break;
            }
            case 3: {
                int[][] nArray3 = rasterAccessor.getIntDataArrays();
                int[][] nArray4 = rasterAccessor2.getIntDataArrays();
                int n22 = 0;
                while (n22 < n7) {
                    int[] nArray5 = nArray3[n22];
                    int[] nArray6 = nArray4[n22];
                    int n23 = nArray2[n22] + n6;
                    int n24 = nArray2[n22];
                    int n25 = nArray[n22];
                    while (n24 < n23) {
                        int n26 = n24 + n5;
                        int n27 = n24;
                        int n28 = n25;
                        while (n27 < n26) {
                            nArray6[n27] = nArray5[n28];
                            n27 += n3;
                            n28 += n;
                        }
                        n24 += n4;
                        n25 += n2;
                    }
                    ++n22;
                }
                break;
            }
            case 4: {
                float[][] fArray = rasterAccessor.getFloatDataArrays();
                float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
                int n29 = 0;
                while (n29 < n7) {
                    float[] fArray3 = fArray[n29];
                    float[] fArray4 = fArray2[n29];
                    int n30 = nArray2[n29] + n6;
                    int n31 = nArray2[n29];
                    int n32 = nArray[n29];
                    while (n31 < n30) {
                        int n33 = n31 + n5;
                        int n34 = n31;
                        int n35 = n32;
                        while (n34 < n33) {
                            fArray4[n34] = fArray3[n35];
                            n34 += n3;
                            n35 += n;
                        }
                        n31 += n4;
                        n32 += n2;
                    }
                    ++n29;
                }
                break;
            }
            case 5: {
                double[][] dArray = rasterAccessor.getDoubleDataArrays();
                double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
                int n36 = 0;
                while (n36 < n7) {
                    double[] dArray3 = dArray[n36];
                    double[] dArray4 = dArray2[n36];
                    int n37 = nArray2[n36] + n6;
                    int n38 = nArray2[n36];
                    int n39 = nArray[n36];
                    while (n38 < n37) {
                        int n40 = n38 + n5;
                        int n41 = n38;
                        int n42 = n39;
                        while (n41 < n40) {
                            dArray4[n41] = dArray3[n42];
                            n41 += n3;
                            n42 += n;
                        }
                        n38 += n4;
                        n39 += n2;
                    }
                    ++n36;
                }
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }
}

