/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.CachedTile;
import com.sun.media.jai.util.JaiI18N;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.jai.TileCache;

public class SunTileCache
implements TileCache {
    private static final long DEFAULT_MEMORY_CAPACITY = 0x1000000L;
    private static final long AVERAGE_TILE_SIZE = 12288L;
    private Hashtable cache;
    private long memoryCapacity;
    private long memoryUsage = 0L;
    private long timeStamp = 0L;
    private CachedTile first = null;
    private CachedTile last = null;

    public SunTileCache() {
        this(0x1000000L);
    }

    public SunTileCache(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileCache"));
        }
        this.memoryCapacity = l;
        this.cache = new Hashtable((int)(l / 12288L));
    }

    private final synchronized void add(CachedTile cachedTile) {
        cachedTile.timeStamp = this.timeStamp++;
        cachedTile.previous = null;
        cachedTile.next = this.first;
        if (this.first == null && this.last == null) {
            this.first = cachedTile;
            this.last = cachedTile;
        } else {
            this.first.previous = cachedTile;
            this.first = cachedTile;
        }
        this.cache.put(cachedTile.key, cachedTile);
        this.memoryUsage += cachedTile.memorySize;
    }

    public void add(RenderedImage renderedImage, int n, int n2, Raster raster) {
        if (this.getTile(renderedImage, n, n2) == null) {
            this.add(new CachedTile(renderedImage, n, n2, raster));
            if (this.memoryUsage > this.memoryCapacity) {
                this.memoryControl();
            }
        }
    }

    public synchronized void flush() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            this.remove(l);
        }
        this.cache = new Hashtable((int)(this.memoryCapacity / 12288L));
        this.memoryUsage = 0L;
    }

    protected Object getCacheObject() {
        return this.cache;
    }

    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public Raster getTile(RenderedImage renderedImage, int n, int n2) {
        Raster raster = null;
        Long l = CachedTile.hashKey(renderedImage, n, n2);
        CachedTile cachedTile = (CachedTile)this.cache.get(l);
        if (cachedTile != null) {
            raster = cachedTile.getTile();
            this.update(cachedTile);
        }
        return raster;
    }

    public int getTileCapacity() {
        return 0;
    }

    private final synchronized void memoryControl() {
        long l = (long)((float)this.memoryCapacity * 0.75f);
        while (this.memoryUsage > l && this.last != null) {
            this.cache.remove(this.last.key);
            this.memoryUsage -= this.last.memorySize;
            this.last = this.last.previous;
            if (this.last != null) {
                this.last.next.previous = null;
                this.last.next = null;
                continue;
            }
            this.first = null;
        }
    }

    public void remove(RenderedImage renderedImage, int n, int n2) {
        this.remove(CachedTile.hashKey(renderedImage, n, n2));
    }

    private final synchronized void remove(Long l) {
        CachedTile cachedTile = (CachedTile)this.cache.remove(l);
        if (cachedTile != null) {
            this.memoryUsage -= cachedTile.memorySize;
            if (cachedTile == this.first) {
                if (cachedTile == this.last) {
                    this.first = null;
                    this.last = null;
                } else {
                    this.first = cachedTile.next;
                    this.first.previous = null;
                }
            } else if (cachedTile == this.last) {
                this.last = cachedTile.previous;
                this.last.next = null;
            } else {
                cachedTile.previous.next = cachedTile.next;
                cachedTile.next.previous = cachedTile.previous;
            }
            cachedTile.previous = null;
            cachedTile.next = null;
        }
    }

    public synchronized void removeTiles(RenderedImage renderedImage) {
        int n = renderedImage.getMinTileX();
        int n2 = renderedImage.getMinTileY();
        int n3 = renderedImage.getNumXTiles();
        int n4 = n + n3;
        int n5 = n2 + renderedImage.getNumYTiles();
        int n6 = renderedImage.hashCode();
        int n7 = n2;
        while (n7 < n5) {
            int n8 = n;
            while (n8 < n4) {
                this.remove(CachedTile.hashKey(n6, n7 * n3 + n8));
                ++n8;
            }
            ++n7;
        }
    }

    public void setMemoryCapacity(long l) {
        this.memoryCapacity = l;
        if (this.memoryUsage > l) {
            this.memoryControl();
        }
    }

    public void setTileCapacity(int n) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + ": memoryCapacity = " + Long.toHexString(this.memoryCapacity) + " memoryUsage = " + Long.toHexString(this.memoryUsage) + " #tilesInCache = " + Integer.toString(this.cache.size());
    }

    private final synchronized void update(CachedTile cachedTile) {
        cachedTile.timeStamp = this.timeStamp++;
        if (cachedTile != this.first) {
            if (cachedTile == this.last) {
                this.last = cachedTile.previous;
                this.last.next = null;
            } else {
                cachedTile.previous.next = cachedTile.next;
                cachedTile.next.previous = cachedTile.previous;
            }
            cachedTile.previous = null;
            cachedTile.next = this.first;
            this.first.previous = cachedTile;
            this.first = cachedTile;
        }
    }
}

