/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.renderable.ParameterBlock;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;

public class ParameterBlockJAI
extends ParameterBlock {
    private OperationDescriptor odesc;
    private Class[] paramClasses;
    private Hashtable indexTable = new Hashtable();

    public ParameterBlockJAI(String string) {
        this(JAI.getDefaultInstance().getOperationRegistry().getOperationDescriptor(string));
    }

    public ParameterBlockJAI(OperationDescriptor operationDescriptor) {
        this.odesc = operationDescriptor;
        this.paramClasses = operationDescriptor.getParamClasses();
        int n = operationDescriptor.getNumParameters();
        this.parameters = new Vector(n);
        Object[] objectArray = operationDescriptor.getParamDefaults();
        String[] stringArray = operationDescriptor.getParamNames();
        int n2 = 0;
        while (n2 < n) {
            this.parameters.addElement(objectArray[n2]);
            this.indexTable.put(stringArray[n2], new Integer(n2));
            ++n2;
        }
    }

    public byte getByteParameter(String string) {
        return this.getByteParameter(this.indexOf(string));
    }

    public char getCharParameter(String string) {
        return this.getCharParameter(this.indexOf(string));
    }

    public double getDoubleParameter(String string) {
        return this.getDoubleParameter(this.indexOf(string));
    }

    public float getFloatParameter(String string) {
        return this.getFloatParameter(this.indexOf(string));
    }

    public int getIntParameter(String string) {
        return this.getIntParameter(this.indexOf(string));
    }

    public long getLongParameter(String string) {
        return this.getLongParameter(this.indexOf(string));
    }

    public Object getObjectParameter(String string) {
        return this.getObjectParameter(this.indexOf(string));
    }

    public OperationDescriptor getOperationDescriptor() {
        return this.odesc;
    }

    public int indexOf(String string) {
        Integer n = (Integer)this.indexTable.get(string);
        return n;
    }

    public ParameterBlock set(byte by, String string) {
        return this.set((Object)new Byte(by), string);
    }

    public ParameterBlock set(char c, String string) {
        return this.set((Object)new Character(c), string);
    }

    public ParameterBlock set(double d, String string) {
        return this.set((Object)new Double(d), string);
    }

    public ParameterBlock set(float f, String string) {
        return this.set((Object)new Float(f), string);
    }

    public ParameterBlock set(int n, String string) {
        return this.set((Object)new Integer(n), string);
    }

    public ParameterBlock set(long l, String string) {
        return this.set((Object)new Long(l), string);
    }

    public ParameterBlock set(Object object, String string) {
        int n = this.indexOf(string);
        if (object != null && !this.paramClasses[n].isInstance(object)) {
            throw new IllegalArgumentException(JaiI18N.getString("ParameterBlockJAI0"));
        }
        this.parameters.setElementAt(object, n);
        return this;
    }

    public ParameterBlock set(short s, String string) {
        return this.set((Object)new Short(s), string);
    }
}

