/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.Day;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.Year;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class BasicTimeSeriesTests
extends TestCase {
    protected BasicTimeSeries seriesA;
    protected BasicTimeSeries seriesB;
    protected BasicTimeSeries seriesC;
    static /* synthetic */ Class class$com$jrefinery$data$junit$BasicTimeSeriesTests;
    static /* synthetic */ Class class$com$jrefinery$data$Year;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$BasicTimeSeriesTests == null ? (class$com$jrefinery$data$junit$BasicTimeSeriesTests = BasicTimeSeriesTests.class$("com.jrefinery.data.junit.BasicTimeSeriesTests")) : class$com$jrefinery$data$junit$BasicTimeSeriesTests);
    }

    public BasicTimeSeriesTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.seriesA = new BasicTimeSeries("Series A", class$com$jrefinery$data$Year == null ? (class$com$jrefinery$data$Year = BasicTimeSeriesTests.class$("com.jrefinery.data.Year")) : class$com$jrefinery$data$Year);
        try {
            this.seriesA.add((TimePeriod)new Year(2000), new Integer(102000));
            this.seriesA.add((TimePeriod)new Year(2001), new Integer(102001));
            this.seriesA.add((TimePeriod)new Year(2002), new Integer(102002));
            this.seriesA.add((TimePeriod)new Year(2003), new Integer(102003));
            this.seriesA.add((TimePeriod)new Year(2004), new Integer(102004));
            this.seriesA.add((TimePeriod)new Year(2005), new Integer(102005));
        }
        catch (SeriesException seriesException) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
        this.seriesB = new BasicTimeSeries("Series B", class$com$jrefinery$data$Year == null ? (class$com$jrefinery$data$Year = BasicTimeSeriesTests.class$("com.jrefinery.data.Year")) : class$com$jrefinery$data$Year);
        try {
            this.seriesB.add((TimePeriod)new Year(2006), new Integer(202006));
            this.seriesB.add((TimePeriod)new Year(2007), new Integer(202007));
            this.seriesB.add((TimePeriod)new Year(2008), new Integer(202008));
        }
        catch (SeriesException seriesException) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
        this.seriesC = new BasicTimeSeries("Series C", class$com$jrefinery$data$Year == null ? (class$com$jrefinery$data$Year = BasicTimeSeriesTests.class$("com.jrefinery.data.Year")) : class$com$jrefinery$data$Year);
        try {
            this.seriesC.add((TimePeriod)new Year(1999), new Integer(301999));
            this.seriesC.add((TimePeriod)new Year(2000), new Integer(302000));
            this.seriesC.add((TimePeriod)new Year(2002), new Integer(302002));
        }
        catch (SeriesException seriesException) {
            System.err.println("TimeSeriesTests.setUp(): problem creating series.");
        }
    }

    public void testClone() {
        BasicTimeSeries basicTimeSeries = new BasicTimeSeries("Test Series");
        Day day = new Day(1, 1, 2002);
        try {
            basicTimeSeries.add((TimePeriod)day, new Integer(42));
        }
        catch (SeriesException seriesException) {
            System.err.println("TimeSeriesTests.testClone: problem adding to series.");
        }
        BasicTimeSeries basicTimeSeries2 = (BasicTimeSeries)basicTimeSeries.clone();
        basicTimeSeries2.setName("Clone Series");
        try {
            basicTimeSeries2.update(day, (Number)new Integer(10));
        }
        catch (SeriesException seriesException) {
            System.err.println("TimeSeriesTests.testClone: problem updating series.");
        }
        int n = basicTimeSeries.getValue(day).intValue();
        int n2 = basicTimeSeries2.getValue(day).intValue();
        Assert.assertEquals((int)42, (int)n);
        Assert.assertEquals((int)10, (int)n2);
        Assert.assertEquals((Object)"Test Series", (Object)basicTimeSeries.getName());
        Assert.assertEquals((Object)"Clone Series", (Object)basicTimeSeries2.getName());
    }

    public void testAddValue() {
        try {
            this.seriesA.add((TimePeriod)new Year(1999), new Integer(1));
        }
        catch (SeriesException seriesException) {
            System.err.println("TimeSeriesTests.testAddValue: problem adding to series.");
        }
        int n = this.seriesA.getValue(0).intValue();
        Assert.assertEquals((int)1, (int)n);
    }

    public void testGetValue() {
        Number number = this.seriesA.getValue(new Year(1999));
        Assert.assertNull((Object)number);
        int n = this.seriesA.getValue(new Year(2000)).intValue();
        Assert.assertEquals((int)102000, (int)n);
    }

    public void testDelete() {
        BasicTimeSeries basicTimeSeries = this.seriesA.delete(0, 0);
        Assert.assertEquals((int)5, (int)this.seriesA.getItemCount());
        Assert.assertEquals((int)1, (int)basicTimeSeries.getItemCount());
        Number number = this.seriesA.getValue(new Year(2000));
        Assert.assertNull((Object)number);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

