/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.Quarter;
import com.jrefinery.data.TimePeriodFormatException;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QuarterTests
extends TestCase {
    protected Quarter q1_1900;
    protected Quarter q2_1900;
    protected Quarter q3_9999;
    protected Quarter q4_9999;
    static /* synthetic */ Class class$com$jrefinery$data$junit$QuarterTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$QuarterTests == null ? (class$com$jrefinery$data$junit$QuarterTests = QuarterTests.class$("com.jrefinery.data.junit.QuarterTests")) : class$com$jrefinery$data$junit$QuarterTests);
    }

    public QuarterTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.q1_1900 = new Quarter(1, 1900);
        this.q2_1900 = new Quarter(2, 1900);
        this.q3_9999 = new Quarter(3, 9999);
        this.q4_9999 = new Quarter(4, 9999);
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Quarter quarter = new Quarter(new Date(1017619199999L), timeZone);
        Quarter quarter2 = new Quarter(new Date(1017619200000L), timeZone);
        Assert.assertEquals((int)1, (int)quarter.getQuarter());
        Assert.assertEquals((long)1017619199999L, (long)quarter.getEnd(timeZone));
        Assert.assertEquals((int)2, (int)quarter2.getQuarter());
        Assert.assertEquals((long)1017619200000L, (long)quarter2.getStart(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Istanbul");
        Quarter quarter = new Quarter(new Date(1017608399999L), timeZone);
        Quarter quarter2 = new Quarter(new Date(1017608400000L), timeZone);
        Assert.assertEquals((int)1, (int)quarter.getQuarter());
        Assert.assertEquals((long)1017608399999L, (long)quarter.getEnd(timeZone));
        Assert.assertEquals((int)2, (int)quarter2.getQuarter());
        Assert.assertEquals((long)1017608400000L, (long)quarter2.getStart(timeZone));
    }

    public void testQ1_1900_previous() {
        Quarter quarter = (Quarter)this.q1_1900.previous();
        Assert.assertNull((Object)quarter);
    }

    public void testQ1_1900_next() {
        Quarter quarter = (Quarter)this.q1_1900.next();
        Assert.assertEquals((Object)this.q2_1900, (Object)quarter);
    }

    public void testQ4_9999_previous() {
        Quarter quarter = (Quarter)this.q4_9999.previous();
        Assert.assertEquals((Object)this.q3_9999, (Object)quarter);
    }

    public void testQ4_9999_next() {
        Quarter quarter = (Quarter)this.q4_9999.next();
        Assert.assertNull((Object)quarter);
    }

    public void testParseQuarter() {
        Quarter quarter = null;
        try {
            quarter = Quarter.parseQuarter("Q1-2000");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            quarter = new Quarter(1, 1900);
        }
        Assert.assertEquals((int)1, (int)quarter.getQuarter());
        Assert.assertEquals((int)2000, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("2001-Q2");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            quarter = new Quarter(1, 1900);
        }
        Assert.assertEquals((int)2, (int)quarter.getQuarter());
        Assert.assertEquals((int)2001, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("Q3, 2002");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            quarter = new Quarter(1, 1900);
        }
        Assert.assertEquals((int)3, (int)quarter.getQuarter());
        Assert.assertEquals((int)2002, (int)quarter.getYear().getYear());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

