/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse;

import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.XML;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.eclipse.SplusNewEditorListener;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.actions.SplusRunAction;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusCodeScanner;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusFindSource;
import com.insightful.splus.eclipse.editors.spluseditor.context.intellisense.SplusIntelliSenseHelper;
import com.insightful.splus.eclipse.editors.spluseditor.util.ExternalFileEditorInput;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusColorProvider;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusEditorMessages;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusFileDocumentProvider;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusPluginImages;
import com.insightful.splus.eclipse.graph.DefaultDialog;
import com.insightful.splus.eclipse.graph.SWTGraphFrame;
import com.insightful.splus.eclipse.graph.SWTGraphView;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.eclipse.preferences.SplusConnectionPreferencePage;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.preferences.SplusTaskPreferencePage;
import com.insightful.splus.eclipse.views.HistoryView;
import com.insightful.splus.eclipse.views.ObjectsView;
import com.insightful.splus.eclipse.views.OutputView;
import com.insightful.splus.eclipse.views.SearchPathView;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.eclipse.views.util.SplusConsole;
import com.insightful.splus.eclipse.views.util.SplusProjectActivation;
import com.insightful.splus.parser.PObject;
import com.insightful.splus.util.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.osgi.framework.BundleContext;

public class SplusEditorPlugin
extends AbstractUIPlugin
implements IWindowListener {
    public static final String SPLUS_PARTITIONING = "__splus_partitioning";
    private static SplusEditorPlugin fgInstance;
    private SplusColorProvider fColorProvider;
    private SplusCodeScanner fCodeScanner;
    private IDocumentProvider fDocumentProvider;
    private SplusIntelliSenseHelper fSplusIntelliSenseHelper;
    public static String g_osName;
    public static boolean g_isWindowsOS;
    public static boolean g_isSolarisOS;
    public static boolean g_isLinuxOS;
    public static boolean g_isHpOS;
    public static boolean g_isAixOS;
    private boolean m_quitPerformed;
    public static final int INTERNAL_ERROR = 10001;
    private static boolean g_shutdown;
    protected final Preferences.IPropertyChangeListener fPropertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("tasks")) {
                try {
                    Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
                    workspace.getBuildManager().build(6, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    };
    private static Vector g_tempFilesToDelete;
    private Vector m_newEditorListeners = new Vector();
    private static final String g_swtAwtErrorMessage = "This Eclipse/JDK combination does not support AWT components.\nThe java.graph() device is not available.  Use the motif() graphics\ndevice instead.";
    private NoConnection m_connection = null;
    private ConsoleHistoryDocument m_consoleHistoryDocument = null;
    private AbstractDocument m_outputDocument = null;
    private SplusConsole m_console = null;
    private HistoryView m_history = null;
    private ObjectsView m_objects = null;
    private OutputView m_output = null;
    private SearchPathView m_searchPath = null;
    private static Font g_defaultFont;
    private IResourceNavigator m_resourceNavigator = null;
    private SplusStatusThread m_statusThread = null;
    private boolean m_activated = false;
    private SplusProgressContributionItem m_progress;
    private int g_pos = 0;
    private int g_max = 500;
    private int g_min = 0;
    private int g_inc = 2;
    public static final String ACTIVE_PROJECT = ".activeProject";
    private String m_activeProject = null;
    private StatusLineContributionItem m_status;
    private SplusProjectActivation m_splusProjectActivation = null;

    public SplusEditorPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        fgInstance = this;
        this.getPluginPreferences().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public static SplusEditorPlugin getDefault() {
        return fgInstance;
    }

    public IPath getSplusStateLocation() {
        IPath iPath = this.getStateLocation();
        return iPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        this.closeSplusSession();
        try {
            this.getPluginPreferences().removePropertyChangeListener(this.fPropertyChangeListener);
            SplusEditorPlugin.deleteTempFiles();
            this.getConsoleDocument().saveHistory();
            this.saveActiveProject();
        }
        finally {
            super.stop(bundleContext);
        }
    }

    private void closeSplusSession() {
        int n;
        final DefaultConnection defaultConnection = (DefaultConnection)this.getConnection();
        defaultConnection.addSplusWinSessionListener(new SplusWinSessionListener(){

            public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) throws RemoteException {
                if (splusWinSessionEvent.getType() == 32) {
                    SplusEditorPlugin.this.m_quitPerformed = true;
                }
            }
        });
        final boolean bl = defaultConnection.isEngineBusy();
        this.m_quitPerformed = false;
        new Thread("SplusEditorPlugin-closeSplusConnection"){

            public void run() {
                if (bl) {
                    defaultConnection.sendEscape();
                    defaultConnection.writeEngineInput("q()");
                } else {
                    defaultConnection.writeEngineInput("q()");
                }
            }
        }.start();
        int n2 = 0;
        int n3 = n = bl ? 300 : 30;
        while (!this.m_quitPerformed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (++n2 <= n) continue;
            break;
        }
    }

    public SplusIntelliSenseHelper getSplusIntelliSenseHelper(DefaultConnection defaultConnection) {
        if (this.fSplusIntelliSenseHelper == null) {
            this.fSplusIntelliSenseHelper = new SplusIntelliSenseHelper(defaultConnection);
            this.fSplusIntelliSenseHelper.start();
        }
        return this.fSplusIntelliSenseHelper;
    }

    public RuleBasedScanner getSplusCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new SplusCodeScanner(this.getSplusColorProvider());
        }
        return this.fCodeScanner;
    }

    public SplusColorProvider getSplusColorProvider() {
        if (this.fColorProvider == null) {
            this.fColorProvider = new SplusColorProvider();
        }
        return this.fColorProvider;
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new SplusFileDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public static String getPluginId() {
        return "com.insightful.splus.eclipse";
    }

    public static void log(IStatus iStatus) {
        SplusEditorPlugin.getDefault().getLog().log(iStatus);
    }

    public static void logErrorMessage(String string) {
        SplusEditorPlugin.log((IStatus)new Status(4, SplusEditorPlugin.getPluginId(), 10001, string, null));
    }

    public static void logErrorStatus(String string, IStatus iStatus) {
        if (iStatus == null) {
            SplusEditorPlugin.logErrorMessage(string);
            return;
        }
        MultiStatus multiStatus = new MultiStatus(SplusEditorPlugin.getPluginId(), 10001, string, null);
        multiStatus.add(iStatus);
        SplusEditorPlugin.log((IStatus)multiStatus);
    }

    public static void log(Throwable throwable) {
        SplusEditorPlugin.log((IStatus)new Status(4, SplusEditorPlugin.getPluginId(), 10001, SplusEditorMessages.getString("JavaPlugin.internal_error"), throwable));
    }

    public void initPageListener() {
        IWorkbench iWorkbench = this.getWorkbench();
        iWorkbench.addWindowListener((IWindowListener)this);
    }

    public void initWorkbenchListener() {
        try {
            IWorkbench iWorkbench = this.getWorkbench();
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.insightful.splus.eclipse.views.util.SWTGraphViewDisposer");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Class<?> clazz2 = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.eclipse.ui.IWorkbenchListener");
            Method method = iWorkbench.getClass().getMethod("addWorkbenchListener", clazz2);
            method.invoke((Object)iWorkbench, obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.initPageListener();
        super.start(bundleContext);
        this.getConsole();
    }

    public static boolean isShutdown() {
        return g_shutdown;
    }

    public static void doErrorShutdown(final String string, final String string2) {
        if (!g_shutdown) {
            g_shutdown = true;
            SplusEditorPlugin.getDefault().getWorkbench().getDisplay().asyncExec((Runnable)new Thread("ErrorShutdown"){

                public void run() {
                    MessageDialog.openError(null, (String)string, (String)("Cannot start S-PLUS Workbench:\n\n" + string2 + "\n\n\nWorkbench will shut down."));
                    SplusEditorPlugin.getDefault().getWorkbench().close();
                }
            });
        }
    }

    public static void displayWarning(final String string, final String string2) {
        Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
        display.syncExec((Runnable)new Thread("DisplayWarning"){

            public void run() {
                MessageDialog.openWarning(null, (String)string, (String)string2);
            }
        });
    }

    public static void deleteTempFiles() {
        for (int i = 0; i < g_tempFilesToDelete.size(); ++i) {
            String string = (String)g_tempFilesToDelete.get(i);
            File file = new File(string);
            file.deleteOnExit();
            file.delete();
        }
    }

    public static void editTempFile(String string) {
        try {
            String string2 = new File(string).getCanonicalPath();
            g_tempFilesToDelete.add(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void savingFile(String string) {
        try {
            String string2 = new File(string).getCanonicalPath();
            g_tempFilesToDelete.remove(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void openSplusEditor(String string, String string2) {
        DefaultConnection defaultConnection = (DefaultConnection)SplusEditorPlugin.getDefault().getConnection();
        String string3 = "";
        if (SplusConnectionPreferencePage.useExternal()) {
            try {
                string3 = File.createTempFile("engine-" + string, "ssc").getAbsolutePath();
                defaultConnection.copyFile(string2, string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        } else {
            string3 = string2;
        }
        String string4 = SplusParseTreeBuilder.toString(new File(string3));
        PObject pObject = SplusParseTreeBuilder.getInstance().getParseTree(string4);
        final String string5 = string;
        if (Thread.currentThread() == SplusEditorPlugin.getDefault().getWorkbench().getDisplay().getThread()) {
            if (SplusFindSource.findMethod(string5, false) == null) {
                SplusEditorPlugin.openSplusEditorInWorkbenchThread(string3);
            }
        } else {
            final String string6 = string3;
            SplusEditorPlugin.getDefault().getWorkbench().getDisplay().asyncExec((Runnable)new Thread("OpenEditor"){

                public void run() {
                    if (SplusFindSource.findMethod(string5, false) == null) {
                        SplusEditorPlugin.openSplusEditorInWorkbenchThread(string6);
                    }
                }
            });
        }
        SplusEditorPlugin.editTempFile(string3);
    }

    public void addNewEditorListener(SplusNewEditorListener splusNewEditorListener) {
        this.m_newEditorListeners.add(splusNewEditorListener);
    }

    public void removeNewEditorListener(SplusNewEditorListener splusNewEditorListener) {
        this.m_newEditorListeners.remove(splusNewEditorListener);
    }

    public void notifyNewEditorListener(SplusEditor splusEditor) {
        for (int i = 0; i < this.m_newEditorListeners.size(); ++i) {
            ((SplusNewEditorListener)this.m_newEditorListeners.get(i)).newEditorAdded(splusEditor);
        }
    }

    private static void openSplusEditorInWorkbenchThread(String string) {
        if (SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() == null) {
            System.out.println("no active workbench found.");
            return;
        }
        IWorkbenchPage iWorkbenchPage = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            System.out.println("no active page found.");
            return;
        }
        IEditorRegistry iEditorRegistry = SplusEditorPlugin.getDefault().getWorkbench().getEditorRegistry();
        if (iEditorRegistry == null) {
            System.out.println("no editor registry found.");
            return;
        }
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.findEditor("org.eclipse.ui.SplusEditor");
        if (iEditorDescriptor == null) {
            System.out.println("no splus editor found.");
            return;
        }
        try {
            File file = new File(string);
            IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new ExternalFileEditorInput(file), iEditorDescriptor.getId());
            if (iEditorPart instanceof SplusEditor) {
                SplusEditorPlugin.getDefault().notifyNewEditorListener((SplusEditor)iEditorPart);
            }
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public void displaySWTCanvas(File file) {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = iWorkbenchWindow.getShell();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        try {
            SWTGraphView sWTGraphView = (SWTGraphView)iWorkbenchPage.showView(SWTGraphView.ID, Integer.toString(SWTGraphView.getNextSecondaryID()), 2);
            FileInputStream fileInputStream = new FileInputStream(file);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            Vector vector = XML.readCanvasVectorFromXML((InputStream)gZIPInputStream);
            SCanvas[] sCanvasArray = new SCanvas[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                SCanvasAWT sCanvasAWT = (SCanvasAWT)vector.get(i);
                SCanvas sCanvas = null;
                sCanvas = sCanvasAWT instanceof SCanvas ? (SCanvas)sCanvasAWT : sCanvasAWT.createSCanvas();
                sCanvasArray[i] = sCanvas;
            }
            sWTGraphView.setData(sCanvasArray);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.openError((Shell)shell, (String)"Graph File Error", (String)fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)shell, (String)"Graph File Error", (String)iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)shell, (String)"Graph File Error", (String)partInitException.getMessage());
            partInitException.printStackTrace();
        }
    }

    public void displaySWTCanvas(SCanvas sCanvas) {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = iWorkbenchWindow.getShell();
        try {
            if (SplusPreferencePage.getIntegratedJavaGraph()) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                SWTGraphView sWTGraphView = (SWTGraphView)iWorkbenchPage.showView(SWTGraphView.ID, Integer.toString(SWTGraphView.getNextSecondaryID()), 2);
                sWTGraphView.setData(sCanvas);
            } else {
                new SWTGraphFrame(shell.getDisplay(), sCanvas, shell.getImage(), DefaultDialog.getImages(shell), null, null);
            }
        }
        catch (SWTError sWTError) {
            MessageDialog.openError((Shell)shell, (String)"java.graph Error", (String)g_swtAwtErrorMessage);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)shell, (String)"java.graph Error", (String)g_swtAwtErrorMessage);
        }
    }

    public static Font getDefaultFont(Display display) {
        if (g_defaultFont == null) {
            g_defaultFont = new Font((Device)display, "Courier", 10, 0);
        }
        return g_defaultFont;
    }

    public ConsoleHistoryDocument getConsoleDocument() {
        if (this.m_consoleHistoryDocument == null) {
            try {
                this.m_consoleHistoryDocument = new ConsoleHistoryDocument();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.m_consoleHistoryDocument = null;
            }
        }
        return this.m_consoleHistoryDocument;
    }

    public NoConnection getConnection() {
        ConsoleHistoryDocument consoleHistoryDocument = this.getConsoleDocument();
        if (SplusEditorPlugin.isShutdown()) {
            return new NoConnection(consoleHistoryDocument);
        }
        String string = "Check for valid license.";
        if (this.m_connection == null) {
            try {
                String string2 = DefaultConnection.getShome();
                if (!new File(string2).exists()) {
                    throw new Exception("Specified S-PLUS location (" + string2 + ") not found.");
                }
                String string3 = "com.insightful.splus.eclipse.debug.connection.DebugConnection";
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                this.m_connection = (DefaultConnection)iAdapterManager.loadAdapter((Object)consoleHistoryDocument, string3);
                if (this.m_connection == null) {
                    String string4 = "com.insightful.splus.eclipse.connection.DefaultConnection";
                    this.m_connection = (DefaultConnection)iAdapterManager.loadAdapter((Object)consoleHistoryDocument, string4);
                }
                if (this.m_connection != null) {
                    return this.m_connection;
                }
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
            catch (Error error) {
                string = error.getMessage();
            }
            SplusEditorPlugin.doErrorShutdown("Splus License Error", string);
            this.m_connection = new NoConnection(consoleHistoryDocument);
        }
        return this.m_connection;
    }

    public IResourceNavigator getResourceNavigator() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (this.m_resourceNavigator == null && iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
            for (int i = 0; i < iViewReferenceArray.length; ++i) {
                if (!iViewReferenceArray[i].getId().equals("org.eclipse.ui.views.ResourceNavigator")) continue;
                this.m_resourceNavigator = (IResourceNavigator)iViewReferenceArray[i].getView(true);
                break;
            }
            if (this.m_resourceNavigator == null) {
                try {
                    this.m_resourceNavigator = (IResourceNavigator)iWorkbenchPage.showView("org.eclipse.ui.views.ResourceNavigator", null, 3);
                    iWorkbenchPage.hideView((IViewPart)this.m_resourceNavigator);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.m_resourceNavigator;
    }

    private void getSplusConsole() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (this.m_console == null && iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
            for (int i = 0; i < iViewReferenceArray.length; ++i) {
                if (!iViewReferenceArray[i].getId().equals("org.eclipse.ui.console.ConsoleView")) continue;
                IViewPart iViewPart = iViewReferenceArray[i].getView(true);
                break;
            }
        }
    }

    public AbstractDocument getOutputDocument() {
        if (this.m_outputDocument == null) {
            this.m_outputDocument = new Document();
        }
        return this.m_outputDocument;
    }

    public void setHistory(HistoryView historyView) {
        this.m_history = historyView;
    }

    public void setConsole(SplusConsole splusConsole) {
        this.m_console = splusConsole;
    }

    public void setObjects(ObjectsView objectsView) {
        this.m_objects = objectsView;
    }

    public void setOutput(OutputView outputView) {
        this.m_output = outputView;
    }

    public void setSearchPath(SearchPathView searchPathView) {
        this.m_searchPath = searchPathView;
    }

    public HistoryView getHistory() {
        return this.m_history;
    }

    public SplusConsole getConsole() {
        if (this.m_console == null || this.m_console.isDummy()) {
            ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
            IConsoleManager iConsoleManager = consolePlugin.getConsoleManager();
            IConsole[] iConsoleArray = iConsoleManager.getConsoles();
            for (int i = 0; i < iConsoleArray.length; ++i) {
                if (!SplusConsole.NAME.equals(iConsoleArray[i].getName())) continue;
                this.m_console = (SplusConsole)iConsoleArray[i];
                if (!this.m_console.isDummy()) break;
                this.m_console = null;
                break;
            }
            if (this.m_console == null) {
                this.m_console = new SplusConsole(false);
                iConsoleManager.addConsoles(new IConsole[]{this.m_console});
            }
        }
        return this.m_console;
    }

    public ObjectsView getObjects() {
        return this.m_objects;
    }

    public OutputView getOutput() {
        return this.m_output;
    }

    public SearchPathView getSearchPath() {
        return this.m_searchPath;
    }

    public synchronized void setSplusBusy(boolean bl) {
        if (this.m_statusThread == null) {
            this.m_statusThread = new SplusStatusThread();
            this.m_statusThread.start();
        }
        this.m_statusThread.setSplusBusy(bl);
    }

    public synchronized void sendCmd(String string) {
        ConsoleHistoryDocument consoleHistoryDocument = this.getConsoleDocument();
        if (consoleHistoryDocument != null) {
            consoleHistoryDocument.executeCommand(string);
        }
    }

    public static String getShome() {
        return DefaultConnection.getShome();
    }

    private void doActivationWork() {
        if (this.m_activated) {
            return;
        }
        this.initActiveProject();
        this.initProgressBar();
        this.initWorkbenchListener();
        this.m_activated = true;
        new SplusEditorPreferencePage();
        new SplusTaskPreferencePage();
        NoConnection noConnection = this.getConnection();
        String string = noConnection.isWorkbenchLicensed();
        if (string.length() != 0) {
            SplusEditorPlugin.doErrorShutdown("Workbench License Error", string);
        }
        this.getResourceNavigator();
        this.getConsole();
        if (noConnection instanceof DefaultConnection) {
            ((DefaultConnection)noConnection).getOutputHandler();
        }
        this.getPreferenceStore();
    }

    public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
        this.doActivationWork();
    }

    public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
        this.doActivationWork();
    }

    public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void initProgressBar() {
        this.m_progress = new SplusProgressContributionItem("SplusEditorPluginProgress");
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow();
        workbenchWindow.getStatusLineManager().add((IContributionItem)this.m_progress);
    }

    public void startProgressBar() {
        if (this.m_progress != null) {
            this.m_progress.start();
        }
    }

    public void stopProgressBar() {
        if (this.m_progress != null) {
            this.m_progress.stop();
        }
    }

    public String getActiveProject() {
        return this.m_activeProject;
    }

    private boolean useActiveProject() {
        if (SplusConnectionPreferencePage.useExternal() && !SplusConnectionPreferencePage.useLocal()) {
            try {
                String string = SplusConnectionPreferencePage.getServer();
                InetAddress.getByName(string);
                String string2 = InetAddress.getLocalHost().getHostName();
                return string2.equalsIgnoreCase(string);
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void initActiveProject() {
        this.m_status = new StatusLineContributionItem("SplusEditorPluginStatus", true, 35);
        this.m_status.setImage(SplusPluginImages.get("com.insightful.splus.eclipse.act_prj.gif"));
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow();
        workbenchWindow.getStatusLineManager().add((IContributionItem)this.m_status);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                IResource iResource = iResourceChangeEvent.getResource();
                if (iResourceChangeEvent.getType() == 4 && iResource instanceof IProject && SplusEditorPlugin.this.isActiveProject(iResource.getName())) {
                    String string = iResource.getName();
                    SplusEditorPlugin.this.toggleActiveProject(string);
                }
            }
        });
        if (!this.useActiveProject()) {
            this.setActiveProject(null);
            return;
        }
        String string = SplusEditorPlugin.getDefault().getPluginPreferences().getString(ACTIVE_PROJECT);
        if (string != null && string.length() != 0) {
            this.toggleActiveProject(string);
        } else {
            this.setActiveProject(string);
        }
    }

    private void saveActiveProject() {
        String string = this.getActiveProject();
        if (string != null) {
            SplusEditorPlugin.getDefault().getPluginPreferences().setValue(ACTIVE_PROJECT, string);
        } else {
            SplusEditorPlugin.getDefault().getPluginPreferences().setValue(ACTIVE_PROJECT, "");
        }
    }

    public void toggleActiveProject(String string) {
        this.toggleActiveProject(string, true);
    }

    public void toggleActiveProject(String string, boolean bl) {
        boolean bl2 = string.equals(SplusEditorPlugin.getDefault().getActiveProject());
        if (!bl2) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = iProjectArray[i].getName();
                if (!string2.equals(string)) continue;
                String string3 = string2;
                String string4 = iProjectArray[i].getLocation().toString();
                this.setActiveProjectInSplus(string4, string3);
                break;
            }
            this.setActiveProject(string);
        } else {
            try {
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
                IResource iResource = iWorkspaceRoot.findMember(".");
                IPath iPath = iResource.getLocation();
                String string5 = iPath.toString();
                this.setActiveProjectInSplus(string5, "");
                this.setActiveProject(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            this.updateResourceNavigator();
        }
    }

    public void setActiveProject(String string) {
        this.m_activeProject = string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_activeProject == null || this.m_activeProject.length() == 0) {
            stringBuffer.append("Workspace");
        } else {
            stringBuffer.append(this.m_activeProject);
        }
        if (this.m_status != null) {
            final String string2 = stringBuffer.toString();
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            display.syncExec((Runnable)new Thread("SplusEditorPlugin-ActiveProjectUpdate"){

                public void run() {
                    SplusEditorPlugin.this.m_status.setText(string2);
                }
            });
        }
    }

    private void setActiveProjectInSplus(String string, String string2) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            try {
                String string3 = StringUtilities.escapeSpecialCharacters((String)string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("set.dynamic.project.location(dir=\"");
                stringBuffer.append(string3);
                if (string2.length() != 0) {
                    stringBuffer.append("\", name=\"");
                    stringBuffer.append(string2);
                }
                stringBuffer.append("\")");
                while (true) {
                    try {
                        SplusDataResult splusDataResult = defaultConnection.doDataQuery(stringBuffer.toString());
                        String string4 = splusDataResult.getError();
                        if (string4 != null && string4.length() != 0) {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Error Setting Working Project", (String)string4);
                        } else {
                            ObjectsView objectsView;
                            SearchPathView searchPathView = SplusEditorPlugin.getDefault().getSearchPath();
                            if (searchPathView != null) {
                                searchPathView.refreshSearchPath();
                            }
                            if ((objectsView = SplusEditorPlugin.getDefault().getObjects()) != null) {
                                objectsView.refreshObjects();
                            }
                        }
                    }
                    catch (SplusEngineBusyException splusEngineBusyException) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setSplusProjectActivator(SplusProjectActivation splusProjectActivation) {
        this.m_splusProjectActivation = splusProjectActivation;
    }

    public boolean isActiveProject(String string) {
        return string.equals(SplusEditorPlugin.getDefault().getActiveProject());
    }

    public void updateResourceNavigator() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
            for (int i = 0; i < iViewReferenceArray.length; ++i) {
                final IViewReference iViewReference = iViewReferenceArray[i];
                if (!iViewReference.getId().equals("org.eclipse.ui.views.ResourceNavigator")) continue;
                display.syncExec((Runnable)new Thread("GetNavigator"){

                    public void run() {
                        IResourceNavigator iResourceNavigator = (IResourceNavigator)iViewReference.getView(false);
                        if (iResourceNavigator != null) {
                            iResourceNavigator.getViewer().refresh();
                        }
                    }
                });
            }
        }
    }

    static {
        g_osName = System.getProperty("os.name").toLowerCase();
        g_isWindowsOS = g_osName.indexOf("windows") >= 0;
        g_isSolarisOS = g_osName.indexOf("sunos") >= 0;
        g_isLinuxOS = g_osName.indexOf("linux") >= 0;
        g_isHpOS = g_osName.indexOf("hp") >= 0;
        g_isAixOS = g_osName.indexOf("aix") >= 0;
        g_shutdown = false;
        g_tempFilesToDelete = new Vector();
        g_defaultFont = null;
    }

    public class SplusProgressContributionItem
    extends StatusLineContributionItem {
        private ProgressBar m_progress;
        private Thread m_timer;
        private Display m_display;

        public SplusProgressContributionItem(String string) {
            super(string, true, 7);
            this.setText("Ready");
        }

        public void fill(Composite composite) {
            super.fill(composite);
            this.m_progress = new ProgressBar(composite, 65792);
            StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
            statusLineLayoutData.heightHint = 10;
            statusLineLayoutData.widthHint = 50;
            this.m_progress.setLayoutData((Object)statusLineLayoutData);
            this.m_progress.setMinimum(SplusEditorPlugin.this.g_min);
            this.m_progress.setMaximum(SplusEditorPlugin.this.g_max);
        }

        public void start() {
            this.setText("Busy");
            if (this.m_timer != null && this.m_timer.isAlive()) {
                return;
            }
            this.m_display = Display.getCurrent();
            if (this.m_timer != null) {
                this.m_timer.interrupt();
            }
            this.m_timer = new Thread("ProgressBarUpdater"){

                public void run() {
                    while (!this.isInterrupted() && !SplusProgressContributionItem.this.m_display.isDisposed()) {
                        SplusProgressContributionItem.this.update(false);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            };
            this.m_timer.start();
        }

        public void update(boolean bl) {
            if (this.m_display == null || this.m_display.isDisposed()) {
                return;
            }
            if (bl || SplusEditorPlugin.this.g_pos == SplusEditorPlugin.this.g_max) {
                SplusEditorPlugin.this.g_pos = SplusEditorPlugin.this.g_min;
            } else {
                SplusEditorPlugin.this.g_pos += SplusEditorPlugin.this.g_inc;
            }
            this.m_display.asyncExec((Runnable)new Thread("SplusProgressContributionItemUpdate"){

                public void run() {
                    if (SplusProgressContributionItem.this.m_progress != null && !SplusProgressContributionItem.this.m_progress.isDisposed()) {
                        SplusProgressContributionItem.this.m_progress.setSelection(SplusEditorPlugin.this.g_pos);
                    }
                }
            });
        }

        public void stop() {
            this.setText("Ready");
            if (this.m_timer != null) {
                this.m_timer.interrupt();
            }
            this.update(true);
        }
    }

    public class SplusStatusThread
    extends Thread {
        private IWorkbench m_workbench;
        private Display m_display;
        private boolean m_update;
        private boolean m_busy;
        private Object m_lock;

        public SplusStatusThread() {
            super("SplusEditorPlugin-StateThread");
            this.m_lock = new Object();
            this.m_workbench = SplusEditorPlugin.getDefault().getWorkbench();
            this.m_display = this.m_workbench.getDisplay();
            this.m_update = false;
            this.m_busy = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                Object object = this.m_lock;
                synchronized (object) {
                    if (this.m_update && !this.m_display.isDisposed()) {
                        this.m_display.asyncExec((Runnable)new Thread("SetConsoleEditable"){

                            public void run() {
                                if (SplusEditorPlugin.this.getConsole() != null) {
                                    SplusEditorPlugin.this.getConsole().setConsoleEditable(!SplusStatusThread.this.m_busy);
                                }
                                if (SplusStatusThread.this.m_busy) {
                                    SplusEditorPlugin.this.startProgressBar();
                                } else {
                                    SplusEditorPlugin.this.stopProgressBar();
                                }
                                SplusRunAction.notifyActions(SplusStatusThread.this.m_busy);
                            }
                        });
                        this.m_update = false;
                    }
                }
            }
        }

        public void setSplusBusy(boolean bl) {
            this.m_busy = bl;
            this.m_update = true;
        }
    }
}

