/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class SplusReferencesResult
extends AbstractTextSearchResult
implements ISearchResult,
IQueryListener {
    private IEditorMatchAdapter m_editAdapter;
    private IFileMatchAdapter m_fileAdapter;
    private ISearchQuery m_query;
    private String m_queryString;

    public SplusReferencesResult(ISearchQuery iSearchQuery, String string) {
        NewSearchUI.addQueryListener((IQueryListener)this);
        this.m_queryString = string;
        this.m_query = iSearchQuery;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public Match createMatch(IResource iResource, int n, int n2, int n3) {
        return new SplusReferenceMatch(iResource, n, n2, n3);
    }

    public int getMatchStartPos(IDocument iDocument, Match match) {
        try {
            if (match instanceof SplusReferenceMatch) {
                return ((SplusReferenceMatch)match).getStartPos(iDocument);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return match.getOffset();
    }

    public int getMatchLength(IDocument iDocument, Match match) {
        return match.getLength();
    }

    public ISearchQuery getQuery() {
        return this.m_query;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return "S-PLUS Reference Search: " + this.getQueryString();
    }

    public String getTooltip() {
        return null;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        if (this.m_editAdapter == null) {
            this.m_editAdapter = new IEditorMatchAdapter(){

                public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                        return SplusReferencesResult.this.getMatches(iFileEditorInput.getFile());
                    }
                    return new Match[0];
                }

                public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                        return match.getElement().equals(iFileEditorInput.getFile());
                    }
                    return false;
                }
            };
        }
        return this.m_editAdapter;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        if (this.m_fileAdapter == null) {
            this.m_fileAdapter = new IFileMatchAdapter(){

                public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
                    return SplusReferencesResult.this.getMatches(iFile);
                }

                public IFile getFile(Object object) {
                    if (object instanceof IFile) {
                        return (IFile)object;
                    }
                    return null;
                }
            };
        }
        return this.m_fileAdapter;
    }

    public void queryAdded(ISearchQuery iSearchQuery) {
    }

    public void queryFinished(ISearchQuery iSearchQuery) {
    }

    public void queryRemoved(ISearchQuery iSearchQuery) {
    }

    public void queryStarting(ISearchQuery iSearchQuery) {
    }

    private class SplusReferenceMatch
    extends Match {
        private int m_column;

        public SplusReferenceMatch(IResource iResource, int n, int n2, int n3) {
            super((Object)iResource, 2, n, n3);
            this.m_column = n2;
        }

        public int getStartPos(IDocument iDocument) throws BadLocationException {
            return iDocument.getLineOffset(this.getOffset()) + this.m_column;
        }
    }
}

