/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class SplusSourcer
implements IViewActionDelegate {
    private StructuredSelection fSelection;
    private String fOutputProp;
    private IViewPart fView;
    private static Object sourcingLock = new Object();
    private static boolean engineBusy = false;

    public void init(IViewPart iViewPart) {
        this.fView = iViewPart;
    }

    public void run(IAction iAction) {
        IWorkbenchPage iWorkbenchPage = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        final IAction iAction2 = iAction;
        new Job("Source S-PLUS Code"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Source S-PLUS Code", 0);
                SplusSourcer.this.doIActionRun(iAction2, iEditorReferenceArray, iProgressMonitor);
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = iSelection instanceof StructuredSelection ? (StructuredSelection)iSelection : new StructuredSelection((Object)iSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIActionRun(IAction iAction, IEditorReference[] iEditorReferenceArray, IProgressMonitor iProgressMonitor) {
        this.startSourcing();
        try {
            IFileEditorMapping[] iFileEditorMappingArray = SplusEditorPlugin.getDefault().getWorkbench().getEditorRegistry().getFileEditorMappings();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            block3: for (int i = 0; i < iFileEditorMappingArray.length; ++i) {
                Object object = iFileEditorMappingArray[i].getEditors();
                for (int j = 0; j < ((IEditorDescriptor[])object).length; ++j) {
                    if (!object[j].getId().equals("org.eclipse.ui.SplusEditor")) continue;
                    String string = iFileEditorMappingArray[i].getExtension().toUpperCase();
                    hashMap.put(string, string);
                    continue block3;
                }
            }
            for (Object object : this.fSelection) {
                if (!(object instanceof IResource)) continue;
                this.doSourceResource((IResource)object, iEditorReferenceArray, iProgressMonitor, hashMap);
            }
        }
        finally {
            this.endSourcing();
        }
    }

    private void doSourceResource(IResource iResource, IEditorReference[] iEditorReferenceArray, IProgressMonitor iProgressMonitor, HashMap hashMap) {
        if (iResource instanceof IFile) {
            String string = ((IFile)iResource).getLocation().getFileExtension();
            File file = new File(((IFile)iResource).getLocation().toString());
            if (string != null && hashMap.get(string.toUpperCase()) != null) {
                FileEditorInput fileEditorInput = new FileEditorInput((IFile)iResource);
                boolean bl = false;
                for (int i = 0; i < iEditorReferenceArray.length; ++i) {
                    IEditorPart iEditorPart = iEditorReferenceArray[i].getEditor(false);
                    if (iEditorPart == null || !iEditorPart.getEditorInput().equals(fileEditorInput)) continue;
                    this.sourceDocument((SplusEditor)iEditorPart, iProgressMonitor);
                    bl = true;
                }
                if (!bl) {
                    this.sourceFile(file, iProgressMonitor);
                }
            }
        } else if (iResource instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)iResource).members();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    this.doSourceResource(iResourceArray[i], iEditorReferenceArray, iProgressMonitor, hashMap);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    private void sourceDocument(SplusEditor splusEditor, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName("Sourcing " + splusEditor.getTitle());
        }
        IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
        this.sourceText(iDocument.get());
    }

    private void sourceFile(File file, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.setTaskName("Sourcing " + file.getName());
        this.sourceText(SplusParseTreeBuilder.toString(file));
    }

    private void sourceText(String string) {
        new SourceTextThread(string).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSourcing() {
        Object object = sourcingLock;
        synchronized (object) {
            this.fOutputProp = System.getProperty("cummulative.output.view");
            System.setProperty("cummulative.output.view", "T");
            engineBusy = false;
            this.fView.getViewSite().getShell().getDisplay().syncExec((Runnable)new Thread("SplusSourcer-SourceText"){

                public void run() {
                    SplusEditorPlugin.getDefault().getOutput().getDocument().set("");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endSourcing() {
        Object object = sourcingLock;
        synchronized (object) {
            if (this.fOutputProp == null) {
                System.setProperty("cummulative.output.view", "F");
            } else {
                System.setProperty("cummulative.output.view", this.fOutputProp);
            }
            sourcingLock.notifyAll();
        }
    }

    private class SourceTextThread
    extends Thread {
        private SplusWinSessionListener listener;
        private DefaultConnection dconn;
        private String command;

        public SourceTextThread(String string) {
            super("SplusSourcer-SourceText");
            this.listener = null;
            this.dconn = null;
            this.command = null;
            this.command = string;
            NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
            if (noConnection instanceof DefaultConnection) {
                this.dconn = (DefaultConnection)noConnection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.dconn != null) {
                Object object = sourcingLock;
                synchronized (object) {
                    while (engineBusy) {
                        try {
                            sourcingLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    this.listener = new SplusWinSessionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
                            Object object = sourcingLock;
                            synchronized (object) {
                                int n = splusWinSessionEvent.getType();
                                if (n == 2 || n == 1001 || n == 999 || n == 1003 || n == 1000 || n == 21) {
                                    SourceTextThread.this.dconn.removeSplusWinSessionListener(SourceTextThread.this.listener);
                                    engineBusy = false;
                                    sourcingLock.notifyAll();
                                }
                            }
                        }
                    };
                    this.dconn.addSplusWinSessionListener(this.listener);
                    String string = "eval(parse(text = \"script.run(exprs.literal={\n" + this.dconn.escapeSpecialCharacters(this.command) + "\n" + "})\n\"))";
                    engineBusy = true;
                    this.dconn.sendCmd(string);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }
}

