/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.controls.SplusDialog;
import com.insightful.splus.SplusMainActionListener;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.graph.DefaultDialog;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SplusWorkbenchListener
extends SplusMainActionListener
implements Listener {
    private Display shellDisplay = null;

    public void handleEvent(Event event) {
        this.handleAction(event.text);
    }

    protected void displayDialog(JDialog jDialog) {
        Shell shell = SplusEditorPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
        final DefaultDialog defaultDialog = new DefaultDialog(shell, jDialog.getTitle());
        if (jDialog instanceof SplusDialog) {
            ((SplusDialog)jDialog).addButtonListener(new SplusDialog.SplusDialogButtonListener(){

                public void splusDialogButtonPressed(SplusDialog splusDialog, String string) {
                    SplusWorkbenchListener.this.updateOutput();
                    if (string.equals("OK") || string.equals("Cancel")) {
                        defaultDialog.close();
                        SplusEditorPlugin.getDefault().getConsoleDocument().setSendToOutput(false);
                    }
                }
            });
        }
        JComponent jComponent = (JComponent)jDialog.getContentPane();
        jComponent.setPreferredSize(jDialog.getMinimumSize());
        defaultDialog.SWT_AWT_fromPanel(jComponent);
        SplusEditorPlugin.getDefault().getConsoleDocument().setSendToOutput(true);
        this.shellDisplay = shell.getDisplay();
        defaultDialog.open();
    }

    private void updateOutput() {
        Display display = this.shellDisplay;
        if (this.shellDisplay.isDisposed()) {
            display = Display.getCurrent();
        }
        if (display == null) {
            return;
        }
        display.syncExec(new Runnable(){

            public void run() {
                SplusEditorPlugin.getDefault().getConsoleDocument().getAndDisplayOutput();
            }
        });
    }
}

