/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.graph;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvas;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.eclipse.graph.DefaultDialog;
import com.insightful.splus.graph.GraphColorsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class SWTGraphColorsDialog
extends DefaultDialog {
    public boolean m_ok = false;
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    public static Vector m_standardColorSchemeIndexNames = new Vector();
    private SCanvas m_canvas = null;
    private ColorScheme m_initCanvasColorScheme = null;
    private boolean m_splusCallable = true;

    public SWTGraphColorsDialog(Shell shell, SCanvas sCanvas, boolean bl) {
        super(shell, "Set Graph Colors");
        this.m_canvas = sCanvas;
        if (this.m_canvas == null) {
            this.m_canvas = SplusSystem.getCanvasHandler().getActiveCanvas();
        }
        this.m_initCanvasColorScheme = this.getCanvasColorScheme();
        this.m_splusCallable = bl;
        if (this.m_splusCallable) {
            SplusSystem.getEngineQueryHandler().processDataQuery("java.colorscheme.update.java()");
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel2.setLayout(new BorderLayout());
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1, 0, 0));
        jPanel3.add(new JLabel("Set Graph Color Scheme"));
        String[] stringArray = SWTGraphColorsDialog.getStandardColorSchemeNames();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    SWTGraphColorsDialog.this.applySchemeToActiveCanvas(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel3.add(this.createJButton(stringArray[i], Integer.toString(i), actionListener));
        }
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(10));
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this.createJButton("Edit Colors...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SWTGraphColorsDialog.this.m_shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            EditColorsDialog editColorsDialog = new EditColorsDialog(SWTGraphColorsDialog.this.m_shell);
                            editColorsDialog.open();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.out);
                            System.out.flush();
                        }
                    }
                });
            }
        }));
        jPanel.add(box);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel2.add(Box.createHorizontalStrut(8), "West");
        jPanel2.add(Box.createHorizontalStrut(8), "East");
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel();
        this.okButton = this.createJButton("OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SWTGraphColorsDialog.this.m_ok = true;
                SWTGraphColorsDialog.this.close();
            }
        });
        jPanel4.add(this.okButton);
        this.cancelButton = this.createJButton("Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SWTGraphColorsDialog.this.m_ok = false;
                SWTGraphColorsDialog.this.applySchemeToActiveCanvas(SWTGraphColorsDialog.this.m_initCanvasColorScheme);
                SWTGraphColorsDialog.this.close();
            }
        });
        jPanel4.add(this.cancelButton);
        jPanel2.add((Component)jPanel4, "South");
        this.SWT_AWT_fromPanel(jPanel2);
    }

    void applySchemeToActiveCanvas(ColorScheme colorScheme) {
        try {
            if (this.m_canvas != null) {
                this.m_canvas.getGraphicsDevice().setColorScheme(colorScheme);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.flush();
        }
    }

    void applySchemeToActiveCanvas(int n) {
        this.applySchemeToActiveCanvas(SWTGraphColorsDialog.getStandardColorScheme(n));
    }

    JButton createJButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    JButton createJButton(String string, ActionListener actionListener) {
        return this.createJButton(string, string, actionListener);
    }

    ColorScheme getCanvasColorScheme() {
        return this.m_canvas == null ? new ColorScheme() : this.m_canvas.getColorScheme();
    }

    public static ColorScheme getStandardColorScheme(int n) {
        Vector vector = GraphColorsDialog.m_standardColorSchemes;
        if (n >= 0 && n < vector.size()) {
            return (ColorScheme)vector.get(n);
        }
        return new ColorScheme();
    }

    public static String getStandardColorSchemeIndexName(int n) {
        Vector vector = GraphColorsDialog.m_standardColorSchemeIndexNames;
        if (n >= 0 && n < vector.size()) {
            return (String)vector.get(n);
        }
        return "";
    }

    public static int getStandardColorSchemeSize() {
        Vector vector = GraphColorsDialog.m_standardColorSchemes;
        return vector.size();
    }

    public static int getDefaultColorSchemeIndex() {
        int n = SWTGraphColorsDialog.getStandardColorSchemeSize();
        for (int i = 0; i < n; ++i) {
            if (!SWTGraphColorsDialog.getStandardColorSchemeIndexName(i).equals("java.colorscheme.default")) continue;
            return i;
        }
        return -1;
    }

    public static ColorScheme getDefaultColorScheme() {
        int n = SWTGraphColorsDialog.getDefaultColorSchemeIndex();
        return SWTGraphColorsDialog.getStandardColorScheme(n);
    }

    public static String[] getStandardColorSchemeNames() {
        int n = SWTGraphColorsDialog.getStandardColorSchemeSize();
        int n2 = SWTGraphColorsDialog.getDefaultColorSchemeIndex();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = SWTGraphColorsDialog.getStandardColorScheme(i).getName();
            if (i == n2) {
                string = "** Default **";
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static void setStandardColorScheme(int n, ColorScheme colorScheme) {
        Vector vector = GraphColorsDialog.m_standardColorSchemes;
        if (n >= 0 && n < vector.size()) {
            vector.set(n, colorScheme);
        }
    }

    class ColorGrid
    extends JPanel {
        Color[] m_colors = null;
        int m_maxColumns = 16;
        int m_selectFrom = 0;
        int m_selectTo = 0;
        MouseInputAdapter m_mouseListener = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = ColorGrid.this.xyToItemNum(n, n2);
                int n4 = ColorGrid.this.selectMin();
                int n5 = ColorGrid.this.selectMax();
                if (n3 >= 0 && n3 < ColorGrid.this.getNumberColors()) {
                    if (mouseEvent.isShiftDown()) {
                        if (n3 < n4) {
                            ColorGrid.this.setFromTo(n5, n3);
                        } else if (n3 > n5) {
                            ColorGrid.this.setFromTo(n4, n3);
                        } else if (n3 - n4 > n5 - n3) {
                            ColorGrid.this.setFromTo(n4, n3);
                        } else {
                            ColorGrid.this.setFromTo(n5, n3);
                        }
                    } else {
                        ColorGrid.this.setFromTo(n3, n3);
                    }
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                int n2 = mouseEvent.getX();
                int n3 = ColorGrid.this.xyToItemNum(n2, n = mouseEvent.getY());
                if (n3 >= 0 && n3 < ColorGrid.this.getNumberColors()) {
                    ColorGrid.this.setFromTo(ColorGrid.this.m_selectFrom, n3);
                }
            }
        };

        ColorGrid(Color[] colorArray, int n) {
            this.m_colors = colorArray;
            this.m_maxColumns = n;
            this.addMouseListener(this.m_mouseListener);
            this.addMouseMotionListener(this.m_mouseListener);
        }

        void setColors(Color[] colorArray) {
            this.m_colors = colorArray;
            this.repaint(1000L);
        }

        Color[] getColors() {
            Color[] colorArray = new Color[this.m_colors.length];
            for (int i = 0; i < this.m_colors.length; ++i) {
                colorArray[i] = this.m_colors[i];
            }
            return colorArray;
        }

        Color getFirstSelectedColor() {
            return this.m_colors[this.selectMin()];
        }

        void setSelectedColors(Color color) {
            for (int i = this.selectMin(); i <= this.selectMax(); ++i) {
                this.m_colors[i] = color;
            }
            this.repaint(1000L);
        }

        Color getColor(int n) {
            return this.m_colors[n];
        }

        void setColor(int n, Color color) {
            this.m_colors[n] = color;
            this.repaint(1000L);
        }

        public void paint(Graphics graphics) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
            for (int i = 0; i < this.getNumberColors(); ++i) {
                this.updateMapItem(graphics, i);
            }
        }

        int getNumberColors() {
            return this.m_colors.length;
        }

        int getBoxWidth() {
            return this.getSize().width / this.m_maxColumns;
        }

        int getBoxHeight() {
            int n = this.getNumberColors() / this.m_maxColumns;
            if (n * this.m_maxColumns < this.getNumberColors()) {
                ++n;
            }
            return this.getSize().height / n;
        }

        int itemNumToX(int n) {
            return n % this.m_maxColumns * this.getBoxWidth();
        }

        int itemNumToY(int n) {
            return n / this.m_maxColumns * this.getBoxHeight();
        }

        int xyToItemNum(int n, int n2) {
            int n3 = n / this.getBoxWidth();
            int n4 = n2 / this.getBoxHeight();
            int n5 = n3 + n4 * this.m_maxColumns;
            if (n4 < 0 || n3 < 0 || n5 >= this.getNumberColors()) {
                n5 = 0;
            }
            return n5;
        }

        void updateMapItem(Graphics graphics, int n) {
            int n2 = this.itemNumToX(n);
            int n3 = this.itemNumToY(n);
            int n4 = this.getBoxWidth();
            int n5 = this.getBoxHeight();
            this.setBackground(Color.white);
            graphics.setColor(Color.white);
            if (n >= this.selectMin() && n <= this.selectMax() && this.getNumberColors() > 1) {
                graphics.setColor(Color.red);
            }
            graphics.fillRect(n2, n3, n4, n5);
            Color color = this.m_colors[n];
            graphics.setColor(color);
            graphics.fillRect(n2 + 2, n3 + 2, n4 - 4, n5 - 4);
            graphics.setColor(Color.black);
            graphics.drawRect(n2 + 2, n3 + 2, n4 - 4, n5 - 4);
        }

        void updateMapItem(int n) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.updateMapItem(graphics, n);
            }
        }

        void updateMapItems(int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                this.updateMapItem(i);
            }
        }

        void setFromTo(int n, int n2) {
            int n3 = this.selectMin();
            int n4 = this.selectMax();
            int n5 = Math.min(n, n2);
            int n6 = Math.max(n, n2);
            this.m_selectFrom = n;
            this.m_selectTo = n2;
            if (n4 < n5 || n3 > n6) {
                this.updateMapItems(n3, n4);
                this.updateMapItems(n5, n6);
            } else if (n5 == n3) {
                this.updateMapItems(Math.min(n6, n4), Math.max(n6, n4));
            } else if (n6 == n4) {
                this.updateMapItems(Math.min(n5, n3), Math.max(n5, n3));
            } else {
                this.updateMapItems(Math.min(n5, n3), Math.max(n6, n4));
            }
        }

        int selectMin() {
            return Math.min(this.m_selectFrom, this.m_selectTo);
        }

        int selectMax() {
            return Math.max(this.m_selectFrom, this.m_selectTo);
        }
    }

    class EditColorsDialog
    extends DefaultDialog {
        private JComboBox m_cbColorScheme;
        private ColorGrid m_backgroundColorGrid;
        private ColorGrid m_paletteColorGrid;
        private ColorGrid m_imageColorGrid;
        private JTextField m_tfName;
        private ColorScheme m_initCS;
        private ColorScheme[] m_modifiedColorSchemes;
        final String BUTTON_EDIT_BACKGROUND = "Edit Background Color...";
        final String BUTTON_EDIT_LINE_COLOR = "Edit Selected Line Color...";
        final String BUTTON_EDIT_IMAGE_COLOR = "Edit Selected Image Color...";
        final String BUTTON_OK = "OK";
        final String BUTTON_CANCEL = "Cancel";
        final String BUTTON_GET_GRAPH_COLORS = "Get Colors From Current Graph";
        final String BUTTON_SET_GRAPH_COLORS = "Set Current Graph Colors";
        final String BUTTON_SET_DEFAULT_COLORSCHEME = "Set Default Color Scheme";
        final String BUTTON_GET_KNOWN_COLORSCHEME = "Get Known Color Scheme";
        final String BUTTON_SET_KNOWN_COLORSCHEME = "Set Known Color Scheme";
        final int BACKGROUND_GRID = 0;
        final int PALETTE_GRID = 1;
        final int IMAGE_GRID = 2;
        ActionListener m_buttonListener;

        public EditColorsDialog(Shell shell) {
            super(shell, "Edit Graph Colors");
            this.m_cbColorScheme = null;
            this.BUTTON_EDIT_BACKGROUND = "Edit Background Color...";
            this.BUTTON_EDIT_LINE_COLOR = "Edit Selected Line Color...";
            this.BUTTON_EDIT_IMAGE_COLOR = "Edit Selected Image Color...";
            this.BUTTON_OK = "OK";
            this.BUTTON_CANCEL = "Cancel";
            this.BUTTON_GET_GRAPH_COLORS = "Get Colors From Current Graph";
            this.BUTTON_SET_GRAPH_COLORS = "Set Current Graph Colors";
            this.BUTTON_SET_DEFAULT_COLORSCHEME = "Set Default Color Scheme";
            this.BUTTON_GET_KNOWN_COLORSCHEME = "Get Known Color Scheme";
            this.BUTTON_SET_KNOWN_COLORSCHEME = "Set Known Color Scheme";
            this.BACKGROUND_GRID = 0;
            this.PALETTE_GRID = 1;
            this.IMAGE_GRID = 2;
            this.m_buttonListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    int n = EditColorsDialog.this.m_cbColorScheme.getSelectedIndex();
                    if (string.equals("Edit Background Color...")) {
                        EditColorsDialog.this.chooseColor(0);
                    } else if (string.equals("Edit Selected Line Color...")) {
                        EditColorsDialog.this.chooseColor(1);
                    } else if (string.equals("Edit Selected Image Color...")) {
                        EditColorsDialog.this.chooseColor(2);
                    } else if (string.equals("OK")) {
                        SWTGraphColorsDialog.this.applySchemeToActiveCanvas(EditColorsDialog.this.getColorScheme());
                        EditColorsDialog.this.updateModifiedColorSchemes();
                        EditColorsDialog.this.close();
                    } else if (string.equals("Cancel")) {
                        SWTGraphColorsDialog.this.applySchemeToActiveCanvas(EditColorsDialog.this.m_initCS);
                        EditColorsDialog.this.close();
                    } else if (string.equals("Get Known Color Scheme")) {
                        EditColorsDialog.this.updateDisplay(EditColorsDialog.this.getModifiedColorScheme(n));
                    } else if (string.equals("Set Known Color Scheme")) {
                        EditColorsDialog.this.setModifiedColorScheme(n, EditColorsDialog.this.getColorScheme());
                    } else if (string.equals("Set Default Color Scheme")) {
                        EditColorsDialog.this.setModifiedColorScheme(SWTGraphColorsDialog.getDefaultColorSchemeIndex(), EditColorsDialog.this.getColorScheme());
                    } else if (string.equals("Get Colors From Current Graph")) {
                        EditColorsDialog.this.updateDisplay(SWTGraphColorsDialog.this.getCanvasColorScheme());
                    } else if (string.equals("Set Current Graph Colors")) {
                        SWTGraphColorsDialog.this.applySchemeToActiveCanvas(EditColorsDialog.this.getColorScheme());
                    }
                }
            };
            this.m_initCS = SWTGraphColorsDialog.this.getCanvasColorScheme();
            int n = SWTGraphColorsDialog.getStandardColorSchemeSize();
            this.m_modifiedColorSchemes = new ColorScheme[n];
            for (int i = 0; i < n; ++i) {
                this.m_modifiedColorSchemes[i] = null;
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentX(0.0f);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Color Scheme Name"));
            this.m_tfName = new JTextField();
            this.m_tfName.setText(this.m_initCS.getName());
            jPanel2.add(this.m_tfName);
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setBorder(BorderFactory.createTitledBorder("Background Color"));
            this.m_backgroundColorGrid = new ColorGrid(new Color[]{this.m_initCS.getBackgroundColor()}, 1);
            this.m_backgroundColorGrid.setPreferredSize(new Dimension(450, 20));
            jPanel3.add(this.m_backgroundColorGrid);
            jPanel3.add(Box.createVerticalStrut(4));
            jPanel3.add(this.createJButton("Edit Background Color..."));
            jPanel.add(jPanel3);
            jPanel.add(Box.createVerticalStrut(2));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Line Colors"));
            this.m_paletteColorGrid = new ColorGrid(this.m_initCS.getPaletteColors(), 4);
            this.m_paletteColorGrid.setPreferredSize(new Dimension(450, 40));
            jPanel4.add(this.m_paletteColorGrid);
            jPanel4.add(Box.createVerticalStrut(4));
            jPanel4.add(this.createJButton("Edit Selected Line Color..."));
            jPanel.add(jPanel4);
            jPanel.add(Box.createVerticalStrut(2));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 1));
            jPanel5.setBorder(BorderFactory.createTitledBorder("Image Colors"));
            this.m_imageColorGrid = new ColorGrid(this.m_initCS.getImageColors(), 32);
            this.m_imageColorGrid.setPreferredSize(new Dimension(450, 80));
            jPanel5.add(this.m_imageColorGrid);
            jPanel5.add(Box.createVerticalStrut(4));
            jPanel5.add(this.createJButton("Edit Selected Image Color..."));
            jPanel.add(jPanel5);
            jPanel.add(Box.createVerticalStrut(2));
            String[] stringArray = SWTGraphColorsDialog.getStandardColorSchemeNames();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Integer.toString(i + 1) + ": " + stringArray[i];
            }
            this.m_cbColorScheme = new JComboBox<String>(stringArray);
            this.m_cbColorScheme.setSelectedIndex(SWTGraphColorsDialog.getDefaultColorSchemeIndex());
            this.m_cbColorScheme.setEditable(false);
            JPanel jPanel6 = new JPanel(new FlowLayout(0));
            jPanel6.setBorder(BorderFactory.createTitledBorder("Color Schemes"));
            jPanel6.add(this.m_cbColorScheme);
            jPanel6.add(this.createJButton("Get Colors", "Get Known Color Scheme"));
            jPanel6.add(this.createJButton("Set Color Scheme", "Set Known Color Scheme"));
            jPanel.add(jPanel6);
            jPanel.setAlignmentX(0.0f);
            jPanel.add(Box.createVerticalStrut(7));
            JPanel jPanel7 = new JPanel();
            jPanel7.add(this.createJButton("Get Graph Colors", "Get Colors From Current Graph"));
            jPanel7.add(this.createJButton("Set Graph Colors", "Set Current Graph Colors"));
            jPanel7.add(this.createJButton("Set Default Color Scheme", "Set Default Color Scheme"));
            jPanel.add(jPanel7);
            jPanel.setAlignmentX(0.0f);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add(Box.createHorizontalStrut(8), "West");
            jPanel8.add(Box.createHorizontalStrut(8), "East");
            jPanel8.add((Component)jPanel, "Center");
            JPanel jPanel9 = new JPanel();
            jPanel9.add(this.createJButton("OK"));
            jPanel9.add(this.createJButton("Cancel"));
            jPanel8.add((Component)jPanel9, "South");
            this.SWT_AWT_fromPanel(jPanel8);
        }

        ColorScheme getModifiedColorScheme(int n) {
            ColorScheme colorScheme = this.m_modifiedColorSchemes[n];
            return colorScheme != null ? colorScheme : SWTGraphColorsDialog.getStandardColorScheme(n);
        }

        void setModifiedColorScheme(int n, ColorScheme colorScheme) {
            this.m_modifiedColorSchemes[n] = colorScheme;
        }

        void updateModifiedColorSchemes() {
            boolean bl = false;
            for (int i = 0; i < this.m_modifiedColorSchemes.length; ++i) {
                ColorScheme colorScheme = this.m_modifiedColorSchemes[i];
                if (colorScheme == null) continue;
                SWTGraphColorsDialog.setStandardColorScheme(i, colorScheme);
                bl = true;
            }
            if (bl) {
                this.updateSplusStandardColorSchemes();
            }
        }

        ColorScheme getColorScheme() {
            ColorScheme colorScheme = new ColorScheme(this.m_tfName.getText(), this.m_backgroundColorGrid.getColor(0), this.m_paletteColorGrid.getColors(), this.m_imageColorGrid.getColors());
            return colorScheme;
        }

        JButton createJButton(String string) {
            return this.createJButton(string, string);
        }

        JButton createJButton(String string, String string2) {
            return SWTGraphColorsDialog.this.createJButton(string, string2, this.m_buttonListener);
        }

        void chooseColor(final int n) {
            String string;
            String string2 = n == 0 ? "Edit Background Color" : (string = n == 1 ? "Edit Line Color" : "Edit Image Color");
            final Color color = n == 0 ? this.m_backgroundColorGrid.getColor(0) : (n == 1 ? this.m_paletteColorGrid.getFirstSelectedColor() : this.m_imageColorGrid.getFirstSelectedColor());
            this.m_shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SWTColorChooserDialog sWTColorChooserDialog = new SWTColorChooserDialog(EditColorsDialog.this.m_shell, string, color);
                    sWTColorChooserDialog.open();
                    if (!sWTColorChooserDialog.m_ok) {
                        return;
                    }
                    Color color2 = sWTColorChooserDialog.m_colorChooser.getSelectionModel().getSelectedColor();
                    if (color2 == null) {
                        return;
                    }
                    if (n == 0) {
                        EditColorsDialog.this.m_backgroundColorGrid.setColor(0, color2);
                    } else if (n == 1) {
                        EditColorsDialog.this.m_paletteColorGrid.setSelectedColors(color2);
                    } else {
                        EditColorsDialog.this.m_imageColorGrid.setSelectedColors(color2);
                    }
                }
            });
        }

        void updateDisplay(ColorScheme colorScheme) {
            this.m_tfName.setText(colorScheme.getName());
            this.m_backgroundColorGrid.setColors(new Color[]{colorScheme.getBackgroundColor()});
            this.m_paletteColorGrid.setColors(colorScheme.getPaletteColors());
            this.m_imageColorGrid.setColors(colorScheme.getImageColors());
        }

        void updateSplusStandardColorSchemes() {
            if (SWTGraphColorsDialog.this.m_splusCallable) {
                SplusSystem.getEngineQueryHandler().processDataQuery("java.colorscheme.update.splus()");
            } else {
                String string = "The S-PLUS color scheme variables have not been updated.\nTo update them, execute java.colorscheme.update.splus()";
                ErrorDialog.openError((Shell)this.m_shell, (String)"Warning", (String)string, null, (int)2);
            }
        }

        public class SWTColorChooserDialog
        extends DefaultDialog {
            JColorChooser m_colorChooser;
            Color m_initColor;
            boolean m_ok;

            public SWTColorChooserDialog(Shell shell, String string, Color color) {
                super(shell, string);
                this.m_initColor = color;
                this.m_ok = false;
                this.m_colorChooser = new JColorChooser(this.m_initColor);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)this.m_colorChooser, "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout());
                jPanel2.add(Box.createHorizontalStrut(5));
                JButton jButton = new JButton("OK");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SWTColorChooserDialog.this.m_ok = true;
                        SWTColorChooserDialog.this.close();
                    }
                });
                jPanel2.add(jButton);
                jPanel2.add(Box.createHorizontalStrut(5));
                JButton jButton2 = new JButton("Cancel");
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SWTColorChooserDialog.this.close();
                    }
                });
                jPanel2.add(jButton2);
                jPanel2.add(Box.createHorizontalStrut(5));
                jPanel.add((Component)jPanel2, "South");
                this.SWT_AWT_fromPanel(jPanel);
            }
        }
    }
}

