/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.packages;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.packages.SplusErrorWarningDialog;
import com.insightful.splus.eclipse.packages.SplusInstallLoadUpdatePackagesDialog;
import com.insightful.splus.eclipse.views.util.SplusDecoratingLabelProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.rmi.RemoteException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SplusExportPackageWizard
extends Wizard
implements IExportWizard {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String EXPORT_DIALOG_SETTINGS = "SplusPackageExportSettings";
    private static final String DESTINATIONS = "com.insightful.splus.eclipse.export.package.destinations";
    private IStructuredSelection m_selection;
    private IWizardPage m_exportPage;
    private Text m_projectName;
    private Combo m_exportLocationName;
    private Button m_sourceBuild;
    private Button m_binaryBuild;

    public SplusExportPackageWizard() {
        SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
        IDialogSettings iDialogSettings = splusEditorPlugin.getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(EXPORT_DIALOG_SETTINGS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(EXPORT_DIALOG_SETTINGS);
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.m_selection = iStructuredSelection;
        this.setWindowTitle("Export Spotfire S+ Package");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.m_exportPage = new WizardPage("Spotfire S+ Package"){
            private Listener _pageStateListener;
            {
                this._pageStateListener = null;
            }

            private Listener getPageStateListener() {
                if (this._pageStateListener == null) {
                    this._pageStateListener = new Listener(){

                        public void handleEvent(Event event) {
                            Object object;
                            IProject iProject;
                            if (SplusExportPackageWizard.this.m_projectName != null && !(iProject = (object = ResourcesPlugin.getWorkspace()).getRoot().getProject(SplusExportPackageWizard.this.m_projectName.getText())).exists()) {
                                this.setErrorMessage("Valid Project must be selected.");
                                this.setPageComplete(false);
                                return;
                            }
                            if (SplusExportPackageWizard.this.m_exportLocationName != null && ((String)(object = SplusExportPackageWizard.this.m_exportLocationName.getText())).length() == 0) {
                                this.setErrorMessage("Valid export location must be selected.");
                                this.setPageComplete(false);
                                return;
                            }
                            this.setPageComplete(true);
                        }
                    };
                }
                return this._pageStateListener;
            }

            public void createControl(Composite composite) {
                IProject iProject;
                IResource iResource;
                Composite composite2 = new Composite(composite, 0);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 3;
                composite2.setLayout((Layout)gridLayout);
                composite2.setLayoutData((Object)new GridData(768));
                Label label = new Label(composite2, 0);
                label.setText("Export Package:");
                label.setFont(composite.getFont());
                SplusExportPackageWizard.this.m_projectName = new Text(composite2, 2048);
                SplusExportPackageWizard.this.m_projectName.addListener(24, this.getPageStateListener());
                GridData gridData = new GridData(768);
                gridData.widthHint = 250;
                SplusExportPackageWizard.this.m_projectName.setLayoutData((Object)gridData);
                SplusExportPackageWizard.this.m_projectName.setFont(composite.getFont());
                if (!SplusExportPackageWizard.this.m_selection.isEmpty()) {
                    iResource = (IResource)SplusExportPackageWizard.this.m_selection.getFirstElement();
                    iProject = iResource.getProject();
                    SplusExportPackageWizard.this.m_projectName.setText(iProject.getName());
                }
                iResource = new Button(composite2, 0);
                iResource.setText("Browse...");
                iResource.setFont(composite.getFont());
                iResource.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        IProject iProject = SplusExportPackageWizard.this.chooseProject(SplusExportPackageWizard.this.m_projectName.getShell());
                        SplusExportPackageWizard.this.m_projectName.setText(iProject.getName());
                    }
                });
                iProject = new Group(composite2, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                iProject.setLayoutData((Object)gridData);
                iProject.setText("Build Options");
                gridLayout = new GridLayout();
                gridLayout.numColumns = 3;
                iProject.setLayout((Layout)gridLayout);
                SplusExportPackageWizard.this.m_sourceBuild = new Button((Composite)iProject, 16);
                SplusExportPackageWizard.this.m_sourceBuild.setText("Build Source Package");
                gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                SplusExportPackageWizard.this.m_sourceBuild.setLayoutData((Object)gridData);
                SplusExportPackageWizard.this.m_sourceBuild.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        SplusExportPackageWizard.this.updateDialogState();
                    }
                });
                SplusExportPackageWizard.this.m_binaryBuild = new Button((Composite)iProject, 16);
                SplusExportPackageWizard.this.m_binaryBuild.setText("Build Binary Package");
                gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                SplusExportPackageWizard.this.m_binaryBuild.setLayoutData((Object)gridData);
                SplusExportPackageWizard.this.m_binaryBuild.setSelection(true);
                SplusExportPackageWizard.this.m_binaryBuild.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        SplusExportPackageWizard.this.updateDialogState();
                    }
                });
                Label label2 = new Label((Composite)iProject, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                label2.setLayoutData((Object)gridData);
                Label label3 = new Label((Composite)iProject, 0);
                label3.setText("Export Location:");
                label3.setFont(composite.getFont());
                SplusExportPackageWizard.this.m_exportLocationName = new Combo((Composite)iProject, 2052);
                SplusExportPackageWizard.this.m_exportLocationName.addListener(24, this.getPageStateListener());
                SplusInstallLoadUpdatePackagesDialog.loadComboFromSettings(SplusExportPackageWizard.this.m_exportLocationName, this.getDialogSettings(), SplusExportPackageWizard.DESTINATIONS);
                gridData = new GridData(768);
                gridData.widthHint = 250;
                SplusExportPackageWizard.this.m_exportLocationName.setLayoutData((Object)gridData);
                SplusExportPackageWizard.this.m_exportLocationName.setFont(composite.getFont());
                Button button = new Button((Composite)iProject, 0);
                button.setText("Browse...");
                button.setFont(composite.getFont());
                button.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        String string = SplusExportPackageWizard.this.chooseExternalLocation(SplusExportPackageWizard.this.m_exportLocationName.getShell());
                        SplusExportPackageWizard.this.m_exportLocationName.setText(string);
                    }
                });
                gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                Label label4 = new Label(composite2, 0);
                label4.setLayoutData((Object)gridData);
                this.setControl((Control)composite2);
            }
        };
        this.m_exportPage.setDescription("Export Spotfire S+ Project as Spotfire S+ Package");
        this.m_exportPage.setTitle("Export Spotfire S+ Package");
        this.addPage(this.m_exportPage);
    }

    private void updateDialogState() {
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    private String chooseExternalLocation(Shell shell) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        return directoryDialog.open();
    }

    private IProject chooseProject(Shell shell) {
        Object[] objectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject();
        SplusDecoratingLabelProvider splusDecoratingLabelProvider = new SplusDecoratingLabelProvider();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(shell, (ILabelProvider)splusDecoratingLabelProvider);
        elementListSelectionDialog.setTitle("Choose Project");
        elementListSelectionDialog.setMessage("Select Project to add Package to.");
        elementListSelectionDialog.setElements(objectArray);
        elementListSelectionDialog.setInitialSelections(new Object[]{iProject});
        if (elementListSelectionDialog.open() == 0) {
            return (IProject)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    public boolean performFinish() {
        Shell shell = this.m_exportLocationName.getShell();
        shell.setCursor(Display.getCurrent().getSystemCursor(1));
        boolean bl = true;
        SplusInstallLoadUpdatePackagesDialog.saveComboFromSettings(this.m_exportLocationName, this.getDialogSettings(), DESTINATIONS);
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.m_projectName.getText());
        String string = iProject.getLocation().toOSString();
        String string2 = this.m_exportLocationName.getText();
        String string3 = DefaultConnection.getShome();
        boolean bl2 = this.m_binaryBuild.getSelection();
        String[] stringArray = new String[bl2 ? 5 : 4];
        int n = 0;
        stringArray[n++] = SplusEditorPlugin.g_isWindowsOS ? "\"" + string3 + "\\Splus.bat\"" : string3 + "/cmd/Splus";
        stringArray[n++] = "CMD";
        stringArray[n++] = "build";
        if (bl2) {
            stringArray[n++] = "--binary";
        }
        stringArray[n++] = SplusEditorPlugin.g_isWindowsOS ? "\"" + string + "\"" : string;
        File file = new File(string2);
        File file2 = null;
        try {
            Object object;
            Object object2;
            Process process = null;
            file.mkdirs();
            if (SplusEditorPlugin.g_isWindowsOS) {
                process = Runtime.getRuntime().exec(stringArray, null, new File(string2));
            } else {
                file2 = File.createTempFile("temp.build.file", "bat");
                file2.deleteOnExit();
                object2 = new FileWriter(file2);
                ((Writer)object2).write("#! /bin/sh -\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    ((Writer)object2).write(stringArray[i]);
                    ((Writer)object2).write(" ");
                }
                ((Writer)object2).write("\n");
                ((Writer)object2).close();
                object = file2.getCanonicalPath();
                Runtime.getRuntime().exec(new String[]{"chmod", "777", object});
                process = Runtime.getRuntime().exec(new String[]{"sh", object}, null, new File(string2));
            }
            object2 = new ProcessMonitor(process, process.getErrorStream());
            object = new ProcessMonitor(process, process.getInputStream());
            ((Thread)object2).start();
            ((Thread)object).start();
            try {
                int n2 = process.waitFor();
                if (!(n2 == 0 && ((ProcessMonitor)object2).toString().length() == 0 || this.handleError(((ProcessMonitor)object).toString(), ((ProcessMonitor)object2).toString()))) {
                    bl = false;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (file2 != null) {
                file2.delete();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = this.handleError(null, iOException.getMessage());
        }
        shell.setCursor(Display.getCurrent().getSystemCursor(0));
        return bl;
    }

    private SplusDataResult makeCallAndHandleSplusErrors(String string) {
        SplusDataResult splusDataResult = SplusExportPackageWizard.splusCall(string);
        if (splusDataResult.hasError() || splusDataResult.hasWarning()) {
            Display display;
            StringBuffer stringBuffer = new StringBuffer();
            if (splusDataResult.hasError()) {
                stringBuffer.append(splusDataResult.getError());
            }
            if (splusDataResult.hasWarning()) {
                display = splusDataResult.getWarning();
                for (int i = 0; i < ((Display)display).length; ++i) {
                    stringBuffer.append((String)display[i]);
                    stringBuffer.append('\n');
                }
            }
            display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
            SplusErrorWarningDialog splusErrorWarningDialog = new SplusErrorWarningDialog(display.getActiveShell(), splusDataResult.getOutput(), stringBuffer.toString());
            splusErrorWarningDialog.open();
        }
        return splusDataResult;
    }

    private static SplusDataResult splusCall(String string) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        SplusDataResult splusDataResult = null;
        int n = 20;
        if (noConnection instanceof DefaultConnection) {
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            while (true) {
                try {
                    splusDataResult = defaultConnection.doDataQuery(string);
                }
                catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
                    splusIncompleteExpressionException.printStackTrace();
                }
                catch (SplusEngineBusyException splusEngineBusyException) {
                    if (n-- <= 0) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                break;
            }
        }
        return splusDataResult;
    }

    private boolean handleError(final String string, final String string2) {
        final Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
        final boolean[] blArray = new boolean[]{true};
        display.syncExec(new Runnable(){

            public void run() {
                SplusErrorWarningDialog splusErrorWarningDialog = new SplusErrorWarningDialog(display.getActiveShell(), string, string2);
                blArray[0] = splusErrorWarningDialog.open();
            }
        });
        return blArray[0];
    }

    private class ProcessMonitor
    extends Thread {
        private StringBuffer buffer;
        private InputStream stream;
        private Process process;

        public ProcessMonitor(Process process, InputStream inputStream) {
            super("SplusExportPackageWizard-monitorExport");
            this.process = process;
            this.stream = inputStream;
            this.buffer = new StringBuffer();
        }

        public String toString() {
            return this.buffer.toString();
        }

        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    try {
                        while (this.stream.available() > 0) {
                            Character c = new Character((char)this.stream.read());
                            this.buffer.append(c);
                        }
                        this.process.exitValue();
                        bl = true;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl = true;
                }
            }
        }
    }
}

