/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.packages;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusStringDataResult;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.graph.DefaultDialog;
import com.insightful.splus.eclipse.packages.SplusErrorWarningDialog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;

public class SplusInstallLoadUpdatePackagesDialog
extends Dialog {
    private static final String PACKAGE_DIALOG_SETTINGS = "packageDialogSettings";
    private static final String REPOSITORY_LIST = "com.insightful.splus.eclipse.packages.repository";
    private static final String LOCAL_PACKAGE_LIST = "com.insightful.splus.eclipse.packages.local";
    private static final String INSTALL_OPTIONS = "com.insightful.splus.eclipse.packages.install.options";
    private static final String DO_LOCAL = "com.insightful.splus.eclipse.packages.do.local";
    private static final String GET_SOURCE = "com.insightful.splus.eclipse.packages.source";
    private static final String DEST_DIR = "com.insightful.splus.eclipse.packages.destdir";
    private static final String INSTALL = "install";
    private static final String LOAD = "load";
    private static final String SOURCE = "source";
    private static final String WARNING_WINDOW_TITLE = "Warning";
    private static final String ERROR_WINDOW_TITLE = "Error";
    private static IDialogSettings g_settings = null;
    private Combo m_repositoryCombo;
    private Combo m_localPackageLocation;
    private Combo m_installAsNewProjectLocation;
    private org.eclipse.swt.widgets.List m_packageList;
    private Button m_ok;
    private Button m_cancel;
    private Button m_localPackageButton;
    private Button m_installOnly;
    private Button m_installAndLoad;
    private Button m_localPackageBrowse;
    private Button m_src;
    private Button m_binary;
    private Button m_installAsNewProject;
    private Button m_installAsNewProjectBrowse;
    private Label m_projectLocationLabel;
    private boolean m_result = true;
    private boolean m_doUpdate = false;
    private IDialogSettings m_settings;
    private Listener m_stateChangeListener = new Listener(){

        public void handleEvent(Event event) {
            SplusInstallLoadUpdatePackagesDialog.this.updateDialogState();
        }
    };

    private static IDialogSettings getDialogSettings() {
        SplusEditorPlugin splusEditorPlugin;
        IDialogSettings iDialogSettings;
        if (g_settings == null && (g_settings = (iDialogSettings = (splusEditorPlugin = SplusEditorPlugin.getDefault()).getDialogSettings()).getSection(PACKAGE_DIALOG_SETTINGS)) == null) {
            g_settings = iDialogSettings.addNewSection(PACKAGE_DIALOG_SETTINGS);
        }
        return g_settings;
    }

    public static void loadRepositoryList(Combo combo) {
        SplusInstallLoadUpdatePackagesDialog.loadComboFromSettings(combo, SplusInstallLoadUpdatePackagesDialog.getDialogSettings(), REPOSITORY_LIST);
        String string = SplusInstallLoadUpdatePackagesDialog.getSplusOption("repos", "http://spotfire.tibco.com/csan");
        if (combo.getItemCount() == 0) {
            SplusInstallLoadUpdatePackagesDialog.getDialogSettings().put(REPOSITORY_LIST, new String[]{string});
            SplusInstallLoadUpdatePackagesDialog.loadComboFromSettings(combo, SplusInstallLoadUpdatePackagesDialog.getDialogSettings(), REPOSITORY_LIST);
        }
    }

    public static void saveRepositoryList(Combo combo) {
        SplusInstallLoadUpdatePackagesDialog.saveComboFromSettings(combo, SplusInstallLoadUpdatePackagesDialog.getDialogSettings(), REPOSITORY_LIST);
    }

    public static void loadInstallOptions(Button button, Button button2, Button button3) {
        String string = SplusInstallLoadUpdatePackagesDialog.getDialogSettings().get(INSTALL_OPTIONS);
        if (string == null || string.indexOf(SOURCE) != -1) {
            button3.setSelection(true);
        }
        if (string == null || string.indexOf(INSTALL) != -1) {
            button.setSelection(true);
            if (button3.getParent().equals(button.getParent())) {
                button3.setSelection(false);
            }
        }
        if (string != null && string.indexOf(LOAD) != -1) {
            button2.setSelection(true);
            if (button3.getParent().equals(button2.getParent())) {
                button3.setSelection(false);
            }
        }
    }

    public static void saveInstallOptions(Button button, Button button2, Button button3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (button.getSelection()) {
            stringBuffer.append(INSTALL);
        }
        if (button2.getSelection()) {
            stringBuffer.append(LOAD);
        }
        if (button3.getSelection()) {
            stringBuffer.append(SOURCE);
        }
        SplusInstallLoadUpdatePackagesDialog.getDialogSettings().put(INSTALL_OPTIONS, stringBuffer.toString());
    }

    private static String getSplusOption(String string, String string2) {
        String string3 = string2;
        SplusDataResult splusDataResult = SplusInstallLoadUpdatePackagesDialog.splusCall("{options()$" + string + "}");
        if (!splusDataResult.hasError()) {
            try {
                string3 = splusDataResult.getStringData()[0];
            }
            catch (SplusBadDataException splusBadDataException) {
                splusBadDataException.printStackTrace();
            }
        }
        return string3;
    }

    private void addDialogStateListener() {
        this.m_repositoryCombo.addListener(24, this.m_stateChangeListener);
        this.m_packageList.addListener(13, this.m_stateChangeListener);
        this.m_src.addListener(13, this.m_stateChangeListener);
        this.m_binary.addListener(13, this.m_stateChangeListener);
        this.m_installOnly.addListener(13, this.m_stateChangeListener);
        this.m_installAndLoad.addListener(13, this.m_stateChangeListener);
        this.m_installAsNewProject.addListener(13, this.m_stateChangeListener);
        this.m_installAsNewProjectLocation.addListener(24, this.m_stateChangeListener);
        if (!this.m_doUpdate) {
            this.m_localPackageLocation.addListener(24, this.m_stateChangeListener);
            this.m_localPackageButton.addListener(13, this.m_stateChangeListener);
        }
    }

    public SplusInstallLoadUpdatePackagesDialog(Shell shell) {
        super(shell, 66800);
        SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
        IDialogSettings iDialogSettings = splusEditorPlugin.getDialogSettings();
        this.m_settings = iDialogSettings.getSection(PACKAGE_DIALOG_SETTINGS);
        if (this.m_settings == null) {
            this.m_settings = iDialogSettings.addNewSection(PACKAGE_DIALOG_SETTINGS);
        }
    }

    public void setUpdate(boolean bl) {
        this.m_doUpdate = bl;
    }

    protected void createContents(final Shell shell) {
        Composite composite;
        shell.setLayout((Layout)new GridLayout(1, true));
        Group group = new Group((Composite)shell, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite2, 0);
        label.setText("Type:        ");
        this.m_src = new Button(composite2, 16);
        this.m_src.setText("Source");
        this.m_binary = new Button(composite2, 16);
        this.m_binary.setText("Binary");
        this.m_binary.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.this.doUpdatePackageList();
            }
        });
        this.m_src.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.this.doUpdatePackageList();
            }
        });
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayoutData((Object)new GridData(768));
        composite3.setLayout((Layout)new GridLayout(3, false));
        Label label2 = new Label(composite3, 0);
        label2.setText("Repository:");
        this.m_repositoryCombo = new Combo(composite3, 0);
        this.m_repositoryCombo.setLayoutData((Object)new GridData(768));
        SplusInstallLoadUpdatePackagesDialog.loadRepositoryList(this.m_repositoryCombo);
        this.m_binary.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.this.updateDialogState();
            }
        });
        this.m_src.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.this.updateDialogState();
            }
        });
        if (this.m_settings.getBoolean(GET_SOURCE) || SplusEditorPlugin.g_isWindowsOS) {
            this.m_src.setSelection(true);
        } else {
            this.m_binary.setSelection(true);
        }
        if (!SplusEditorPlugin.g_isWindowsOS) {
            this.m_binary.setSelection(false);
            this.m_binary.setVisible(false);
            this.m_src.setSelection(true);
        }
        Button button = new Button(composite3, 0);
        button.setText("Update");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.this.doUpdatePackageList();
            }
        });
        Composite composite4 = new Composite((Composite)group, 0);
        composite4.setLayoutData((Object)new GridData(1808));
        composite4.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label(composite4, 0);
        label3.setLayoutData((Object)new GridData(1040));
        label3.setText("Packages:  ");
        this.m_packageList = new org.eclipse.swt.widgets.List(composite4, 2562);
        this.m_packageList.setLayoutData((Object)new GridData(1808));
        if (!this.m_doUpdate) {
            composite = new Composite((Composite)group, 0);
            composite.setLayoutData((Object)new GridData(768));
            composite.setLayout((Layout)new GridLayout(3, false));
            this.m_localPackageButton = new Button(composite, 32);
            this.m_localPackageButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SplusInstallLoadUpdatePackagesDialog.this.updateDialogState();
                }
            });
            this.m_localPackageButton.setText("Local Package");
            if (this.m_settings.getBoolean(DO_LOCAL)) {
                this.m_localPackageButton.setSelection(true);
            }
            this.m_localPackageLocation = new Combo(composite, 0);
            this.m_localPackageLocation.setLayoutData((Object)new GridData(768));
            SplusInstallLoadUpdatePackagesDialog.loadComboFromSettings(this.m_localPackageLocation, this.m_settings, LOCAL_PACKAGE_LIST);
            this.m_localPackageBrowse = new Button(composite, 0);
            this.m_localPackageBrowse.setText("Browse...");
            this.m_localPackageBrowse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String string = SplusInstallLoadUpdatePackagesDialog.this.chooseExternalFile(SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation.getShell());
                    SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation.setText(string);
                }
            });
        }
        composite = new Group((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setText("Install Options");
        Composite composite5 = new Composite(composite, 0);
        composite5.setLayout((Layout)new GridLayout(3, false));
        composite5.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.m_installOnly = new Button(composite5, 16);
        this.m_installOnly.setText("Install Binary");
        this.m_installOnly.setLayoutData((Object)gridData);
        this.m_installAndLoad = new Button(composite5, 16);
        this.m_installAndLoad.setLayoutData((Object)gridData);
        this.m_installAndLoad.setText("Install Binary + Load");
        Composite composite6 = null;
        if (SplusEditorPlugin.g_isWindowsOS) {
            composite6 = new Composite(composite, 0);
            composite6.setLayout((Layout)new GridLayout(3, false));
            composite6.setLayoutData((Object)new GridData(768));
        } else {
            composite6 = composite5;
        }
        this.m_installAsNewProject = new Button(composite6, 16);
        this.m_installAsNewProject.setText("Copy Source To");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.m_installAsNewProject.setLayoutData((Object)gridData);
        this.m_projectLocationLabel = new Label(composite6, 0);
        this.m_projectLocationLabel.setText("Project Directory:");
        GridData gridData2 = new GridData();
        gridData2.horizontalIndent = 20;
        this.m_projectLocationLabel.setLayoutData((Object)gridData2);
        this.m_installAsNewProjectLocation = new Combo(composite6, 2048);
        this.m_installAsNewProjectLocation.setLayoutData((Object)new GridData(768));
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IPath iPath = iWorkspace.getRoot().getLocation();
        String string = iPath.toOSString();
        String[] stringArray = this.m_settings.getArray(DEST_DIR);
        this.m_settings.put(DEST_DIR, SplusInstallLoadUpdatePackagesDialog.ensurePresentInHistory(stringArray, string));
        SplusInstallLoadUpdatePackagesDialog.loadComboFromSettings(this.m_installAsNewProjectLocation, this.m_settings, DEST_DIR);
        this.m_installAsNewProjectBrowse = new Button(composite6, 0);
        this.m_installAsNewProjectBrowse.setText("Browse...");
        this.m_installAsNewProjectBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String string = SplusInstallLoadUpdatePackagesDialog.this.chooseExternalDirectory(SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation.getShell());
                SplusInstallLoadUpdatePackagesDialog.this.m_installAsNewProjectLocation.setText(string);
            }
        });
        SplusInstallLoadUpdatePackagesDialog.loadInstallOptions(this.m_installOnly, this.m_installAndLoad, this.m_installAsNewProject);
        Composite composite7 = new Composite((Composite)shell, 0);
        composite7.setLayoutData((Object)new GridData(128));
        FillLayout fillLayout = new FillLayout(256);
        composite7.setLayout((Layout)fillLayout);
        fillLayout.marginWidth = 2;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        this.m_ok = new Button(composite7, 0);
        this.m_ok.setText("&OK");
        this.m_cancel = new Button(composite7, 0);
        this.m_cancel.setText("&Cancel");
        this.m_ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.saveComboFromSettings(SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation, SplusInstallLoadUpdatePackagesDialog.this.m_settings, SplusInstallLoadUpdatePackagesDialog.LOCAL_PACKAGE_LIST);
                SplusInstallLoadUpdatePackagesDialog.saveComboFromSettings(SplusInstallLoadUpdatePackagesDialog.this.m_installAsNewProjectLocation, SplusInstallLoadUpdatePackagesDialog.this.m_settings, SplusInstallLoadUpdatePackagesDialog.DEST_DIR);
                SplusInstallLoadUpdatePackagesDialog.saveRepositoryList(SplusInstallLoadUpdatePackagesDialog.this.m_repositoryCombo);
                SplusInstallLoadUpdatePackagesDialog.saveInstallOptions(SplusInstallLoadUpdatePackagesDialog.this.m_installOnly, SplusInstallLoadUpdatePackagesDialog.this.m_installAndLoad, SplusInstallLoadUpdatePackagesDialog.this.m_installAsNewProject);
                if (SplusInstallLoadUpdatePackagesDialog.this.m_binary != null) {
                    SplusInstallLoadUpdatePackagesDialog.this.m_settings.put(SplusInstallLoadUpdatePackagesDialog.GET_SOURCE, SplusInstallLoadUpdatePackagesDialog.this.m_src.getSelection());
                }
                if (SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton != null) {
                    SplusInstallLoadUpdatePackagesDialog.this.m_settings.put(SplusInstallLoadUpdatePackagesDialog.DO_LOCAL, SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton.getSelection());
                }
                try {
                    if (SplusInstallLoadUpdatePackagesDialog.this.ok()) {
                        SplusInstallLoadUpdatePackagesDialog.this.m_result = true;
                        shell.close();
                        shell.dispose();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        });
        this.m_cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusInstallLoadUpdatePackagesDialog.this.m_result = false;
                shell.close();
                shell.dispose();
            }
        });
        this.addDialogStateListener();
        this.updateDialogState();
        this.doUpdatePackageList();
        this.m_ok.forceFocus();
    }

    public boolean open() {
        Image[] imageArray;
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, this.getStyle());
        shell2.setText(this.getText());
        Image image = shell.getImage();
        if (image != null) {
            shell2.setImage(image);
        }
        if ((imageArray = DefaultDialog.getImages(shell)) != null) {
            shell2.setImages(imageArray);
        }
        this.createContents(shell2);
        shell2.pack();
        shell2.setSize(400, 450);
        shell2.open();
        Display display = this.getParent().getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.m_result;
    }

    private String getPackageType() {
        if (SplusEditorPlugin.g_isWindowsOS && this.m_binary.getSelection()) {
            return "win.binary";
        }
        return SOURCE;
    }

    private void importAsPackages(String[] stringArray, String[] stringArray2, String string) throws CoreException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = new File(string2).getAbsolutePath();
            String string4 = stringArray2 == null ? null : stringArray2[i];
            try {
                ICommand[] iCommandArray;
                IProject iProject;
                String string5;
                File file = new File(string3);
                string4 = DecompressUtility.decompress(file, string, string4);
                String string6 = new File(string + "/" + string4).getCanonicalPath();
                IPath iPath = Path.fromOSString((String)string6);
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                String string7 = string4;
                int n = 0;
                while (true) {
                    string5 = string4 + (n == 0 ? "" : " (" + Integer.toString(n) + ")");
                    iProject = iWorkspace.getRoot().getProject(string5);
                    iCommandArray = iProject.getLocation();
                    if (!iProject.exists() || iCommandArray.equals(iPath)) break;
                    ++n;
                }
                string7 = string5;
                string5 = iWorkspace.getRoot().getProject(string7);
                if (!string5.exists()) {
                    iProject = iWorkspace.newProjectDescription(string7);
                    if (iPath.removeLastSegments(1).equals(iWorkspace.getRoot().getLocation())) {
                        iProject.setLocation(null);
                    } else {
                        iProject.setLocation(iPath);
                    }
                    iProject.setNatureIds(new String[]{"com.insightful.splus.eclipse.splusnature"});
                    iCommandArray = new ICommand[2];
                    iCommandArray[0] = iProject.newCommand();
                    iCommandArray[0].setBuilderName("com.insightful.splus.eclipse.taskfinder");
                    iCommandArray[1] = iProject.newCommand();
                    iCommandArray[1].setBuilderName("com.insightful.splus.eclipse.parser");
                    iProject.setBuildSpec(iCommandArray);
                    string5.create((IProjectDescription)iProject, (IProgressMonitor)new NullProgressMonitor());
                }
                string5.open((IProgressMonitor)new NullProgressMonitor());
                string5.refreshLocal(2, null);
                continue;
            }
            catch (TarException tarException) {
                SplusInstallLoadUpdatePackagesDialog.handleException((Exception)((Object)tarException), "Problem Unpacking Package", this.m_ok.getShell());
                tarException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                SplusInstallLoadUpdatePackagesDialog.handleException(iOException, "Problem Unpacking Package", this.m_ok.getShell());
                iOException.printStackTrace();
            }
        }
    }

    private static String getPackageName(String string, Shell shell) {
        try {
            return DecompressUtility.getPackageName(string);
        }
        catch (IOException iOException) {
            SplusInstallLoadUpdatePackagesDialog.handleException(iOException, "Error Querying Package file.", shell);
            return null;
        }
    }

    public static String buildLocalLoadCommand(String string, boolean bl, Shell shell) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        stringBuffer.append("library(pkgutils)\n");
        stringBuffer.append("install.packages(pkgs=\"" + string + "\", repos=NULL, lib=.libPaths()[1])\n");
        if (bl) {
            String string2 = SplusInstallLoadUpdatePackagesDialog.getPackageName(string, shell);
            stringBuffer.append("library(" + string2 + ")\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private static String buildRemoteLoadCommand(boolean bl, String string, String string2, String string3, Shell shell) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        stringBuffer.append("library(pkgutils)\n");
        String string4 = ".libPaths()[1]";
        stringBuffer.append("install.packages(pkgs=" + string2 + ", repos=\"" + string + "\", type=\"" + string3 + "\", lib=" + string4 + ")\n");
        if (bl) {
            stringBuffer.append("invisible(lapply(" + string2 + ", FUN=function(x) eval(parse(text=paste(\"library(\", x, \")\")))))\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public boolean ok() throws MalformedURLException {
        OkThread okThread = new OkThread();
        this.m_packageList.getShell().getDisplay().syncExec((Runnable)okThread);
        return okThread.getSuccess();
    }

    private void updateDialogState() {
        Object object;
        boolean bl;
        boolean bl2;
        if (!this.m_doUpdate) {
            bl2 = this.m_localPackageButton.getSelection();
            this.m_localPackageLocation.setEnabled(bl2);
            this.m_localPackageBrowse.setEnabled(bl2);
            this.m_repositoryCombo.setEnabled(!bl2);
            this.m_packageList.setEnabled(!bl2);
        }
        bl2 = !SplusEditorPlugin.g_isWindowsOS;
        boolean bl3 = this.m_binary.getSelection();
        this.m_installOnly.setEnabled(bl3 || bl2);
        this.m_installAndLoad.setEnabled(bl3 || bl2);
        this.m_installAsNewProject.setEnabled(!bl3);
        this.m_installAsNewProjectLocation.setEnabled(!bl3);
        this.m_installAsNewProjectBrowse.setEnabled(!bl3);
        this.m_projectLocationLabel.setEnabled(!bl3);
        boolean bl4 = false;
        try {
            new URL(this.m_repositoryCombo.getText());
            bl4 = true;
        }
        catch (MalformedURLException malformedURLException) {
            bl4 = false;
        }
        String[] stringArray = this.m_packageList.getSelection();
        boolean bl5 = stringArray != null && stringArray.length != 0;
        boolean bl6 = bl = !this.m_doUpdate && this.m_localPackageButton.getSelection();
        if (bl) {
            String string = this.m_localPackageLocation.getText();
            bl5 = false;
            if (string.length() == 0) {
                bl = false;
            } else {
                object = new File(string);
                bl = ((File)object).exists();
            }
        }
        boolean bl7 = true;
        if (this.m_src.getSelection() && ((String)(object = this.m_installAsNewProjectLocation.getText())).length() == 0) {
            bl7 = false;
        }
        this.m_ok.setEnabled(bl4 && (bl5 || bl) && bl7);
    }

    private void getPackages(URL uRL, String string, final org.eclipse.swt.widgets.List list) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            boolean bl;
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            String string2 = this.m_doUpdate ? "old.packages" : "available.packages";
            String string3 = "repos=\"" + uRL.toString() + "\", type=\"" + string + "\"";
            if (this.m_doUpdate) {
                string3 = "contriburl=contrib.url(" + string3 + ")";
            }
            if (!(bl = this.loadPkgUtilsPackage())) {
                Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)SplusInstallLoadUpdatePackagesDialog.ERROR_WINDOW_TITLE, (String)"Error loading pkgutils library.\nFind or update packages functionality will not work correctly.");
                    }
                });
                return;
            }
            boolean bl2 = this.isPkgUtilsPackageStubbed();
            if (bl2) {
                Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)SplusInstallLoadUpdatePackagesDialog.ERROR_WINDOW_TITLE, (String)"A placeholder version of pkgutils library was detected.\nCancel out of the Find / Update packages dialog.\nRun install.pkgutils() when connected to the Internet.");
                    }
                });
                return;
            }
            final String string4 = "{\npkgs <- " + string2 + "(" + string3 + ")\n" + "if(is.matrix(pkgs)) pkgs <- pkgs[ ,1] else pkgs <- character(0)\n" + "}\n";
            final Shell shell = list.getShell();
            shell.setCursor(Display.getCurrent().getSystemCursor(1));
            shell.getDisplay().asyncExec((Runnable)new Thread("SplusInstallLoadUpdatePackagesDisplay-updatePackages"){

                public void run() {
                    try {
                        SplusDataResult splusDataResult = SplusInstallLoadUpdatePackagesDialog.splusCall(string4);
                        list.removeAll();
                        if (splusDataResult instanceof SplusStringDataResult) {
                            String[] stringArray = splusDataResult.getStringData();
                            for (int i = 0; i < stringArray.length; ++i) {
                                list.add(stringArray[i]);
                            }
                        }
                        shell.setCursor(Display.getCurrent().getSystemCursor(0));
                    }
                    catch (SplusBadDataException splusBadDataException) {
                        splusBadDataException.printStackTrace();
                    }
                }
            });
        }
    }

    private boolean loadPkgUtilsPackage() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        stringBuffer.append("if (any(search() == 'pkgutils')) return (TRUE)\n");
        stringBuffer.append("library(pkgutils)\n");
        stringBuffer.append("return (TRUE)\n");
        stringBuffer.append("}");
        SplusDataResult splusDataResult = SplusInstallLoadUpdatePackagesDialog.splusCall(stringBuffer.toString());
        if (splusDataResult.hasError()) {
            final String string = splusDataResult.getError();
            Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)SplusInstallLoadUpdatePackagesDialog.ERROR_WINDOW_TITLE, (String)string);
                }
            });
        } else {
            try {
                bl = splusDataResult.getBooleanData()[0];
            }
            catch (SplusBadDataException splusBadDataException) {
                splusBadDataException.printStackTrace();
            }
        }
        return bl;
    }

    private boolean isPkgUtilsPackageStubbed() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        stringBuffer.append("return (identical(packageDescription('pkgutils')$Package, 'pkgutilsStub'))\n");
        stringBuffer.append("}");
        SplusDataResult splusDataResult = SplusInstallLoadUpdatePackagesDialog.splusCall(stringBuffer.toString());
        if (splusDataResult.hasError()) {
            final String string = splusDataResult.getError();
            Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)SplusInstallLoadUpdatePackagesDialog.ERROR_WINDOW_TITLE, (String)string);
                }
            });
        } else {
            try {
                bl = splusDataResult.getBooleanData()[0];
            }
            catch (SplusBadDataException splusBadDataException) {
                splusBadDataException.printStackTrace();
            }
        }
        return bl;
    }

    private boolean isPkgUtilsStubbed() {
        boolean bl = true;
        String string = "identical(packageDescription('pkgutils')$Package, 'pkgutilsStub')";
        SplusDataResult splusDataResult = SplusInstallLoadUpdatePackagesDialog.splusCall(string);
        if (splusDataResult.hasError()) {
            final String string2 = splusDataResult.getError();
            Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openWarning(null, (String)SplusInstallLoadUpdatePackagesDialog.ERROR_WINDOW_TITLE, (String)string2);
                }
            });
        } else {
            try {
                if (!splusDataResult.getBooleanData()[0]) {
                    bl = false;
                } else {
                    bl = true;
                    Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
                    display.syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openWarning(null, (String)SplusInstallLoadUpdatePackagesDialog.WARNING_WINDOW_TITLE, (String)"A placeholder version of pkgutils library was detected.\nCancel out of the find / update packages dialog.\nRun install.pkgutils() when connected to the internet.");
                        }
                    });
                }
            }
            catch (SplusBadDataException splusBadDataException) {
                splusBadDataException.printStackTrace();
                bl = true;
            }
        }
        return bl;
    }

    private static SplusDataResult splusCall(String string) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        SplusDataResult splusDataResult = null;
        int n = 20;
        if (noConnection instanceof DefaultConnection) {
            DefaultConnection defaultConnection = (DefaultConnection)noConnection;
            while (true) {
                try {
                    splusDataResult = defaultConnection.doDataQuery(string);
                }
                catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
                    splusIncompleteExpressionException.printStackTrace();
                }
                catch (SplusEngineBusyException splusEngineBusyException) {
                    if (n-- <= 0) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                break;
            }
        }
        return splusDataResult;
    }

    private String chooseExternalFile(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell);
        return fileDialog.open();
    }

    private String chooseExternalDirectory(Shell shell) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        return directoryDialog.open();
    }

    public static void loadComboFromSettings(Combo combo, IDialogSettings iDialogSettings, String string) {
        if (combo == null || iDialogSettings == null) {
            return;
        }
        String[] stringArray = iDialogSettings.getArray(string);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            combo.add(stringArray[i]);
        }
        if (stringArray != null) {
            combo.select(0);
        }
    }

    public static void saveComboFromSettings(Combo combo, IDialogSettings iDialogSettings, String string) {
        if (combo == null || iDialogSettings == null) {
            return;
        }
        String[] stringArray = iDialogSettings.getArray(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        iDialogSettings.put(string, SplusInstallLoadUpdatePackagesDialog.addToHistory(stringArray, combo.getText()));
    }

    private static void addToHistory(List list, String string) {
        list.remove(string);
        list.add(0, string);
        if (list.size() > 15) {
            list.remove(15);
        }
    }

    private static String[] ensurePresentInHistory(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals(string)) continue;
            return stringArray2;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
        arrayList.add(string);
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        return stringArray3;
    }

    private static String[] addToHistory(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        SplusInstallLoadUpdatePackagesDialog.addToHistory(arrayList, string);
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private void doUpdatePackageList() {
        try {
            String string = this.m_repositoryCombo.getText();
            URL uRL = new URL(string);
            this.getPackages(uRL, this.getPackageType(), this.m_packageList);
        }
        catch (MalformedURLException malformedURLException) {
            SplusInstallLoadUpdatePackagesDialog.handleException(malformedURLException, "Bad URL Specified", this.m_repositoryCombo.getShell());
        }
    }

    private static void handleException(Exception exception, String string, Shell shell) {
        MessageBox messageBox = new MessageBox(shell);
        messageBox.setMessage(exception.getMessage());
        messageBox.setText(string);
        messageBox.open();
    }

    private boolean handleError(final String string, final String string2) {
        final Display display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
        final boolean[] blArray = new boolean[]{true};
        display.syncExec(new Runnable(){

            public void run() {
                SplusErrorWarningDialog splusErrorWarningDialog = new SplusErrorWarningDialog(display.getActiveShell(), string, string2);
                blArray[0] = splusErrorWarningDialog.open();
            }
        });
        return blArray[0];
    }

    private class OkThread
    extends Thread {
        private boolean success;

        public OkThread() {
            super("SplusInstallLoadUpdatePackagesDialog-ok");
            this.success = false;
        }

        public boolean getSuccess() {
            return this.success;
        }

        private String getPackagesAsList() {
            String[] stringArray = SplusInstallLoadUpdatePackagesDialog.this.m_packageList.getSelection();
            StringBuffer stringBuffer = new StringBuffer("c(");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\"');
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('\"');
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        private void decompressAndCreateProject() {
            String string;
            boolean bl = SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton.getSelection();
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = SplusInstallLoadUpdatePackagesDialog.this.m_installAsNewProjectLocation.getText();
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (bl) {
                string = SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation.getText();
                stringArray2 = new String[]{string};
                stringArray = null;
                this.success = true;
            } else {
                stringBuffer.append("{\n");
                stringBuffer.append("library(pkgutils)\n");
                string = SplusInstallLoadUpdatePackagesDialog.this.m_installAsNewProjectLocation.getText().replace('\\', '/');
                new File(string).mkdirs();
                stringBuffer.append("download.packages(pkgs=" + this.getPackagesAsList() + ", repos=\"" + SplusInstallLoadUpdatePackagesDialog.this.m_repositoryCombo.getText() + "\", type=\"" + SplusInstallLoadUpdatePackagesDialog.this.getPackageType() + "\", destdir=\"" + string + "\")\n");
                stringBuffer.append("}\n");
                SplusDataResult splusDataResult = this.makeCallAndHandleError(stringBuffer.toString());
                try {
                    String[] stringArray3 = splusDataResult.getStringData();
                    int n = stringArray3.length / 2;
                    stringArray = new String[n];
                    stringArray2 = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = stringArray3[i];
                        stringArray2[i] = stringArray3[i + n];
                    }
                }
                catch (SplusBadDataException splusBadDataException) {
                    SplusInstallLoadUpdatePackagesDialog.handleException((Exception)((Object)splusBadDataException), "S-PLUS Package Problem", SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton.getShell());
                    this.success = false;
                }
            }
            if (this.success) {
                try {
                    SplusInstallLoadUpdatePackagesDialog.this.importAsPackages(stringArray2, stringArray, string2);
                }
                catch (CoreException coreException) {
                    SplusInstallLoadUpdatePackagesDialog.handleException((Exception)((Object)coreException), "Project Creation Problem", SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton.getShell());
                    this.success = false;
                }
            }
        }

        private void installAndPossiblyLoadPackage() {
            String string;
            boolean bl = SplusInstallLoadUpdatePackagesDialog.this.m_installAndLoad.getSelection();
            boolean bl2 = SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton != null && SplusInstallLoadUpdatePackagesDialog.this.m_localPackageButton.getSelection();
            String string2 = null;
            if (bl2) {
                string = SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation.getText().replace('\\', '/');
                string2 = SplusInstallLoadUpdatePackagesDialog.buildLocalLoadCommand(string, bl, SplusInstallLoadUpdatePackagesDialog.this.m_localPackageLocation.getShell());
            } else {
                string = SplusInstallLoadUpdatePackagesDialog.this.m_repositoryCombo.getText();
                String string3 = this.getPackagesAsList();
                String string4 = SplusInstallLoadUpdatePackagesDialog.this.getPackageType();
                string2 = SplusInstallLoadUpdatePackagesDialog.buildRemoteLoadCommand(bl, string, string3, string4, SplusInstallLoadUpdatePackagesDialog.this.m_installAndLoad.getShell());
            }
            string = this.makeCallAndHandleError(string2);
        }

        private SplusDataResult makeCallAndHandleError(String string) {
            SplusDataResult splusDataResult = SplusInstallLoadUpdatePackagesDialog.splusCall(string);
            if (splusDataResult.hasError() || splusDataResult.hasWarning()) {
                Display display;
                StringBuffer stringBuffer = new StringBuffer();
                if (splusDataResult.hasError()) {
                    stringBuffer.append(splusDataResult.getError());
                }
                if (splusDataResult.hasWarning()) {
                    display = splusDataResult.getWarning();
                    for (int i = 0; i < ((Display)display).length; ++i) {
                        stringBuffer.append((String)display[i]);
                        stringBuffer.append('\n');
                    }
                }
                display = SplusEditorPlugin.getDefault().getWorkbench().getDisplay();
                SplusErrorWarningDialog splusErrorWarningDialog = new SplusErrorWarningDialog(display.getActiveShell(), splusDataResult.getOutput(), stringBuffer.toString());
                this.success = splusErrorWarningDialog.open();
            } else {
                this.success = true;
            }
            return splusDataResult;
        }

        public void run() {
            boolean bl;
            Shell shell = SplusInstallLoadUpdatePackagesDialog.this.m_binary.getShell();
            shell.setCursor(Display.getCurrent().getSystemCursor(1));
            boolean bl2 = SplusInstallLoadUpdatePackagesDialog.this.m_installOnly.getSelection();
            boolean bl3 = SplusInstallLoadUpdatePackagesDialog.this.m_installAndLoad.getSelection();
            boolean bl4 = bl = !SplusInstallLoadUpdatePackagesDialog.this.m_binary.getSelection();
            if (!(!bl2 && !bl3 || bl && SplusEditorPlugin.g_isWindowsOS)) {
                this.installAndPossiblyLoadPackage();
            } else {
                this.decompressAndCreateProject();
            }
            SplusEditorPlugin.getDefault().getConsoleDocument().pollForOutput();
            shell.setCursor(Display.getCurrent().getSystemCursor(0));
        }
    }

    private static class DecompressUtility {
        private DecompressUtility() {
        }

        private static void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
        }

        private static String unzip(ZipFile zipFile, String string, String string2) throws IOException {
            String string3 = string2;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file;
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                String string5 = string + "/" + string4;
                if (zipEntry.isDirectory()) {
                    if (string3 == null && string4.indexOf(47) == string4.length() - 1) {
                        string3 = string4.substring(0, string4.length() - 1);
                    }
                    file = new File(string5);
                    file.mkdir();
                    continue;
                }
                file = new File(string5);
                if (file.exists()) {
                    file.delete();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                DecompressUtility.copyInputStream(zipFile.getInputStream(zipEntry), bufferedOutputStream);
            }
            zipFile.close();
            return string3;
        }

        private static String untar(TarFile tarFile, String string, String string2) throws TarException, IOException {
            String string3 = string2;
            Enumeration enumeration = tarFile.entries();
            while (enumeration.hasMoreElements()) {
                File file;
                TarEntry tarEntry = (TarEntry)enumeration.nextElement();
                String string4 = tarEntry.getName();
                String string5 = string + "/" + string4;
                if (tarEntry.getFileType() == 53) {
                    if (string3 == null && string4.indexOf(47) == string4.length() - 1) {
                        string3 = string4.substring(0, string4.length() - 1);
                    }
                    file = new File(string5);
                    file.mkdir();
                    continue;
                }
                file = new File(string5);
                if (file.exists()) {
                    file.delete();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                DecompressUtility.copyInputStream(tarFile.getInputStream(tarEntry), bufferedOutputStream);
            }
            tarFile.close();
            return string3;
        }

        private static String getPackageNameFromZip(String string) throws IOException {
            try {
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string2 = zipEntry.getName();
                    if (!string2.endsWith("DESCRIPTION")) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    byte[] byArray = new byte[1024];
                    while (zipInputStream.read(byArray) > 0) {
                        stringBuffer.append(new String(byArray));
                    }
                    String string3 = stringBuffer.toString();
                    if (!string3.startsWith("Package: ")) continue;
                    int n = string3.indexOf(10);
                    int n2 = string3.indexOf(13);
                    return string3.substring("Package: ".length(), Math.min(n2, n));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getPackageNameFromTarball(String string) throws IOException {
            String string2 = null;
            File file = File.createTempFile("tmp.tar", "dir");
            file.delete();
            String string3 = file.getCanonicalPath();
            File file2 = new File(string3);
            file2.mkdirs();
            IOException iOException = null;
            try {
                DecompressUtility.untar(new File(string), string3, null);
                String[] stringArray = file2.list();
                if (stringArray != null && stringArray.length != 0) {
                    string2 = stringArray[0];
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                if (file2.exists()) {
                    SplusInstallLoadUpdatePackagesDialog.splusCall("unix(\"rm -rf " + string3 + "\")");
                }
            }
            if (iOException != null) {
                throw iOException;
            }
            return string2;
        }

        private static String untar(File file, String string, String string2) throws IOException {
            String string3 = string2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("unix(\"");
            stringBuffer.append("tar xfz ");
            stringBuffer.append(file.getCanonicalPath());
            stringBuffer.append(" -C ");
            stringBuffer.append(string);
            stringBuffer.append("\")");
            SplusInstallLoadUpdatePackagesDialog.splusCall(stringBuffer.toString());
            return string3;
        }

        public static String getPackageName(String string) throws IOException {
            if (SplusEditorPlugin.g_isWindowsOS) {
                return DecompressUtility.getPackageNameFromZip(string);
            }
            return DecompressUtility.getPackageNameFromTarball(string);
        }

        public static String decompress(File file, String string, String string2) throws IOException, TarException {
            String string3 = string2;
            String string4 = file.getName().toLowerCase();
            if (string4.endsWith("zip")) {
                string3 = DecompressUtility.unzip(new ZipFile(file), string, string3);
            } else if (string4.endsWith("tar.gz")) {
                string3 = DecompressUtility.untar(new TarFile(file), string, string3);
            }
            return string3;
        }
    }
}

