/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.eclipse.views.util.IHistoryListener;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class HistoryView
extends ViewPart
implements IHistoryListener {
    public static final String ID = "com.insightful.splus.eclipse.views.HistoryView";
    private ListViewer m_viewer;
    private Action m_selectAction;
    private Action m_clearConsoleAction;
    private boolean ignoreNextSelectionEvent = false;

    public void createPartControl(Composite composite) {
        SplusEditorPlugin.getDefault().getConnection();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 772);
        list.setFont(SplusEditorPlugin.getDefaultFont(composite.getDisplay()));
        list.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)mouseEvent.getSource();
                list.setToolTipText("");
            }

            public void mouseHover(MouseEvent mouseEvent) {
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)mouseEvent.getSource();
                int n = list.getItemHeight();
                int n2 = (int)Math.floor(mouseEvent.y / n) + list.getTopIndex();
                if (n2 >= 0 && n2 < list.getItemCount()) {
                    ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
                    list.setToolTipText(consoleHistoryDocument.getHistoryLine(n2));
                } else {
                    list.setToolTipText("");
                }
            }

            public void mouseExit(MouseEvent mouseEvent) {
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)mouseEvent.getSource();
                list.setToolTipText("");
            }
        });
        this.m_viewer = new ListViewer(list);
        this.m_viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookMouseAction();
        this.hookEnterKeyAction();
        this.hookSelection();
        this.contributeToActionBars();
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        consoleHistoryDocument.addHistoryListener(this);
    }

    public void dispose() {
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        consoleHistoryDocument.removeHistoryListener(this);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                HistoryView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.m_selectAction);
        iMenuManager.add((IAction)this.m_clearConsoleAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.m_selectAction);
        iMenuManager.add((IAction)this.m_clearConsoleAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.m_clearConsoleAction = new Action(){

            public void run() {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SplusEditorPlugin.getDefault().getConsoleDocument().clearHistory();
                        HistoryView.this.m_viewer.getList().removeAll();
                    }
                };
                Display display = HistoryView.this.getSite().getShell().getDisplay();
                display.asyncExec(runnable);
            }
        };
        this.m_clearConsoleAction.setText("Clear");
        this.m_clearConsoleAction.setToolTipText("Clear console text");
        this.m_selectAction = new Action(){

            public void run() {
                HistoryView.this.doSelectItem(false);
            }
        };
        this.m_selectAction.setText("Select input");
        this.m_selectAction.setToolTipText("Select console input line");
    }

    private void doSelectItem(boolean bl) {
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        String string = this.getSelectedCommand();
        while (string.endsWith(ConsoleHistoryDocument.g_lineDelimiter)) {
            string = string.substring(0, string.length() - ConsoleHistoryDocument.g_numLDChars);
        }
        consoleHistoryDocument.clearInput();
        if (bl) {
            consoleHistoryDocument.appendInputLine(string + ConsoleHistoryDocument.g_lineDelimiter);
        } else {
            consoleHistoryDocument.appendInputLine(string);
        }
    }

    private void hookMouseAction() {
        this.m_viewer.getList().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                HistoryView.this.doSelectItem(false);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                HistoryView.this.ignoreNextSelectionEvent = true;
                HistoryView.this.doSelectItem(true);
            }
        });
    }

    private void hookEnterKeyAction() {
        this.m_viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 10) {
                    HistoryView.this.doSelectItem(true);
                }
            }
        });
    }

    private void hookSelection() {
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (HistoryView.this.ignoreNextSelectionEvent) {
                    HistoryView.this.ignoreNextSelectionEvent = false;
                } else {
                    HistoryView.this.doSelectItem(false);
                }
            }
        });
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    public void historySelectedBlockChanged(ConsoleHistoryDocument consoleHistoryDocument) {
        int n = consoleHistoryDocument.getSelectedInputBlock();
        if (n >= 0) {
            this.m_viewer.getList().select(n);
        } else {
            this.m_viewer.getList().deselectAll();
        }
    }

    public void historySelectedBlockChanged(ConsoleHistoryDocument consoleHistoryDocument, boolean bl) {
        int n = consoleHistoryDocument.getNextSelectedInputBlock(bl);
        if (n == -1) {
            this.m_viewer.getList().deselectAll();
        } else {
            this.m_viewer.getList().select(n);
        }
    }

    public void historyRemoved(ConsoleHistoryDocument consoleHistoryDocument) {
        this.m_viewer.setContentProvider((IContentProvider)new ViewContentProvider());
    }

    public void historyAdded(ConsoleHistoryDocument consoleHistoryDocument, int n) {
    }

    public void historyInput(ConsoleHistoryDocument consoleHistoryDocument, int n, int n2) {
        String string = consoleHistoryDocument.getBlockCommands(n, n2, true);
        if (string.length() != 0) {
            this.m_viewer.add((Object)string);
        }
    }

    public String getSelectedCommand() {
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        int n = this.m_viewer.getList().getSelectionIndex();
        if (n < 0 || n >= consoleHistoryDocument.getHistoryLines().size()) {
            return "";
        }
        String string = consoleHistoryDocument.getHistoryLine(n);
        while (string.length() > 0 && string.endsWith(ConsoleHistoryDocument.g_lineDelimiter)) {
            string = string.substring(0, string.length() - ConsoleHistoryDocument.g_numLDChars);
        }
        return string;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
            List list = consoleHistoryDocument.getDisplayedHistoryLines();
            int n = list.size();
            Object[] objectArray = new Object[n];
            list.toArray(objectArray);
            return objectArray;
        }
    }
}

