/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusCompletionProcessor;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusAnnotationHover;
import com.insightful.splus.eclipse.preferences.SplusConsolePreferencePage;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.eclipse.views.util.IHistoryListener;
import com.insightful.splus.eclipse.views.util.PromptRulerColumn;
import com.insightful.splus.eclipse.views.util.ViewerWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class AdaptedViewerWrapper
extends ViewerWrapper
implements LineStyleListener,
LineBackgroundListener,
VerifyListener,
MouseListener,
KeyListener,
IDocumentListener,
IHistoryListener {
    public static final Color DEFAULT_INPUT_COLOR = new Color(null, 0, 0, 127);
    protected Color INPUT_COLOR = this.getInputColor();
    private SplusConsoleSourceViewerConfiguration m_splusConsoleSourceViewerConfig = null;
    private boolean m_rejectedText = false;

    public AdaptedViewerWrapper(Composite composite, int n, ConsoleHistoryDocument consoleHistoryDocument, IWorkbenchPart iWorkbenchPart) {
        super(composite, n, consoleHistoryDocument, iWorkbenchPart);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.m_viewer;
        this.m_splusConsoleSourceViewerConfig = new SplusConsoleSourceViewerConfiguration();
        projectionViewer.configure((SourceViewerConfiguration)this.m_splusConsoleSourceViewerConfig);
    }

    protected void createViewer(Composite composite, AbstractDocument abstractDocument, int n) {
        ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)abstractDocument;
        int n2 = 12;
        CompositeRuler compositeRuler = new CompositeRuler(n2);
        compositeRuler.setModel((IAnnotationModel)consoleHistoryDocument);
        PromptRulerColumn promptRulerColumn = new PromptRulerColumn(consoleHistoryDocument, n2, (IAnnotationAccess)new DefaultMarkerAnnotationAccess());
        promptRulerColumn.addAnnotationType("org.eclipse.text.annotation.unknown");
        compositeRuler.addDecorator(0, (IVerticalRulerColumn)promptRulerColumn);
        this.m_viewer = new ProjectionViewer(composite, (IVerticalRuler)compositeRuler, null, true, n){

            protected StyledText createTextWidget(Composite composite, int n) {
                return new StyledText(composite, n){

                    public void copy() {
                        AdaptedViewerWrapper.this.doCopy();
                    }

                    public void cut() {
                        AdaptedViewerWrapper.this.doCut();
                    }

                    public void paste() {
                        AdaptedViewerWrapper.this.doPaste();
                    }
                };
            }
        };
        promptRulerColumn.getControl().setBackground(this.m_viewer.getTextWidget().getBackground());
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)this.m_document;
        StyleRange styleRange = new StyleRange();
        try {
            int n = this.m_document.getLineOfOffset(lineStyleEvent.lineOffset);
            styleRange.start = this.m_document.getLineOffset(n);
            styleRange.length = this.m_document.getLineLength(n);
            FontData fontData = this.CONSOLE_FONT == null ? null : this.CONSOLE_FONT.getFontData()[0];
            Font font = this.CONSOLE_FONT;
            styleRange.foreground = n >= 0 && n < consoleHistoryDocument.currentInputBase() ? (consoleHistoryDocument.lineType(n) == 3 ? this.OUTPUT_COLOR : this.INPUT_COLOR) : this.INPUT_COLOR;
            if (font != null && fontData != null) {
                this.setLineInfo(font, fontData, styleRange);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        lineStyleEvent.styles = new StyleRange[]{styleRange};
    }

    public void verifyText(VerifyEvent verifyEvent) {
        if (verifyEvent.widget instanceof StyledText) {
            try {
                ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)this.m_document;
                int n = verifyEvent.start;
                int n2 = this.m_document.getLineOfOffset(n);
                int n3 = consoleHistoryDocument.currentInputBase();
                if (n3 >= 0 && n2 >= 0 && n2 < n3) {
                    verifyEvent.doit = false;
                    this.m_rejectedText = verifyEvent.text.length() > 0 && !verifyEvent.text.equals(ConsoleHistoryDocument.g_lineDelimiter);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
        if (keyEvent.keyCode == 262144) {
            ((ConsoleHistoryDocument)this.m_document).setCtrlDown(false);
        }
    }

    protected void doPaste() {
        String string = this.getClipboard().getContents((Transfer)TextTransfer.getInstance()).toString();
        ConsoleHistoryDocument.copyToConsole(string);
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if ((keyEvent.stateMask & 0x40000) == 262144 || keyEvent.keyCode == 262144) {
            ((ConsoleHistoryDocument)this.m_document).setCtrlDown(true);
            return;
        }
        if (!this.m_splusConsoleSourceViewerConfig.getSplusContentAssistant().isPopupActive()) {
            Object object;
            if (keyEvent.keyCode == 8) {
                SplusConsoleContentAssistant splusConsoleContentAssistant = this.m_splusConsoleSourceViewerConfig.getSplusContentAssistant();
                SplusCompletionProcessor splusCompletionProcessor = this.m_splusConsoleSourceViewerConfig.getSplusCompletionProcessor();
                String string = splusCompletionProcessor.getWordSoFar((ITextViewer)this.m_viewer, this.m_viewer.getTextWidget().getCaretOffset(), 1);
                if (string != null && string.length() != 0) {
                    splusConsoleContentAssistant.showPossibleCompletions();
                }
                return;
            }
            if (keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000002) {
                object = (ConsoleHistoryDocument)this.m_document;
                keyEvent.doit = false;
                int n = ((ConsoleHistoryDocument)((Object)object)).getSelectedInputBlock();
                if (keyEvent.keyCode == 0x1000001) {
                    if (n < 0) {
                        n = ((ConsoleHistoryDocument)((Object)object)).inputBlockCount() - 1;
                    } else if (n > 0) {
                        --n;
                    }
                } else {
                    n = n >= 0 && n < ((ConsoleHistoryDocument)((Object)object)).inputBlockCount() - 1 ? ++n : -1;
                }
                ((ConsoleHistoryDocument)((Object)object)).notifyHistoryUpDownChange(keyEvent.keyCode == 0x1000001);
                this.showEnd();
            }
            if ((object = String.valueOf(keyEvent.character)) != null && this.m_rejectedText) {
                try {
                    ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)this.m_document;
                    consoleHistoryDocument.replace(consoleHistoryDocument.getLength(), 0, (String)object);
                    this.showEnd();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            this.m_rejectedText = false;
        }
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        super.verifyKey(verifyEvent);
    }

    protected void doEscape() {
        if (this.m_document instanceof ConsoleHistoryDocument) {
            ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)this.m_document;
            NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
            if (noConnection instanceof DefaultConnection) {
                DefaultConnection defaultConnection = (DefaultConnection)noConnection;
                if (!defaultConnection.isEngineBusy()) {
                    if (!this.m_splusConsoleSourceViewerConfig.getSplusContentAssistant().isPopupActive()) {
                        consoleHistoryDocument.clearInput();
                    }
                } else {
                    super.doEscape();
                }
            }
        }
    }

    protected String getLinePrompt(int n) {
        ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)this.m_document;
        int n2 = consoleHistoryDocument.lineType(n);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                return ConsoleHistoryDocument.PREFIX[n2];
            }
        }
        return "";
    }

    public void documentChanged(DocumentEvent documentEvent) {
    }

    protected String[] getPreferencePageIds() {
        String[] stringArray = new String[]{"com.insightful.splus.eclipse.editors.spluseditor.preferences.SplusConsolePreferencePage"};
        return stringArray;
    }

    protected String getInputColorPreferenceName() {
        return SplusConsolePreferencePage.getConsolePreferencePage().inputPropertyName();
    }

    protected String getOutputColorPreferenceName() {
        return SplusConsolePreferencePage.getConsolePreferencePage().outputPropertyName();
    }

    protected String getFontPreferenceName() {
        return SplusConsolePreferencePage.getConsolePreferencePage().fontPropertyName();
    }

    protected String getBackgroundPreferenceName() {
        return SplusConsolePreferencePage.getConsolePreferencePage().backgroundPropertyName();
    }

    protected String getBackgroundColorPreferenceName() {
        return SplusConsolePreferencePage.getConsolePreferencePage().backgroundColorPropertyName();
    }

    protected Color getBackgroundColor() {
        return SplusConsolePreferencePage.getConsoleViewBackground();
    }

    protected FontData getPreferenceFont() {
        return SplusConsolePreferencePage.getConsoleViewConsoleFont();
    }

    protected Color getInputColor() {
        return SplusConsolePreferencePage.getConsoleViewInputColor();
    }

    protected Color getOutputColor() {
        return SplusConsolePreferencePage.getConsoleViewOutputColor();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(this.getInputColorPreferenceName())) {
            Object object = propertyChangeEvent.getNewValue();
            RGB rGB = object instanceof RGB ? (RGB)object : StringConverter.asRGB((String)((String)object));
            this.INPUT_COLOR = SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(rGB);
            this.m_viewer.invalidateTextPresentation();
            this.m_viewer.refresh();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    private class SplusConsoleContentAssistant
    extends ContentAssistant
    implements ICompletionListener {
        private boolean _assistActive = false;

        public SplusConsoleContentAssistant() {
            this.addCompletionListener(this);
        }

        public void assistSessionEnded(ContentAssistEvent contentAssistEvent) {
            this._assistActive = false;
        }

        public void assistSessionStarted(ContentAssistEvent contentAssistEvent) {
            this._assistActive = true;
        }

        public void selectionChanged(ICompletionProposal iCompletionProposal, boolean bl) {
        }

        public boolean isPopupActive() {
            try {
                Method method = ContentAssistant.class.getDeclaredMethod("isContextInfoPopupActive", new Class[0]);
                Method method2 = ContentAssistant.class.getDeclaredMethod("isProposalPopupActive", new Class[0]);
                Boolean bl = (Boolean)method.invoke((Object)this, new Object[0]);
                Boolean bl2 = (Boolean)method2.invoke((Object)this, new Object[0]);
                return bl != false || bl2 != false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            return this._assistActive;
        }
    }

    private class SplusConsoleSourceViewerConfiguration
    extends SourceViewerConfiguration {
        private SplusConsoleContentAssistant _splusContentAssistant = null;
        private SplusCompletionProcessor _splusCompletionProcessor = null;

        private SplusConsoleSourceViewerConfiguration() {
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
            return new SplusAnnotationHover();
        }

        public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
            this._splusContentAssistant = new SplusConsoleContentAssistant();
            this._splusCompletionProcessor = new SplusCompletionProcessor(this._splusContentAssistant);
            this._splusContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            this._splusContentAssistant.setContentAssistProcessor(this._splusCompletionProcessor, "__dftl_partition_content_type");
            SplusCompletionProcessor.configure(this._splusContentAssistant, EditorsPlugin.getDefault().getPreferenceStore());
            this._splusContentAssistant.enableAutoActivation(true);
            this._splusContentAssistant.setAutoActivationDelay(500);
            this._splusContentAssistant.setProposalPopupOrientation(10);
            this._splusContentAssistant.setContextInformationPopupOrientation(20);
            this._splusContentAssistant.setContextInformationPopupBackground(SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(new RGB(150, 150, 0)));
            this._splusContentAssistant.enableAutoInsert(false);
            this._splusContentAssistant.enablePrefixCompletion(false);
            return this._splusContentAssistant;
        }

        public SplusCompletionProcessor getSplusCompletionProcessor() {
            return this._splusCompletionProcessor;
        }

        public SplusConsoleContentAssistant getSplusContentAssistant() {
            return this._splusContentAssistant;
        }
    }
}

