/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.views.OutputView;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public class SplusCommandHandler {
    private ConsoleHistoryDocument m_doc = null;
    private DisplayText m_displayText = null;
    private Vector m_storedSplusOutput = new Vector();

    public SplusCommandHandler(ConsoleHistoryDocument consoleHistoryDocument) {
        this.m_doc = consoleHistoryDocument;
    }

    public void endEvaluation(DefaultConnection defaultConnection) {
        this.m_doc.addPrompt(0);
        SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
        splusEditorPlugin.setSplusBusy(false);
        this.m_doc.refreshPrompts();
        this.m_doc.setSendToOutput(false);
        splusEditorPlugin.getWorkbench().getDisplay().asyncExec((Runnable)new ChangeCursor(false));
        if (defaultConnection.hasEvalEnded() && defaultConnection.doQuit()) {
            final IWorkbench iWorkbench = splusEditorPlugin.getWorkbench();
            iWorkbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    iWorkbench.close();
                }
            });
        }
        if (defaultConnection.hasEvalEnded()) {
            defaultConnection.eventOccurred(null);
        }
    }

    public void startEvaluation() {
        SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
        splusEditorPlugin.setSplusBusy(true);
        splusEditorPlugin.getWorkbench().getDisplay().syncExec((Runnable)new ChangeCursor(true));
    }

    public void pollForOutput(String string, DefaultConnection defaultConnection) {
        String string2 = string + "\n";
        defaultConnection.eventOccurred(null);
        this.startEvaluation();
        this.m_displayText = new DisplayText(defaultConnection);
        new SplusRunThread(string2, defaultConnection).start();
        new OutputPollThread(defaultConnection, string.trim().length() == 0).start();
    }

    public void pollForOutput(DefaultConnection defaultConnection) {
        defaultConnection.eventOccurred(null);
        this.startEvaluation();
        this.m_displayText = new DisplayText(defaultConnection);
        new OutputPollThread(defaultConnection, true).start();
    }

    public void getAndDisplayOutput() {
        String[] stringArray;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection && ((DefaultConnection)noConnection).hasCanvas()) {
            ((DefaultConnection)noConnection).showCanvas();
        }
        if ((stringArray = this.getStoredSplusOutput()).length == 0) {
            return;
        }
        this.displayOutput(stringArray);
    }

    private void displayOutput(String[] stringArray) {
        if (this.m_doc.sendToOutput()) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                }
                AbstractDocument abstractDocument = SplusEditorPlugin.getDefault().getOutputDocument();
                abstractDocument.replace(abstractDocument.getLength(), 0, stringBuffer.toString());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            this.m_doc.addOutputLines(stringArray);
        }
    }

    public static void doWait(int n, DefaultConnection defaultConnection) {
        try {
            Thread.sleep(n);
            Thread.yield();
            if (defaultConnection != null && defaultConnection.escapeRequested()) {
                defaultConnection.sendEscape();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getStoredSplusOutput() {
        Vector vector = this.m_storedSplusOutput;
        synchronized (vector) {
            String[] stringArray = new String[this.m_storedSplusOutput.size()];
            this.m_storedSplusOutput.toArray(stringArray);
            this.m_storedSplusOutput.clear();
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoredSplusOutput(String string) {
        Vector vector = this.m_storedSplusOutput;
        synchronized (vector) {
            int n = string.length();
            int n2 = ConsoleHistoryDocument.g_lineDelimiter.length();
            int n3 = 32760;
            for (int i = 0; i < n; i += n3 - n2) {
                int n4 = i + n3 - n2;
                boolean bl = n <= n4;
                String string2 = string.substring(i, bl ? n : n4);
                if (!bl) {
                    this.m_storedSplusOutput.add(string2 + ConsoleHistoryDocument.g_lineDelimiter);
                    continue;
                }
                this.m_storedSplusOutput.add(string2);
            }
        }
    }

    public static class ChangeCursor
    implements Runnable {
        private boolean normalize = true;

        public ChangeCursor(boolean bl) {
            this.normalize = !bl;
        }

        public void run() {
            SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
            OutputView outputView = splusEditorPlugin.getOutput();
            try {
                StyledText styledText;
                TextViewer textViewer = splusEditorPlugin.getConsole().getTextViewer();
                if (textViewer != null) {
                    styledText = textViewer.getTextWidget();
                    styledText.setCursor(Display.getCurrent().getSystemCursor(this.normalize ? 0 : 1));
                }
                if (outputView != null) {
                    styledText = outputView.getViewer().getViewer().getTextWidget();
                    styledText.setCursor(Display.getCurrent().getSystemCursor(this.normalize ? 0 : 1));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            splusEditorPlugin.setSplusBusy(!this.normalize);
        }
    }

    public class OutputPollThread
    extends Thread
    implements IRunnableWithProgress {
        private DefaultConnection conn;
        private boolean emptyInput;

        public OutputPollThread(DefaultConnection defaultConnection, boolean bl) {
            super("Output Poll Thread");
            this.conn = defaultConnection;
            this.emptyInput = bl;
        }

        public void run() {
            this.polling();
        }

        public void run(IProgressMonitor iProgressMonitor) {
            this.polling();
        }

        public void polling() {
            boolean bl = true;
            boolean bl2 = false;
            while (bl) {
                boolean bl3 = bl = !this.conn.hasEvalBegan() && !this.conn.hasEvalEnded() && !this.conn.wantsInput() && !this.conn.noEval();
                if (bl && !this.emptyInput) {
                    SplusCommandHandler.doWait(50, this.conn);
                    continue;
                }
                while (!bl2) {
                    bl2 = this.conn.hasEvalEnded() || this.conn.noEval();
                    SplusCommandHandler.this.m_displayText.update(false);
                    if (bl2) {
                        bl = false;
                        continue;
                    }
                    if (this.conn.wantsInput()) {
                        bl = false;
                        bl2 = true;
                        continue;
                    }
                    if (this.emptyInput) {
                        bl = false;
                        bl2 = true;
                        SplusCommandHandler.doWait(50, this.conn);
                        continue;
                    }
                    SplusCommandHandler.doWait(50, this.conn);
                }
            }
            SplusCommandHandler.this.m_displayText.update(true);
        }
    }

    public class DisplayText
    implements Runnable {
        private Boolean m_isRunningObject = new Boolean(false);
        private DefaultConnection m_connection = null;
        private boolean m_scheduled = false;
        private boolean m_last = false;

        public DisplayText(DefaultConnection defaultConnection) {
            this.m_connection = defaultConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(boolean bl) {
            Boolean bl2 = this.m_isRunningObject;
            synchronized (bl2) {
                if (bl) {
                    this.m_last = true;
                }
                if (!this.m_scheduled) {
                    this.m_scheduled = true;
                    SplusEditorPlugin.getDefault().getWorkbench().getDisplay().asyncExec((Runnable)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Boolean bl = this.m_isRunningObject;
            synchronized (bl) {
                if (this.m_connection.hasCanvas()) {
                    this.m_connection.showCanvas();
                }
                if (this.m_last) {
                    SplusCommandHandler.doWait(100, this.m_connection);
                    this.m_connection.flushOutputHandler();
                }
                SplusCommandHandler.this.getAndDisplayOutput();
                if (this.m_last) {
                    SplusCommandHandler.this.endEvaluation(this.m_connection);
                    this.m_last = false;
                }
                this.m_scheduled = false;
            }
        }
    }

    public class SplusRunThread
    extends Thread {
        private DefaultConnection m_conn;
        private String m_cmd;

        public SplusRunThread(String string, DefaultConnection defaultConnection) {
            super("SplusRunThread");
            this.m_conn = defaultConnection;
            this.m_cmd = string;
        }

        public void run() {
            this.m_conn.writeEngineInput(this.m_cmd);
        }
    }
}

