/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.bridge;

import com.insightful.splusserver.api.bridge.CommonServerBridge;
import com.insightful.splusserver.api.bridge.IFunctionServiceBridge;
import com.insightful.splusserver.exception.JobDoesNotExistException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.UrlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionServiceBridgeUrl
extends CommonServerBridge
implements IFunctionServiceBridge {
    public FunctionServiceBridgeUrl(String serviceUrl) throws BridgeException, ServerNotRespondingException {
        this.setServiceUrl(serviceUrl);
        this.ping();
    }

    public FunctionServiceBridgeUrl(String userName, String password, String serviceUrl) throws BridgeException, NotAuthenticatedException, ServerNotRespondingException {
        this.setServiceUrl(serviceUrl);
        if (this.ping().booleanValue()) {
            this.setUserName(userName);
            this.setPassword(password);
            if (!this.validateUserCredentials().booleanValue()) {
                throw new NotAuthenticatedException("Invalid credentials");
            }
        }
    }

    @Override
    public String eval(String functionName, String packageName, Map<String, String[]> args, String dataSet, Boolean async) throws BridgeException, ApiException, NotAuthenticatedException {
        if (StringUtils.isEmpty((String)functionName)) {
            throw new ApiException("Unspecified Function Name");
        }
        try {
            String url;
            String xml;
            StringBuffer argSet = new StringBuffer();
            if (args != null) {
                for (String a : args.keySet()) {
                    String[] values;
                    for (String v : values = args.get(a)) {
                        if (argSet.length() > 0) {
                            argSet.append("&");
                        }
                        argSet.append(a + "=" + UrlUtil.escapeUrl((String)v));
                    }
                }
            }
            if ("<authentication status=\"false\" />".equals(xml = this.readUrlResult(url = this.getServiceUrl() + "/api/function/" + (!StringUtils.isEmpty((String)packageName) ? packageName + "/" : "") + functionName + "?" + argSet.toString() + "&async=" + (async != null ? async : Boolean.FALSE)))) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    @Override
    public String eval(String functionName, String packageName, Map<String, String[]> args, String dataSet, long startTime) throws BridgeException, ApiException, NotAuthenticatedException {
        if (StringUtils.isEmpty((String)functionName)) {
            throw new ApiException("Unspecified Function Name");
        }
        try {
            String url;
            String xml;
            StringBuffer argSet = new StringBuffer();
            if (args != null) {
                for (String a : args.keySet()) {
                    String[] values;
                    for (String v : values = args.get(a)) {
                        if (argSet.length() > 0) {
                            argSet.append("&");
                        }
                        argSet.append(a + "=" + UrlUtil.escapeUrl((String)v));
                    }
                }
            }
            if ("<authentication status=\"false\" />".equals(xml = this.readUrlResult(url = this.getServiceUrl() + "/api/function/" + (!StringUtils.isEmpty((String)packageName) ? packageName + "/" : "") + functionName + "?" + argSet.toString() + "&at=" + startTime))) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    @Override
    public String getJob(String jobId) throws BridgeException, JobDoesNotExistException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/function/" + "getJob" + "?" + "jobId" + "=" + jobId;
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            if (xml == null || xml.indexOf("HTTP Status 500") >= 0) {
                throw new JobDoesNotExistException("Job does not exists for: " + jobId);
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new JobDoesNotExistException((Throwable)e);
        }
    }

    protected Log getLogger() {
        return LogFactory.getLog(FunctionServiceBridgeUrl.class);
    }
}

