/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class LeaderLayoutManager
extends LeafNodeLayoutManager {
    private Leader fobj;
    Font font = null;
    private LinkedList contentList = null;
    private ContentLayoutManager clm = null;

    public LeaderLayoutManager(Leader node) {
        super(node);
        this.fobj = node;
        this.font = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo());
        this.setAlignment(this.fobj.getVerticalAlign());
    }

    public InlineArea get(LayoutContext context) {
        return this.getLeaderInlineArea();
    }

    protected MinOptMax getAllocationIPD(int refIPD) {
        return this.getLeaderAllocIPD(refIPD);
    }

    private MinOptMax getLeaderAllocIPD(int ipd) {
        this.fobj.setLayoutDimension(PercentBase.BLOCK_IPD, ipd);
        int opt = this.fobj.getLeaderLength().getOptimum().getLength().getValue();
        int min = this.fobj.getLeaderLength().getMinimum().getLength().getValue();
        int max = this.fobj.getLeaderLength().getMaximum().getLength().getValue();
        return new MinOptMax(min, opt, max);
    }

    private InlineArea getLeaderInlineArea() {
        InlineArea leaderArea = null;
        if (this.fobj.getLeaderPattern() == 123) {
            org.apache.fop.area.inline.Leader leader = new org.apache.fop.area.inline.Leader();
            leader.setRuleStyle(this.fobj.getRuleStyle());
            leader.setRuleThickness(this.fobj.getRuleThickness().getValue());
            leaderArea = leader;
        } else if (this.fobj.getLeaderPattern() == 134) {
            leaderArea = new Space();
        } else if (this.fobj.getLeaderPattern() == 35) {
            TextArea t = new TextArea();
            char dot = '.';
            t.setTextArea("" + dot);
            t.setIPD(this.font.getCharWidth(dot));
            t.addTrait(Trait.FONT_NAME, this.font.getFontName());
            t.addTrait(Trait.FONT_SIZE, new Integer(this.font.getFontSize()));
            int width = this.font.getCharWidth(dot);
            Space spacer = null;
            if (this.fobj.getLeaderPatternWidth().getValue() > width) {
                spacer = new Space();
                spacer.setIPD(this.fobj.getLeaderPatternWidth().getValue() - width);
                width = this.fobj.getLeaderPatternWidth().getValue();
            }
            FilledArea fa = new FilledArea();
            fa.setUnitWidth(width);
            fa.addChildArea(t);
            if (spacer != null) {
                fa.addChildArea(spacer);
            }
            fa.setBPD(this.font.getAscender());
            leaderArea = fa;
        } else if (this.fobj.getLeaderPattern() == 158) {
            if (this.fobj.getChildNodes() == null) {
                this.fobj.getLogger().error("Leader use-content with no content");
                return null;
            }
            this.fobjIter = null;
            FilledArea fa = new FilledArea();
            this.clm = new ContentLayoutManager(fa, this);
            this.clm.setUserAgent(this.fobj.getUserAgent());
            this.addChildLM(this.clm);
            InlineLayoutManager lm = new InlineLayoutManager(this.fobj);
            this.clm.addChildLM(lm);
            this.contentList = this.clm.getNextKnuthElements(new LayoutContext(0), 0);
            int width = this.clm.getStackingSize();
            Space spacer = null;
            if (this.fobj.getLeaderPatternWidth().getValue() > width) {
                spacer = new Space();
                spacer.setIPD(this.fobj.getLeaderPatternWidth().getValue() - width);
                width = this.fobj.getLeaderPatternWidth().getValue();
            }
            fa.setUnitWidth(width);
            if (spacer != null) {
                fa.addChildArea(spacer);
            }
            leaderArea = fa;
        }
        TraitSetter.setProducerID(leaderArea, this.fobj.getId());
        return leaderArea;
    }

    protected void offsetArea(InlineArea area, LayoutContext context) {
        int pattern = this.fobj.getLeaderPattern();
        int bpd = area.getBPD();
        block0 : switch (pattern) {
            case 123: {
                switch (this.verticalAlignment) {
                    case 145: {
                        area.setOffset(0);
                        break block0;
                    }
                    case 84: {
                        area.setOffset(context.getMiddleBaseline() - bpd / 2);
                        break block0;
                    }
                    case 20: {
                        area.setOffset(context.getLineHeight() - bpd);
                        break block0;
                    }
                }
                area.setOffset(context.getBaseline() - bpd);
                break;
            }
            case 35: {
                switch (this.verticalAlignment) {
                    case 145: {
                        area.setOffset(0);
                        break block0;
                    }
                    case 84: {
                        area.setOffset(context.getMiddleBaseline());
                        break block0;
                    }
                    case 20: {
                        area.setOffset(context.getLineHeight() - bpd + this.font.getAscender());
                        break block0;
                    }
                }
                area.setOffset(context.getBaseline());
                break;
            }
            case 134: {
                break;
            }
            case 158: {
                switch (this.verticalAlignment) {
                    case 145: {
                        area.setOffset(0);
                        break block0;
                    }
                    case 84: {
                        area.setOffset(context.getMiddleBaseline());
                        break block0;
                    }
                    case 20: {
                        area.setOffset(context.getLineHeight() - bpd);
                        break block0;
                    }
                }
                area.setOffset(context.getBaseline());
            }
        }
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        if (this.fobj.getLeaderPattern() != 158) {
            super.addAreas(posIter, context);
        } else {
            this.addId();
            this.widthAdjustArea(this.curArea, context);
            KnuthPossPosIter contentIter = new KnuthPossPosIter(this.contentList, 0, this.contentList.size());
            this.clm.addAreas(contentIter, context);
            this.offsetArea(this.curArea, context);
            this.parentLM.addChildArea(this.curArea);
            while (posIter.hasNext()) {
                posIter.next();
            }
        }
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.curArea = this.get(context);
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        MinOptMax ipd = this.getAllocationIPD(context.getRefIPD());
        int bpd = this.curArea.getBPD();
        int lead = 0;
        int total = 0;
        int middle = 0;
        switch (this.verticalAlignment) {
            case 84: {
                middle = bpd / 2;
                break;
            }
            case 20: 
            case 145: {
                total = bpd;
                break;
            }
            default: {
                lead = bpd;
            }
        }
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, ipd, false, lead, total, middle);
        returnList.add(new KnuthInlineBox(0, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, -1), true));
        returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
        returnList.add(new KnuthGlue(this.areaInfo.ipdArea.opt, this.areaInfo.ipdArea.max - this.areaInfo.ipdArea.opt, this.areaInfo.ipdArea.opt - this.areaInfo.ipdArea.min, new LeafPosition(this, 0), false));
        returnList.add(new KnuthInlineBox(0, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, -1), true));
        this.setFinished(true);
        return returnList;
    }

    public void hyphenate(Position pos, HyphContext hc) {
        super.hyphenate(pos, hc);
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return false;
    }

    public LinkedList getChangedKnuthElements(List oldList, int flaggedPenalty, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        returnList.add(new KnuthInlineBox(0, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, -1), true));
        returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
        returnList.add(new KnuthGlue(this.areaInfo.ipdArea.opt, this.areaInfo.ipdArea.max - this.areaInfo.ipdArea.opt, this.areaInfo.ipdArea.opt - this.areaInfo.ipdArea.min, new LeafPosition(this, 0), false));
        returnList.add(new KnuthInlineBox(0, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, -1), true));
        this.setFinished(true);
        return returnList;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

