/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.OutputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.bitmap.PNGRenderer;
import org.apache.fop.render.bitmap.TIFFRenderer;
import org.apache.fop.render.mif.MIFHandler;
import org.apache.fop.render.pcl.PCLRenderer;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.print.PrintRenderer;
import org.apache.fop.render.ps.PSRenderer;
import org.apache.fop.render.rtf.RTFHandler;
import org.apache.fop.render.svg.SVGRenderer;
import org.apache.fop.render.txt.TXTRenderer;
import org.apache.fop.render.xml.XMLRenderer;

public class RendererFactory {
    private static Renderer newInstance(int renderType) throws IllegalArgumentException {
        switch (renderType) {
            case 1: {
                return new PDFRenderer();
            }
            case 2: {
                return new AWTRenderer();
            }
            case 4: {
                return new PrintRenderer();
            }
            case 5: {
                return new PCLRenderer();
            }
            case 11: {
                return new TIFFRenderer();
            }
            case 12: {
                return new PNGRenderer();
            }
            case 6: {
                return new PSRenderer();
            }
            case 7: {
                return new TXTRenderer();
            }
            case 9: {
                return new XMLRenderer();
            }
            case 8: {
                return new SVGRenderer();
            }
        }
        throw new IllegalArgumentException("Invalid renderer type " + renderType);
    }

    public static Renderer createRenderer(FOUserAgent userAgent, int renderType) throws FOPException {
        if (userAgent.getRendererOverride() != null) {
            return userAgent.getRendererOverride();
        }
        Renderer rend = RendererFactory.newInstance(renderType);
        rend.setUserAgent(userAgent);
        String mimeType = rend.getMimeType();
        Configuration userRendererConfig = null;
        if (mimeType != null) {
            userRendererConfig = userAgent.getUserRendererConfig(mimeType);
        }
        if (userRendererConfig != null) {
            try {
                ContainerUtil.configure(rend, userRendererConfig);
            }
            catch (ConfigurationException e) {
                throw new FOPException(e);
            }
        }
        return rend;
    }

    public static FOEventHandler createFOEventHandler(FOUserAgent userAgent, int renderType, OutputStream out) throws FOPException {
        if (userAgent.getFOEventHandlerOverride() != null) {
            return userAgent.getFOEventHandlerOverride();
        }
        if (renderType != 4 && renderType != 2 && out == null && userAgent.getRendererOverride() == null) {
            throw new IllegalStateException("OutputStream has not been set");
        }
        if (renderType == 3) {
            return new MIFHandler(userAgent, out);
        }
        if (renderType == 10) {
            return new RTFHandler(userAgent, out);
        }
        if (renderType < 1 || renderType > 12) {
            throw new IllegalArgumentException("Invalid render ID#" + renderType);
        }
        return new AreaTreeHandler(userAgent, renderType, out);
    }
}

