/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.OutputStream;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextElementBridge;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFXMLHandler
implements XMLHandler {
    private Log log = LogFactory.getLog(class$org$apache$fop$render$pdf$PDFXMLHandler == null ? (class$org$apache$fop$render$pdf$PDFXMLHandler = PDFXMLHandler.class$("org.apache.fop.render.pdf.PDFXMLHandler")) : class$org$apache$fop$render$pdf$PDFXMLHandler);
    public static final String PDF_DOCUMENT = "pdfDoc";
    public static final String OUTPUT_STREAM = "outputStream";
    public static final String PDF_STATE = "pdfState";
    public static final String PDF_PAGE = "pdfPage";
    public static final String PDF_CONTEXT = "pdfContext";
    public static final String PDF_STREAM = "pdfStream";
    public static final String PDF_WIDTH = "width";
    public static final String PDF_HEIGHT = "height";
    public static final String PDF_FONT_INFO = "fontInfo";
    public static final String PDF_FONT_NAME = "fontName";
    public static final String PDF_FONT_SIZE = "fontSize";
    public static final String PDF_XPOS = "xpos";
    public static final String PDF_YPOS = "ypos";
    static /* synthetic */ Class class$org$apache$fop$render$pdf$PDFXMLHandler;

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        PDFInfo pdfi = PDFXMLHandler.getPDFInfo(context);
        String svg = "http://www.w3.org/2000/svg";
        if (svg.equals(ns)) {
            SVGHandler svghandler = new SVGHandler();
            svghandler.renderSVGDocument(context, doc, pdfi);
        }
    }

    public static PDFInfo getPDFInfo(RendererContext context) {
        PDFInfo pdfi = new PDFInfo();
        pdfi.pdfDoc = (PDFDocument)context.getProperty(PDF_DOCUMENT);
        pdfi.outputStream = (OutputStream)context.getProperty(OUTPUT_STREAM);
        pdfi.pdfState = (PDFState)context.getProperty(PDF_STATE);
        pdfi.pdfPage = (PDFPage)context.getProperty(PDF_PAGE);
        pdfi.pdfContext = (PDFResourceContext)context.getProperty(PDF_CONTEXT);
        pdfi.currentStream = (PDFStream)context.getProperty(PDF_STREAM);
        pdfi.width = (Integer)context.getProperty(PDF_WIDTH);
        pdfi.height = (Integer)context.getProperty(PDF_HEIGHT);
        pdfi.fi = (FontInfo)context.getProperty(PDF_FONT_INFO);
        pdfi.currentFontName = (String)context.getProperty(PDF_FONT_NAME);
        pdfi.currentFontSize = (Integer)context.getProperty(PDF_FONT_SIZE);
        pdfi.currentXPosition = (Integer)context.getProperty(PDF_XPOS);
        pdfi.currentYPosition = (Integer)context.getProperty(PDF_YPOS);
        return pdfi;
    }

    public String getMimeType() {
        return "application/pdf";
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/svg";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class SVGHandler {
        protected SVGHandler() {
        }

        protected void renderSVGDocument(RendererContext context, Document doc, PDFInfo pdfInfo) {
            GraphicsNode root;
            int xOffset = pdfInfo.currentXPosition;
            int yOffset = pdfInfo.currentYPosition;
            SVGUserAgent ua = new SVGUserAgent(context.getUserAgent().getPixelUnitToMillimeter(), new AffineTransform());
            GVTBuilder builder = new GVTBuilder();
            BridgeContext ctx = new BridgeContext((UserAgent)ua);
            PDFTextElementBridge tBridge = new PDFTextElementBridge(pdfInfo.fi);
            ctx.putBridge((Bridge)tBridge);
            PDFAElementBridge aBridge = new PDFAElementBridge();
            AffineTransform transform = pdfInfo.pdfState.getTransform();
            transform.translate((float)xOffset / 1000.0f, (float)yOffset / 1000.0f);
            aBridge.setCurrentTransform(transform);
            ctx.putBridge((Bridge)aBridge);
            try {
                root = builder.build(ctx, doc);
            }
            catch (Exception e) {
                PDFXMLHandler.this.log.error("svg graphic could not be built: " + e.getMessage(), e);
                return;
            }
            float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
            float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
            float sx = (float)pdfInfo.width / w;
            float sy = (float)pdfInfo.height / h;
            ctx = null;
            builder = null;
            PDFRenderer renderer = (PDFRenderer)context.getRenderer();
            renderer.saveGraphicsState();
            renderer.setColor(Color.black, false, null);
            renderer.setColor(Color.black, true, null);
            pdfInfo.currentStream.add(sx + " 0 0 " + sy + " " + (float)xOffset / 1000.0f + " " + (float)yOffset / 1000.0f + " cm\n");
            SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
            AffineTransform at = ViewBox.getPreserveAspectRatioTransform((Element)svg, (float)(w / 1000.0f), (float)(h / 1000.0f));
            if (pdfInfo.pdfContext == null) {
                pdfInfo.pdfContext = pdfInfo.pdfPage;
            }
            PDFGraphics2D graphics = new PDFGraphics2D(true, pdfInfo.fi, pdfInfo.pdfDoc, pdfInfo.pdfContext, pdfInfo.pdfPage.referencePDF(), pdfInfo.currentFontName, pdfInfo.currentFontSize);
            graphics.setGraphicContext(new GraphicContext());
            pdfInfo.pdfState.push();
            transform = new AffineTransform();
            transform.translate((float)xOffset / 1000.0f, (float)yOffset / 1000.0f);
            pdfInfo.pdfState.setTransform(transform);
            graphics.setPDFState(pdfInfo.pdfState);
            graphics.setOutputStream(pdfInfo.outputStream);
            try {
                root.paint((Graphics2D)((Object)graphics));
                pdfInfo.currentStream.add(graphics.getString());
            }
            catch (Exception e) {
                PDFXMLHandler.this.log.error("svg graphic could not be rendered: " + e.getMessage(), e);
            }
            renderer.restoreGraphicsState();
            pdfInfo.pdfState.pop();
        }
    }

    public static class PDFInfo {
        public PDFDocument pdfDoc;
        public OutputStream outputStream;
        public PDFState pdfState;
        public PDFPage pdfPage;
        public PDFResourceContext pdfContext;
        public PDFStream currentStream;
        public int width;
        public int height;
        public FontInfo fi;
        public String currentFontName;
        public int currentFontSize;
        public int currentXPosition;
        public int currentYPosition;
    }
}

