/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IBorderAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExtraRowSet;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraph;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;

public class RtfTableRow
extends RtfContainer
implements ITableAttributes {
    private RtfTableCell cell;
    private RtfExtraRowSet extraRowSet;
    private int id;
    private int highestCell = 0;

    RtfTableRow(RtfTable parent, Writer w, int idNum) throws IOException {
        super(parent, w);
        this.id = idNum;
    }

    RtfTableRow(RtfTable parent, Writer w, RtfAttributes attrs, int idNum) throws IOException {
        super(parent, w, attrs);
        this.id = idNum;
    }

    public RtfTableCell newTableCell(int cellWidth) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, cellWidth, this.highestCell);
        return this.cell;
    }

    public RtfTableCell newTableCell(int cellWidth, RtfAttributes attrs) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, cellWidth, attrs, this.highestCell);
        return this.cell;
    }

    public RtfTableCell newTableCellMergedVertically(int cellWidth, RtfAttributes attrs) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, cellWidth, attrs, this.highestCell);
        this.cell.setVMerge(2);
        return this.cell;
    }

    public RtfTableCell newTableCellMergedHorizontally(int cellWidth, RtfAttributes attrs) throws IOException {
        ++this.highestCell;
        RtfAttributes wAttributes = (RtfAttributes)attrs.clone();
        wAttributes.unset("number-columns-spanned");
        this.cell = new RtfTableCell(this, this.writer, cellWidth, wAttributes, this.highestCell);
        this.cell.setHMerge(2);
        return this.cell;
    }

    protected void writeRtfPrefix() throws IOException {
        this.newLine();
        this.writeGroupMark(true);
    }

    protected void writeRtfContent() throws IOException {
        this.extraRowSet = new RtfExtraRowSet(this.writer);
        this.writeControlWord("trowd");
        if (this.attrib != null && this.attrib.isSet("trkeep")) {
            this.writeControlWord("trkeep");
        }
        this.writePaddingAttributes();
        RtfTable parentTable = (RtfTable)this.parent;
        this.adjustBorderProperties(parentTable);
        this.writeAttributes(this.attrib, new String[]{"trhdr"});
        this.writeAttributes(this.attrib, ITableAttributes.ROW_BORDER);
        this.writeAttributes(this.attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.attrib, IBorderAttributes.BORDERS);
        if (this.attrib.isSet("trrh")) {
            this.writeOneAttribute("trrh", this.attrib.getValue("trrh"));
        }
        boolean nestedTableFound = false;
        int index = 0;
        int numberOfCellsBeforeNestedTable = 0;
        Vector<Integer> indexesFound = new Vector<Integer>();
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            RtfElement e = (RtfElement)it.next();
            if (e instanceof RtfTableCell) {
                if (!nestedTableFound) {
                    ++numberOfCellsBeforeNestedTable;
                }
                Iterator it2 = ((RtfTableCell)e).getChildren().iterator();
                while (it2.hasNext()) {
                    RtfElement subElement = (RtfElement)it2.next();
                    if (subElement instanceof RtfTable) {
                        nestedTableFound = true;
                        indexesFound.addElement(new Integer(index));
                        continue;
                    }
                    if (!(subElement instanceof RtfParagraph)) continue;
                    Iterator it3 = ((RtfParagraph)subElement).getChildren().iterator();
                    while (it3.hasNext()) {
                        RtfElement subSubElement = (RtfElement)it3.next();
                        if (!(subSubElement instanceof RtfTable)) continue;
                        nestedTableFound = true;
                        indexesFound.addElement(new Integer(index));
                    }
                }
            }
            ++index;
        }
        int xPos = 0;
        Object leftIndent = this.attrib.getValue("trleft");
        if (leftIndent != null) {
            xPos = (Integer)leftIndent;
        }
        index = 0;
        Iterator it2 = this.getChildren().iterator();
        while (it2.hasNext()) {
            RtfElement e = (RtfElement)it2.next();
            if (e instanceof RtfTableCell) {
                if (!indexesFound.isEmpty()) {
                    for (int i = 0; i < indexesFound.size() && index != (Integer)indexesFound.get(i); ++i) {
                        if (index < (Integer)indexesFound.get(i)) {
                            ((RtfTableCell)e).setVMerge(1);
                            break;
                        }
                        if (index <= (Integer)indexesFound.get(i)) continue;
                        ((RtfTableCell)e).setVMerge(1);
                        break;
                    }
                }
                RtfTableCell cell = (RtfTableCell)e;
                if (index == 0 && !cell.getRtfAttributes().isSet("clbrdrl")) {
                    cell.getRtfAttributes().set("clbrdrl", (String)this.attrib.getValue("trbrdrl"));
                }
                if (index == this.getChildCount() - 1 && !cell.getRtfAttributes().isSet("clbrdrr")) {
                    cell.getRtfAttributes().set("clbrdrr", (String)this.attrib.getValue("trbrdrr"));
                }
                if (this.isFirstRow() && !cell.getRtfAttributes().isSet("clbrdrt")) {
                    cell.getRtfAttributes().set("clbrdrt", (String)this.attrib.getValue("trbrdrt"));
                }
                if (parentTable != null && parentTable.isHighestRow(this.id) && !cell.getRtfAttributes().isSet("clbrdrb")) {
                    cell.getRtfAttributes().set("clbrdrb", (String)this.attrib.getValue("trbrdrb"));
                }
                xPos = cell.writeCellDef(xPos);
            }
            ++index;
        }
        this.newLine();
        super.writeRtfContent();
    }

    private void adjustBorderProperties(RtfTable parentTable) {
        if (this.attrib != null && parentTable != null) {
            if (this.isFirstRow() && parentTable.isHighestRow(this.id)) {
                this.attrib.unset("trbrdrh");
            } else if (this.isFirstRow()) {
                this.attrib.unset("trbrdrb");
            } else if (parentTable.isHighestRow(this.id)) {
                this.attrib.unset("trbrdrt");
            } else {
                this.attrib.unset("trbrdrb");
                this.attrib.unset("trbrdrt");
            }
        }
    }

    protected void writeRtfSuffix() throws IOException {
        this.writeControlWord("row");
        this.extraRowSet.writeRtf();
        this.writeGroupMark(false);
    }

    RtfExtraRowSet getExtraRowSet() {
        return this.extraRowSet;
    }

    private void writePaddingAttributes() throws IOException {
        if (this.attrib != null && !this.attrib.isSet("trgaph")) {
            int gaph = -1;
            try {
                Integer rightPadStr;
                Integer leftPadStr = (Integer)this.attrib.getValue("trpaddl");
                if (leftPadStr != null) {
                    gaph = leftPadStr;
                }
                if ((rightPadStr = (Integer)this.attrib.getValue("trpaddr")) != null) {
                    gaph = (gaph + rightPadStr) / 2;
                }
            }
            catch (Exception e) {
                String string = "RtfTableRow.writePaddingAttributes: " + e.toString();
            }
            if (gaph >= 0) {
                this.attrib.set("trgaph", gaph);
            }
        }
        this.writeAttributes(this.attrib, ATTRIB_ROW_PADDING);
    }

    public boolean isFirstRow() {
        return this.id == 1;
    }

    public boolean isHighestCell(int id) {
        return this.highestCell == id;
    }
}

