/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.JpegImage;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.FopPDFImage;
import org.apache.fop.svg.PDFGraphicsConfiguration;

public class PDFGraphics2D
extends AbstractGraphics2D {
    protected PDFDocument pdfDoc;
    protected PDFResourceContext resourceContext;
    protected String pageRef;
    protected PDFState graphicsState;
    protected int baseLevel = 0;
    protected int jpegCount = 0;
    protected FontInfo fontInfo;
    protected Font ovFontState = null;
    protected StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected float currentFontSize;
    protected OutputStream outputStream = null;
    private Graphics2D fmg;

    public PDFGraphics2D(boolean textAsShapes, FontInfo fi, PDFDocument doc, PDFResourceContext page, String pref, String font, float size) {
        this(textAsShapes);
        this.pdfDoc = doc;
        this.resourceContext = page;
        this.currentFontName = font;
        this.currentFontSize = size;
        this.fontInfo = fi;
        this.pageRef = pref;
        this.graphicsState = new PDFState();
    }

    protected PDFGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public PDFGraphics2D(PDFGraphics2D g) {
        super((AbstractGraphics2D)g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public Graphics create() {
        return new PDFGraphics2D(this);
    }

    protected void handleIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    protected void preparePainting() {
    }

    public void setPDFState(PDFState state) {
        this.graphicsState = state;
        this.baseLevel = this.graphicsState.getStackLevel();
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public String getString() {
        return this.currentStream.toString();
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
        this.setPrivateHints();
    }

    private void setPrivateHints() {
        this.setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
    }

    public void setOverrideFontState(Font infont) {
        this.ovFontState = infont;
    }

    public void addLink(Rectangle2D bounds, AffineTransform trans, String dest, int linkType) {
        this.preparePainting();
        AffineTransform at = this.getTransform();
        Shape b = at.createTransformedShape(bounds);
        b = trans.createTransformedShape(b);
        if (b != null) {
            Rectangle rect = b.getBounds();
            if (linkType != 0) {
                String pdfdest = "/FitR " + dest;
                this.resourceContext.addAnnotation(this.pdfDoc.getFactory().makeLink(rect, this.pageRef, pdfdest));
            } else {
                this.resourceContext.addAnnotation(this.pdfDoc.getFactory().makeLink(rect, dest, linkType, 0.0f));
            }
        }
    }

    public void addJpegImage(JpegImage jpeg, float x, float y, float width, float height) {
        this.preparePainting();
        String key = "__AddJPEG_" + this.jpegCount;
        ++this.jpegCount;
        FopPDFImage fopimage = new FopPDFImage(jpeg, key);
        int xObjectNum = this.pdfDoc.addImage(this.resourceContext, fopimage).getXNumber();
        AffineTransform at = this.getTransform();
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        if (!at.isIdentity()) {
            this.currentStream.write("" + matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + " cm\n");
        }
        this.currentStream.write("" + width + " 0 0 " + -height + " " + x + " " + (y + height) + " cm\n" + "/Im" + xObjectNum + " Do\nQ\n");
        if (this.outputStream != null) {
            try {
                this.pdfDoc.output(this.outputStream);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.preparePainting();
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        if (width == -1 || height == -1) {
            return false;
        }
        return this.drawImage(img, x, y, width, height, observer);
    }

    private BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.preparePainting();
        PDFXObject imageInfo = this.pdfDoc.getImage("TempImage:" + img.toString());
        if (imageInfo == null) {
            BitmapImage fopimg;
            Dimension size = new Dimension(width, height);
            BufferedImage buf = this.buildBufferedImage(size);
            Graphics2D g = buf.createGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.setBackground(new Color(1, 1, 1, 0));
            g.setPaint(new Color(1, 1, 1, 0));
            g.fillRect(0, 0, width, height);
            g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
            g.setComposite(this.gc.getComposite());
            if (!g.drawImage(img, 0, 0, buf.getWidth(), buf.getHeight(), observer)) {
                return false;
            }
            g.dispose();
            byte[] result = new byte[buf.getWidth() * buf.getHeight() * 3];
            byte[] mask = new byte[buf.getWidth() * buf.getHeight()];
            boolean hasMask = false;
            Raster raster = buf.getData();
            DataBuffer bd = raster.getDataBuffer();
            int count = 0;
            int maskpos = 0;
            switch (bd.getDataType()) {
                case 3: {
                    int[][] idata = ((DataBufferInt)bd).getBankData();
                    for (int i = 0; i < idata.length; ++i) {
                        int[] iarray = idata[i];
                        for (int j = 0; j < iarray.length; ++j) {
                            int val = iarray[j];
                            int alpha = val >>> 24;
                            mask[maskpos++] = (byte)(alpha & 0xFF);
                            if (alpha != 255) {
                                hasMask = true;
                            }
                            result[count++] = (byte)(val >> 16 & 0xFF);
                            result[count++] = (byte)(val >> 8 & 0xFF);
                            result[count++] = (byte)(val & 0xFF);
                        }
                    }
                    break;
                }
            }
            String ref = null;
            if (hasMask) {
                fopimg = new BitmapImage("TempImageMask:" + img.toString(), buf.getWidth(), buf.getHeight(), mask, null);
                fopimg.setColorSpace(new PDFColorSpace(1));
                PDFXObject xobj = this.pdfDoc.addImage(this.resourceContext, fopimg);
                ref = xobj.referencePDF();
                if (this.outputStream != null) {
                    try {
                        this.pdfDoc.output(this.outputStream);
                    }
                    catch (IOException ioe) {}
                }
            } else {
                mask = null;
            }
            fopimg = new BitmapImage("TempImage:" + img.toString(), buf.getWidth(), buf.getHeight(), result, ref);
            fopimg.setTransparent(new PDFColor(255, 255, 255));
            imageInfo = this.pdfDoc.addImage(this.resourceContext, fopimg);
            if (this.outputStream != null) {
                try {
                    this.pdfDoc.output(this.outputStream);
                }
                catch (IOException ioe) {}
            }
        } else {
            this.resourceContext.getPDFResources().addXObject(imageInfo);
        }
        AffineTransform at = this.getTransform();
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        if (!at.isIdentity()) {
            this.currentStream.write("" + matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + " cm\n");
        }
        this.currentStream.write("" + width + " 0 0 " + -height + " " + x + " " + (y + height) + " cm\n" + "/Im" + imageInfo.getXNumber() + " Do\nQ\n");
        return true;
    }

    public void dispose() {
        this.pdfDoc = null;
        this.fontInfo = null;
        this.currentStream = null;
        this.currentFontName = null;
    }

    public void draw(Shape s) {
        Color c;
        boolean newTransform;
        this.preparePainting();
        AffineTransform trans = this.getTransform();
        double[] tranvals = new double[6];
        trans.getMatrix(tranvals);
        Shape imclip = this.getClip();
        boolean newClip = this.graphicsState.checkClip(imclip);
        boolean bl = newTransform = this.graphicsState.checkTransform(trans) && !trans.isIdentity();
        if (newClip || newTransform) {
            this.currentStream.write("q\n");
            this.graphicsState.push();
            if (newClip) {
                this.writeClip(imclip);
            }
            if (newTransform) {
                this.currentStream.write(PDFNumber.doubleOut(tranvals[0], 5) + " " + PDFNumber.doubleOut(tranvals[1], 5) + " " + PDFNumber.doubleOut(tranvals[2], 5) + " " + PDFNumber.doubleOut(tranvals[3], 5) + " " + PDFNumber.doubleOut(tranvals[4], 5) + " " + PDFNumber.doubleOut(tranvals[5], 5) + " cm\n");
            }
        }
        if ((c = this.getColor()).getAlpha() == 0) {
            return;
        }
        if (c.getAlpha() != 255) {
            HashMap<String, Float> vals = new HashMap<String, Float>();
            vals.put("CA", new Float((float)c.getAlpha() / 255.0f));
            PDFGState gstate = this.pdfDoc.getFactory().makeGState(vals, this.graphicsState.getGState());
            this.resourceContext.addGState(gstate);
            this.currentStream.write("/" + gstate.getName() + " gs\n");
        }
        this.applyColor(c, false);
        this.applyPaint(this.getPaint(), false);
        this.applyStroke(this.getStroke());
        PathIterator iter = s.getPathIterator(new AffineTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " " + PDFNumber.doubleOut(vals[2], 5) + " " + PDFNumber.doubleOut(vals[3], 5) + " " + PDFNumber.doubleOut(vals[4], 5) + " " + PDFNumber.doubleOut(vals[5], 5) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " " + PDFNumber.doubleOut(vals[2], 5) + " " + PDFNumber.doubleOut(vals[3], 5) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
        this.doDrawing(false, true, false);
        if (newClip || newTransform) {
            this.currentStream.write("Q\n");
            this.graphicsState.pop();
        }
    }

    protected void writeClip(Shape s) {
        if (s == null) {
            return;
        }
        this.preparePainting();
        PathIterator iter = s.getPathIterator(this.getTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
        this.currentStream.write("W\n");
        this.currentStream.write("n\n");
    }

    protected void applyColor(Color col, boolean fill) {
        this.preparePainting();
        Color c = col;
        if (c.getColorSpace().getType() == 5) {
            PDFColor currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
            this.currentStream.write(currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 9) {
            float[] cComps = c.getColorComponents(new float[3]);
            double[] cmyk = new double[3];
            for (int i = 0; i < 3; ++i) {
                cmyk[i] = cComps[i];
            }
            PDFColor currentColour = new PDFColor(cmyk[0], cmyk[1], cmyk[2], cmyk[3]);
            this.currentStream.write(currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 12) {
            float[] cComps = c.getColorComponents(new float[1]);
            double[] blackMagenta = new double[1];
            for (int i = 0; i < 1; ++i) {
                blackMagenta[i] = cComps[i];
            }
        } else {
            System.err.println("Color Space not supported by PDFGraphics2D");
        }
    }

    protected void applyPaint(Paint paint, boolean fill) {
        this.preparePainting();
        if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint gp = (LinearGradientPaint)paint;
            Color[] cols = gp.getColors();
            float[] fractions = gp.getFractions();
            Point2D p1 = gp.getStartPoint();
            Point2D p2 = gp.getEndPoint();
            AffineTransform transform = this.graphicsState.getTransform();
            transform.concatenate(gp.getTransform());
            transform.concatenate(this.getTransform());
            p1 = transform.transform(p1, null);
            p2 = transform.transform(p2, null);
            ArrayList<Double> theCoords = new ArrayList<Double>();
            theCoords.add(new Double(p1.getX()));
            theCoords.add(new Double(p1.getY()));
            theCoords.add(new Double(p2.getX()));
            theCoords.add(new Double(p2.getY()));
            ArrayList<Boolean> theExtend = new ArrayList<Boolean>();
            theExtend.add(new Boolean(true));
            theExtend.add(new Boolean(true));
            ArrayList<Double> theDomain = new ArrayList<Double>();
            theDomain.add(new Double(0.0));
            theDomain.add(new Double(1.0));
            ArrayList<Double> theEncode = new ArrayList<Double>();
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            ArrayList<Double> theBounds = new ArrayList<Double>();
            ArrayList<PDFColor> someColors = new ArrayList<PDFColor>();
            for (int count = 0; count < cols.length; ++count) {
                Color c1 = cols[count];
                PDFColor color1 = new PDFColor(c1.getRed(), c1.getGreen(), c1.getBlue());
                someColors.add(color1);
                if (count <= 0 || count >= cols.length - 1) continue;
                theBounds.add(new Double(fractions[count]));
            }
            PDFColorSpace aColorSpace = new PDFColorSpace(2);
            PDFPattern myPat = this.pdfDoc.getFactory().makeGradient(this.resourceContext, false, aColorSpace, someColors, theBounds, theCoords);
            this.currentStream.write(myPat.getColorSpaceOut(fill));
        } else if (paint instanceof RadialGradientPaint) {
            RadialGradientPaint rgp = (RadialGradientPaint)paint;
            double ar = rgp.getRadius();
            Point2D ac = rgp.getCenterPoint();
            Point2D af = rgp.getFocusPoint();
            AffineTransform transform = this.graphicsState.getTransform();
            AffineTransform gradt = rgp.getTransform();
            transform.concatenate(gradt);
            double scale = gradt.getScaleX();
            if (gradt.getScaleY() > scale) {
                scale = gradt.getScaleY();
            }
            ar *= scale;
            ac = transform.transform(ac, null);
            af = transform.transform(af, null);
            ArrayList<Double> theCoords = new ArrayList<Double>();
            theCoords.add(new Double(af.getX()));
            theCoords.add(new Double(af.getY()));
            theCoords.add(new Double(0.0));
            theCoords.add(new Double(ac.getX()));
            theCoords.add(new Double(ac.getY()));
            theCoords.add(new Double(ar));
            Color[] cols = rgp.getColors();
            ArrayList<PDFColor> someColors = new ArrayList<PDFColor>();
            for (int count = 0; count < cols.length; ++count) {
                Color cc = cols[count];
                someColors.add(new PDFColor(cc.getRed(), cc.getGreen(), cc.getBlue()));
            }
            float[] fractions = rgp.getFractions();
            ArrayList<Double> theBounds = new ArrayList<Double>();
            for (int count = 1; count < fractions.length - 1; ++count) {
                float offset = fractions[count];
                theBounds.add(new Double(offset));
            }
            PDFColorSpace colSpace = new PDFColorSpace(2);
            PDFPattern myPat = this.pdfDoc.getFactory().makeGradient(this.resourceContext, true, colSpace, someColors, theBounds, theCoords);
            this.currentStream.write(myPat.getColorSpaceOut(fill));
        } else if (paint instanceof PatternPaint) {
            PatternPaint pp = (PatternPaint)paint;
            this.createPattern(pp, fill);
        }
    }

    private void createPattern(PatternPaint pp, boolean fill) {
        this.preparePainting();
        Rectangle2D rect = pp.getPatternRect();
        FontInfo fontInfo = new FontInfo();
        FontSetup.setup(fontInfo, null);
        PDFResources res = this.pdfDoc.getFactory().makeResources();
        PDFResourceContext context = new PDFResourceContext(res);
        PDFGraphics2D pattGraphic = new PDFGraphics2D(this.textAsShapes, fontInfo, this.pdfDoc, context, this.pageRef, "", 0.0f);
        pattGraphic.gc = (GraphicContext)this.gc.clone();
        pattGraphic.gc.validateTransformStack();
        pattGraphic.setOutputStream(this.outputStream);
        GraphicsNode gn = pp.getGraphicsNode();
        gn.paint((Graphics2D)((Object)pattGraphic));
        StringWriter pattStream = new StringWriter();
        pattStream.write("q\n");
        pattStream.write("1 0 0 -1 0 " + (rect.getHeight() + rect.getY()) + " cm\n");
        pattStream.write(pattGraphic.getString());
        pattStream.write("Q");
        ArrayList<Double> bbox = new ArrayList<Double>();
        bbox.add(new Double(0.0));
        bbox.add(new Double(0.0));
        bbox.add(new Double(rect.getWidth() + rect.getX()));
        bbox.add(new Double(rect.getHeight() + rect.getY()));
        ArrayList<Double> translate = new ArrayList<Double>();
        AffineTransform pattt = pp.getPatternTransform();
        pattt.translate(rect.getWidth() + rect.getX(), rect.getHeight() + rect.getY());
        double[] flatmatrix = new double[6];
        pattt.getMatrix(flatmatrix);
        translate.add(new Double(flatmatrix[0]));
        translate.add(new Double(flatmatrix[1]));
        translate.add(new Double(flatmatrix[2]));
        translate.add(new Double(flatmatrix[3]));
        translate.add(new Double(flatmatrix[4]));
        translate.add(new Double(flatmatrix[5]));
        res.addFonts(this.pdfDoc, fontInfo);
        PDFPattern myPat = this.pdfDoc.getFactory().makePattern(this.resourceContext, 1, res, 1, 1, bbox, rect.getWidth(), rect.getHeight(), translate, null, pattStream.getBuffer());
        this.currentStream.write(myPat.getColorSpaceOut(fill));
        PDFAnnotList annots = context.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        if (this.outputStream != null) {
            try {
                this.pdfDoc.output(this.outputStream);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            float[] da = bs.getDashArray();
            if (da != null) {
                this.currentStream.write("[");
                for (int count = 0; count < da.length; ++count) {
                    if ((int)da[count] == 0) {
                        this.currentStream.write("1");
                    } else {
                        this.currentStream.write("" + (int)da[count]);
                    }
                    if (count >= da.length - 1) continue;
                    this.currentStream.write(" ");
                }
                this.currentStream.write("] ");
                float offset = bs.getDashPhase();
                this.currentStream.write((int)offset + " d\n");
            }
            int ec = bs.getEndCap();
            switch (ec) {
                case 0: {
                    this.currentStream.write("0 J\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 J\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 J\n");
                }
            }
            int lj = bs.getLineJoin();
            switch (lj) {
                case 0: {
                    this.currentStream.write("0 j\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 j\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 j\n");
                }
            }
            float lw = bs.getLineWidth();
            this.currentStream.write(PDFNumber.doubleOut(lw) + " w\n");
            float ml = bs.getMiterLimit();
            this.currentStream.write(PDFNumber.doubleOut(ml) + " M\n");
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public void drawString(String s, float x, float y) {
        Font fontState;
        this.preparePainting();
        if (this.ovFontState == null) {
            java.awt.Font gFont = this.getFont();
            String n = gFont.getFamily();
            if (n.equals("sanserif")) {
                n = "sans-serif";
            }
            int siz = gFont.getSize();
            String style = gFont.isItalic() ? "italic" : "normal";
            int weight = gFont.isBold() ? 700 : 400;
            String fname = this.fontInfo.fontLookup(n, style, weight);
            org.apache.fop.fonts.FontMetrics metrics = this.fontInfo.getMetricsFor(fname);
            fontState = new Font(fname, metrics, siz * 1000);
        } else {
            org.apache.fop.fonts.FontMetrics metrics = this.fontInfo.getMetricsFor(this.ovFontState.getFontName());
            fontState = new Font(this.ovFontState.getFontName(), metrics, this.ovFontState.getFontSize());
            this.ovFontState = null;
        }
        String name = fontState.getFontName();
        float size = (float)fontState.getFontSize() / 1000.0f;
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.currentFontName = name;
            this.currentFontSize = size;
            this.currentStream.write("/" + name + " " + size + " Tf\n");
        }
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.applyColor(c, true);
        this.applyPaint(this.getPaint(), true);
        int salpha = c.getAlpha();
        if (salpha != 255) {
            HashMap<String, Float> vals = new HashMap<String, Float>();
            vals.put("ca", new Float((float)salpha / 255.0f));
            PDFGState gstate = this.pdfDoc.getFactory().makeGState(vals, this.graphicsState.getGState());
            this.resourceContext.addGState(gstate);
            this.currentStream.write("/" + gstate.getName() + " gs\n");
        }
        this.currentStream.write("BT\n");
        Map kerning = null;
        boolean kerningAvailable = false;
        kerning = fontState.getKerning();
        if (kerning != null && !kerning.isEmpty()) {
            kerningAvailable = true;
        }
        boolean useMultiByte = false;
        Typeface f = (Typeface)this.fontInfo.getFonts().get(name);
        if (f instanceof LazyFont) {
            if (((LazyFont)f).getRealFont() instanceof CIDFont) {
                useMultiByte = true;
            }
        } else if (f instanceof CIDFont) {
            useMultiByte = true;
        }
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " cm\n");
        this.currentStream.write("1 0 0 -1 0 0 Tm [" + startText);
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = fontState.mapChar(s.charAt(i));
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    this.currentStream.write("\\");
                    this.currentStream.write(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            this.currentStream.write("\\");
                        }
                    }
                    this.currentStream.write(ch);
                }
            } else {
                this.currentStream.write(PDFText.toUnicodeHex(ch));
            }
            if (!kerningAvailable || i + 1 >= l) continue;
            this.addKerning(this.currentStream, new Integer(ch), new Integer(fontState.mapChar(s.charAt(i + 1))), kerning, startText, endText);
        }
        this.currentStream.write(endText);
        this.currentStream.write("] TJ\n");
        this.currentStream.write("ET\n");
        this.currentStream.write("Q\n");
    }

    private void addKerning(StringWriter buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        this.preparePainting();
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            this.currentStream.write(endText + -width.intValue() + " " + startText);
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.preparePainting();
        System.err.println("drawString(AttributedCharacterIterator)");
        Font fontState = null;
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.applyColor(c, true);
        this.applyPaint(this.getPaint(), true);
        boolean fill = true;
        boolean stroke = false;
        Stroke currentStroke = this.getStroke();
        stroke = true;
        this.applyStroke(currentStroke);
        this.applyColor(c, false);
        this.applyPaint(this.getPaint(), false);
        this.currentStream.write("BT\n");
        int textr = 0;
        if (fill && stroke) {
            textr = 2;
        } else if (stroke) {
            textr = 1;
        }
        this.currentStream.write(textr + " Tr\n");
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        char ch = iterator.first();
        while (ch != '\uffff') {
            String name = fontState.getFontName();
            int size = fontState.getFontSize();
            if (!name.equals(this.currentFontName) || (float)size != this.currentFontSize) {
                this.currentFontName = name;
                this.currentFontSize = size;
                this.currentStream.write("/" + name + " " + size / 1000 + " Tf\n");
            }
            this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " Tm (" + ch + ") Tj\n");
            ch = iterator.next();
        }
        this.currentStream.write("ET\n");
    }

    public void fill(Shape s) {
        Paint paint;
        this.preparePainting();
        Color c = this.getBackground();
        if (c.getAlpha() == 0 && (c = this.getColor()).getAlpha() == 0) {
            return;
        }
        Shape imclip = this.getClip();
        boolean newState = this.graphicsState.checkClip(imclip);
        if (newState) {
            this.currentStream.write("q\n");
            this.graphicsState.push();
            this.writeClip(imclip);
            this.graphicsState.setClip(imclip);
        }
        if (c.getAlpha() != 255) {
            HashMap<String, Float> vals = new HashMap<String, Float>();
            vals.put("ca", new Float((float)c.getAlpha() / 255.0f));
            PDFGState gstate = this.pdfDoc.getFactory().makeGState(vals, this.graphicsState.getGState());
            this.resourceContext.addGState(gstate);
            this.currentStream.write("/" + gstate.getName() + " gs\n");
        }
        if (this.graphicsState.setColor(c = this.getColor())) {
            this.applyColor(c, true);
        }
        if (this.graphicsState.setBackColor(c = this.getBackground())) {
            this.applyColor(c, false);
        }
        if (this.graphicsState.setPaint(paint = this.getPaint())) {
            this.applyPaint(paint, true);
        }
        PathIterator iter = s.getPathIterator(this.getTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " " + PDFNumber.doubleOut(vals[2], 5) + " " + PDFNumber.doubleOut(vals[3], 5) + " " + PDFNumber.doubleOut(vals[4], 5) + " " + PDFNumber.doubleOut(vals[5], 5) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 5) + " " + PDFNumber.doubleOut(vals[1], 5) + " " + PDFNumber.doubleOut(vals[2], 5) + " " + PDFNumber.doubleOut(vals[3], 5) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
        this.doDrawing(true, false, iter.getWindingRule() == 0);
        if (newState) {
            this.currentStream.write("Q\n");
            this.graphicsState.pop();
        }
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) {
        this.preparePainting();
        if (fill) {
            if (stroke) {
                if (nonzero) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (nonzero) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new PDFGraphicsConfiguration();
    }

    public FontMetrics getFontMetrics(java.awt.Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }
}

