/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

public class CharUtilities {
    public static final char CODE_EOT = '\u0000';
    public static final int UCWHITESPACE = 0;
    public static final int LINEFEED = 1;
    public static final int EOT = 2;
    public static final int NONWHITESPACE = 3;
    public static final int XMLWHITESPACE = 4;

    protected CharUtilities() {
        throw new UnsupportedOperationException();
    }

    public static int classOf(char c) {
        if (c == '\u0000') {
            return 2;
        }
        if (c == '\n') {
            return 1;
        }
        if (c == ' ' || c == '\r' || c == '\t') {
            return 4;
        }
        if (CharUtilities.isAnySpace(c)) {
            return 0;
        }
        return 3;
    }

    public static boolean isBreakableSpace(char c) {
        return c == ' ' || c >= '\u2000' && c <= '\u200b';
    }

    public static boolean isNonBreakableSpace(char c) {
        return c == '\u00a0' || c == '\u202f' || c == '\u3000' || c == '\ufeff';
    }

    public static boolean isAnySpace(char c) {
        boolean ret = CharUtilities.isBreakableSpace(c) || CharUtilities.isNonBreakableSpace(c);
        return ret;
    }
}

