/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SGraphClear;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.SGraphIdentify;
import com.insightful.gdevice.SGraphImage;
import com.insightful.gdevice.SGraphLines;
import com.insightful.gdevice.SGraphPoints;
import com.insightful.gdevice.SGraphPolygon;
import com.insightful.gdevice.SGraphSegments;
import com.insightful.gdevice.SGraphText;
import com.insightful.gdevice.SGraphicsDevice;
import com.insightful.splus.SplusSSLClientSocketFactory;
import com.insightful.splus.SplusSSLServerSocketFactory;
import com.insightful.splus.SplusSession;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Vector;

public class SGraphicsDeviceImplementation
extends UnicastRemoteObject
implements SGraphicsDevice {
    private int m_deviceNumber = 0;
    private SCanvas m_canvas = null;
    private Vector m_canvasList = new Vector();
    private ColorScheme m_colorScheme = null;
    private Dimension m_userSize = new Dimension(1024, 768);
    private HashMap m_mapAttributes = new HashMap();

    public SGraphicsDeviceImplementation(SCanvas sCanvas) throws RemoteException {
        this.addCanvas(sCanvas);
    }

    public SGraphicsDeviceImplementation(SCanvas sCanvas, SplusSession splusSession) throws RemoteException {
        super(0, new SplusSSLClientSocketFactory(), new SplusSSLServerSocketFactory(splusSession));
        this.addCanvas(sCanvas);
    }

    public void Clear() throws RemoteException {
        boolean bl = this.getAttribute("NewTopLevelExpression", 0.0f) != 0.0f;
        SGraphClear sGraphClear = new SGraphClear(bl);
        this.setCommonProperties(sGraphClear);
        this.sendGraphCommand(sGraphClear);
    }

    public void SetBackgroundColor() throws RemoteException {
        SGraphClear sGraphClear = new SGraphClear(false, true);
        this.setCommonProperties(sGraphClear);
        this.sendGraphCommand(sGraphClear);
    }

    public void Wrap() throws RemoteException {
        if (this.m_canvas != null) {
            this.m_canvas.wrap();
            this.removeCanvas(this.m_canvas);
        }
    }

    public float[][] ReadPen(int n) throws RemoteException {
        if (this.m_canvas != null) {
            SGraphClear sGraphClear = new SGraphClear(false);
            this.setCommonProperties(sGraphClear);
            float[][] fArray = this.m_canvas.readPen(n, sGraphClear);
            return fArray;
        }
        return null;
    }

    public void Lines(float[] fArray, float[] fArray2) throws RemoteException {
        SGraphLines sGraphLines = new SGraphLines(fArray, fArray2, (int)this.getAttribute("LineWidth", 1.0f), (int)this.getAttribute("LineDashType", 1.0f));
        this.setCommonProperties(sGraphLines);
        this.sendGraphCommand(sGraphLines);
    }

    public void Segments(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) throws RemoteException {
        SGraphSegments sGraphSegments = new SGraphSegments(fArray, fArray2, fArray3, fArray4, (int)this.getAttribute("LineWidth", 1.0f), (int)this.getAttribute("LineDashType", 1.0f));
        this.setCommonProperties(sGraphSegments);
        this.sendGraphCommand(sGraphSegments);
    }

    public void Polygon(float[] fArray, float[] fArray2) throws RemoteException {
        SGraphPolygon sGraphPolygon = new SGraphPolygon(fArray, fArray2);
        this.setCommonProperties(sGraphPolygon);
        this.sendGraphCommand(sGraphPolygon);
    }

    public void Points(float[] fArray, float[] fArray2) throws RemoteException {
        SGraphPoints sGraphPoints = new SGraphPoints(fArray, fArray2, (char)this.getAttribute("PlotCharacter", 1.0f), this.getAttribute("FontSize", 1.0f), this.getAttribute("SymbolSize", 1.0f), this.getAttribute("FontNumber", 1.0f));
        this.setCommonProperties(sGraphPoints);
        this.sendGraphCommand(sGraphPoints);
    }

    public void Text(float f, float f2, String string, float f3) throws RemoteException {
        float f4 = this.getAttribute("StringRotation", 0.0f);
        float f5 = this.getAttribute("FontSize", 1.0f);
        float f6 = this.getAttribute("FontNumber", 1.0f);
        SGraphText sGraphText = new SGraphText(string, f, f2, f4, f3, f5, f6);
        this.setCommonProperties(sGraphText);
        this.sendGraphCommand(sGraphText);
    }

    public void FloatImage(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2, float f3) throws RemoteException {
        SGraphImage sGraphImage = new SGraphImage(fArray, fArray2, fArray3, f, f2, f3);
        this.setCommonProperties(sGraphImage);
        this.sendGraphCommand(sGraphImage);
    }

    public void FloatImageRGBA(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2, float f3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws RemoteException {
        SGraphImage sGraphImage = new SGraphImage(fArray, fArray2, fArray3, f, f2, f3, byArray, byArray2, byArray3, byArray4);
        this.setCommonProperties(sGraphImage);
        this.sendGraphCommand(sGraphImage);
    }

    public void Hook(int n, float[] fArray, float[] fArray2) throws RemoteException {
    }

    public void Identify(String[] stringArray, String[] stringArray2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, boolean bl, boolean bl2) throws RemoteException {
        SGraphIdentify sGraphIdentify = new SGraphIdentify(fArray, fArray2, fArray3, fArray4, stringArray, stringArray2, bl, bl2);
        this.setCommonProperties(sGraphIdentify);
        this.sendGraphCommand(sGraphIdentify);
    }

    public void sendCommandVector(Vector vector) throws RemoteException {
        if (this.m_canvas != null) {
            this.m_canvas.add(vector);
        }
    }

    public void setPageTitle(String string) throws RemoteException {
        if (this.m_canvas != null) {
            this.m_canvas.setTitle(string);
        }
    }

    public void setPageTag(String string) throws RemoteException {
        if (this.m_canvas != null) {
            this.m_canvas.setTag(string);
        }
    }

    public String getPageTitle() throws RemoteException {
        return this.m_canvas != null ? this.m_canvas.getTitle() : "";
    }

    public String getPageTag() throws RemoteException {
        return this.m_canvas != null ? this.m_canvas.getTag() : "";
    }

    public String[] getSelectedTagArray() throws RemoteException {
        return this.m_canvas != null ? this.m_canvas.getSelectedTagArray() : new String[]{};
    }

    public void setSelectedTagArray(String[] stringArray) throws RemoteException {
        if (this.m_canvas != null) {
            this.m_canvas.setSelectedTagArray(stringArray);
        }
    }

    public int getDeviceNumber() throws RemoteException {
        return this.m_deviceNumber;
    }

    public void setDeviceNumber(int n) throws RemoteException {
        this.m_deviceNumber = n;
    }

    public void setAttributes(HashMap hashMap) throws RemoteException {
        this.m_mapAttributes = hashMap;
    }

    public SCanvas getCanvas() throws RemoteException {
        return this.m_canvas;
    }

    public void addCanvas(SCanvas sCanvas) throws RemoteException {
        this.m_canvas = sCanvas;
        if (sCanvas != null) {
            this.m_canvasList.addElement(sCanvas);
            this.m_canvas.setGraphicsDevice(this);
            this.m_canvas.setColorScheme(this.m_colorScheme);
            this.m_canvas.setUserSize(this.m_userSize);
        }
    }

    public void removeCanvas(SCanvas sCanvas) throws RemoteException {
        if (this.m_canvas == sCanvas) {
            this.m_canvas = null;
        }
        if (sCanvas != null) {
            sCanvas.setGraphicsDevice(null);
            this.m_canvasList.removeElement(sCanvas);
        }
    }

    public void setColorScheme(ColorScheme colorScheme) throws RemoteException {
        this.m_colorScheme = colorScheme;
        for (int i = 0; i < this.m_canvasList.size(); ++i) {
            SCanvas sCanvas = (SCanvas)this.m_canvasList.elementAt(i);
            sCanvas.setColorScheme(this.m_colorScheme);
        }
    }

    public ColorScheme getColorScheme() throws RemoteException {
        return this.m_colorScheme;
    }

    public void setColorScheme(String string, int[] nArray) throws RemoteException {
        this.setColorScheme(new ColorScheme(string, nArray));
    }

    public int[] getColorSchemeInts() throws RemoteException {
        return this.m_colorScheme == null ? null : this.m_colorScheme.getInts();
    }

    public String getColorSchemeName() throws RemoteException {
        return this.m_colorScheme == null ? "" : this.m_colorScheme.getName();
    }

    public void setUserSize(Dimension dimension) throws RemoteException {
        this.m_userSize = dimension;
        for (int i = 0; i < this.m_canvasList.size(); ++i) {
            SCanvas sCanvas = (SCanvas)this.m_canvasList.elementAt(i);
            sCanvas.setUserSize(this.m_userSize);
        }
    }

    public Dimension getUserSize() throws RemoteException {
        return this.m_userSize;
    }

    public int getNumberPages() throws RemoteException {
        return this.m_canvasList.size();
    }

    public String getPagePropertyAction(int n) throws RemoteException {
        SCanvas sCanvas = this.getCanvas(n);
        String string = sCanvas == null ? "" : sCanvas.getPropertyAction();
        return string == null ? "" : string;
    }

    public void setPagePropertyAction(int n, String string) throws RemoteException {
        SCanvas sCanvas = this.getCanvas(n);
        if (sCanvas != null) {
            sCanvas.setPropertyAction(string);
        }
    }

    private SCanvas getCanvas(int n) {
        return n < 1 || n > this.m_canvasList.size() ? this.m_canvas : (SCanvas)this.m_canvasList.elementAt(n - 1);
    }

    private void sendGraphCommand(SGraphCommand sGraphCommand) {
        if (this.m_canvas != null) {
            this.m_canvas.add(sGraphCommand);
        }
    }

    private void setCommonProperties(SGraphCommand sGraphCommand) {
        sGraphCommand.setCommonProperties(this.m_mapAttributes);
    }

    private float getAttribute(String string, float f) {
        Object v = this.m_mapAttributes.get(string.toLowerCase());
        if (v == null) {
            return f;
        }
        Float f2 = (Float)v;
        return f2.floatValue();
    }
}

