/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.controls.SplusWin32Tools;
import com.insightful.splus.ClientObjectFactory;
import com.insightful.splus.ClientUtilities;
import com.insightful.splus.ClientUtilitiesImpl;
import com.insightful.splus.FileInputStreamProxy;
import com.insightful.splus.FileInputStreamProxyImpl;
import com.insightful.splus.FileOutputStreamProxy;
import com.insightful.splus.FileOutputStreamProxyImpl;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusLicenseException;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusWinSession;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.util.StringUtilities;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Vector;

public class SplusWinSessionImpl
implements SplusWinSession {
    private ClientObjectFactory clientObjectFactory = null;
    private static SplusWinSessionImpl g_sessionInstance;
    private StringBuffer stdinBuffer = new StringBuffer();
    private Object g_buffer_lock = new Object();
    private SplusOutputHandler outputHandler;
    private static StringBuffer g_stdoutBuffer;
    private static boolean g_engineQuitFlag;
    private static final int PARSE_FAIL = -1;
    private static final int PARSE_NOTHING = 0;
    private static final int PARSE_ERROR = 1001;
    private static final int PARSE_COMPLETE = 1002;
    private static final int PARSE_INCOMPLETE = 1003;
    private static final int PARSE_CONTINSTR = 1004;
    private boolean g_prompt = true;
    private boolean m_doingEval = false;
    private boolean m_waitingForInteractiveInput = false;
    private static final int OUTPUT_BUFFER_BYTES = 5000;
    private static byte[] m_outputBuffer;
    private static int m_outputBufferLength;
    private static SplusOutputFlush m_splusOutputFlush;
    private static final boolean b_interactive_commandline;
    private static final boolean b_print_startup;
    private static final String CALLBACK_RESPONSE_IF_NOT_INTERACTIVE = "0;q\n";
    private static final String CALLBACK_MESSAGE_IF_NOT_INTERACTIVE = "\nInteractive text input not available.  Sending '0;q' to avoid blocking.\n";
    private Vector m_listeners = new Vector();

    private native int createEngineConnect(String[] var1);

    private native SplusDataResult createDataResult(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6);

    private static native String nativeCheckoutLicenseFeature(String var0);

    public static String checkoutLicenseFeature(String string) {
        return SplusWinSessionImpl.nativeCheckoutLicenseFeature(string);
    }

    private native void destroyEngineConnect();

    private native int parseTest(String var1);

    private synchronized native int syncParseEval(String var1);

    private int syncParseEvalFlush(String string) {
        int n = this.syncParseEval(string);
        try {
            SplusWinSessionImpl.flushOutputBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private native void requestOutput();

    private native void raiseInterrupt();

    public SplusWinSessionImpl(String[] stringArray) throws RemoteException, SplusLicenseException {
        int n;
        boolean bl;
        boolean bl2 = bl = System.getProperty("os.name", "unknown").toLowerCase().indexOf("windows") >= 0;
        if (g_sessionInstance != null) {
            throw new RuntimeException("S-PLUS engine already started.  Cannot create a new SplusWinSessionImpl");
        }
        if (stringArray == null || stringArray.length == 0) {
            String string = System.getProperty("splus.shome");
            stringArray = bl ? new String[]{"java.exe", "S_HOME=" + string} : new String[]{"java", "SHOME=" + string};
        }
        if ((n = this.createEngineConnect(this.getSessionSpecificArgs(stringArray))) == 0) {
            throw new RuntimeException("Cannot start S-PLUS engine");
        }
        if (bl) {
            this.writeSplusData("library(\"winjava\")\n");
        } else {
            this.writeSplusData("invisible(assign(\".useConnectCppJavaConnection\",T, frame=0))\ninvisible(library(\"spjava\"))\n");
        }
        g_sessionInstance = this;
    }

    public SplusWinSessionImpl() throws RemoteException, SplusLicenseException {
        this(new String[0]);
    }

    protected String[] getSessionSpecificArgs(String[] stringArray) {
        return stringArray;
    }

    public int parseSplusString(String string) {
        switch (this.parseTest(string)) {
            case 1003: {
                return 1003;
            }
            case 1004: {
                return 1004;
            }
            case -1: 
            case 1001: {
                return 1001;
            }
        }
        return 1002;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSplusIn(String string) throws RemoteException {
        Object object = this.g_buffer_lock;
        synchronized (object) {
            this.stdinBuffer.append(string);
            String string2 = this.stdinBuffer.toString();
            if (!this.m_doingEval) {
                switch (this.parseTest(string2)) {
                    case -1: {
                        this.fireEvent(999);
                        break;
                    }
                    case 0: {
                        this.fireEvent(1000);
                        break;
                    }
                    case 1001: {
                        this.stdinBuffer.delete(0, this.stdinBuffer.length() + 1);
                        this.fireEvent(1001);
                        break;
                    }
                    case 1002: {
                        boolean bl;
                        boolean bl2 = bl = string2.equals("q()\n") || string2.equals("exit()\n");
                        if (!b_interactive_commandline || bl) {
                            this.m_doingEval = true;
                            this.fireEvent(1);
                            if (bl) {
                                SplusWinSessionImpl.handleOutput("\n");
                            }
                            try {
                                this.syncParseEvalFlush(string2);
                            }
                            catch (Throwable throwable) {
                                try {
                                    SplusWinSessionImpl.handleOutput("java exception in syncParseEval: " + throwable + "\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.stdinBuffer.delete(0, this.stdinBuffer.length() + 1);
                            this.checkAndHandleQuit();
                            this.m_doingEval = false;
                            this.fireEvent(2);
                            if (!this.g_prompt) break;
                            SplusWinSessionImpl.handleOutput("> ");
                            break;
                        }
                        this.stdinBuffer.delete(0, this.stdinBuffer.length() + 1);
                        EvalThread evalThread = new EvalThread(string2);
                        evalThread.start();
                        break;
                    }
                    case 1003: {
                        if (this.g_prompt) {
                            SplusWinSessionImpl.handleOutput("+ ");
                        }
                        this.fireEvent(1003);
                        break;
                    }
                    case 1004: {
                        if (this.g_prompt) {
                            SplusWinSessionImpl.handleOutput("Continue String: ");
                        }
                        this.fireEvent(1004);
                        break;
                    }
                }
            }
        }
    }

    public void writeSplusData(String string) throws RemoteException {
        this.syncParseEvalFlush(string);
        this.checkAndHandleQuit();
    }

    public String readSplusOut() throws RemoteException {
        throw new UnsupportedOperationException("Method not supported.  Use startPollOutput() instead.");
    }

    public String readSplusErr() throws RemoteException {
        throw new UnsupportedOperationException("Method not supported.  Use startPollOutput() instead.");
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        if (this.m_doingEval) {
            throw new SplusEngineBusyException("Previous S-PLUS engine query has not been completed.");
        }
        if (string == null || string.length() == 0) {
            return new SplusDataResult(null, null, null, null);
        }
        if (!(string = StringUtilities.escapeSpecialCharacters(string)).endsWith("\n")) {
            string = string + "\n";
        }
        this.m_doingEval = true;
        this.fireEvent(1);
        SplusDataResult splusDataResult = this.createDataResult(string, bl, bl2, bl3, bl4, bl5);
        this.checkAndHandleQuit();
        this.m_doingEval = false;
        this.fireEvent(2);
        if (splusDataResult != null && splusDataResult.hasError() && splusDataResult.getError().startsWith("Problem in parse")) {
            throw new RemoteException("Incomplete expression.\nCheck for mismatched quotes or parentheses.");
        }
        if (splusDataResult == null) {
            splusDataResult = new SplusDataResult("", "Unknown problem executing expression (interrupt?)", string, null);
        }
        return splusDataResult;
    }

    public SplusDataResult evalDataQuery(String string) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false);
    }

    public SplusDataResult evalDataQuery(String string, int n) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false, n);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false);
    }

    public SplusDataResult evalDataQuery(String string, int n, boolean bl, boolean bl2) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false, n);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        int n2 = 0;
        int n3 = 1000 * n;
        while (this.m_doingEval) {
            try {
                Thread.currentThread();
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((n2 += 5) <= n3) continue;
            String string2 = "Query timed out (after " + Integer.toString(n) + " seconds) waiting for previous query to complete.";
            throw new SplusEngineBusyException(string2);
        }
        return this.evalDataQuery(string, bl, bl2, bl3, bl4, bl5);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, bl, bl2, bl3, bl4, bl5);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6, boolean bl7) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, n);
    }

    public void Interrupt() throws RemoteException {
        this.stdinBuffer.delete(0, this.stdinBuffer.length() + 1);
        this.raiseInterrupt();
    }

    public void setClientObjectFactory(ClientObjectFactory clientObjectFactory) throws RemoteException {
        this.clientObjectFactory = clientObjectFactory;
    }

    public static ClientObjectFactory getClientObjectFactory() {
        if (g_sessionInstance != null) {
            return SplusWinSessionImpl.g_sessionInstance.clientObjectFactory;
        }
        return null;
    }

    public FileInputStreamProxy getFileInputStream(String string) throws FileNotFoundException, RemoteException {
        return new FileInputStreamProxyImpl(string);
    }

    public FileOutputStreamProxy getFileOutputStream(String string) throws FileNotFoundException, RemoteException {
        return new FileOutputStreamProxyImpl(string);
    }

    public boolean isRemote() {
        return false;
    }

    public void sessionExit() {
        this.sessionExit(true);
    }

    public void sessionExit(boolean bl) {
        this.syncParseEvalFlush("q()");
        if (bl) {
            System.exit(0);
        }
    }

    public void startPollOutput(SplusOutputHandler splusOutputHandler) throws RemoteException {
        this.outputHandler = splusOutputHandler;
        if (g_stdoutBuffer != null && g_stdoutBuffer.length() > 0) {
            if (g_sessionInstance != null) {
                g_sessionInstance.fireEvent(10);
            }
            SplusWinSessionImpl.handleOutput(g_stdoutBuffer.toString());
            g_stdoutBuffer = null;
        }
        this.requestOutput();
        if (this.g_prompt) {
            SplusWinSessionImpl.handleOutput("> ");
        }
    }

    public void setPromptFlag(boolean bl) {
        this.g_prompt = bl;
    }

    private static void setQuitFlag(boolean bl) {
        g_engineQuitFlag = bl;
    }

    private void checkAndHandleQuit() {
        if (g_engineQuitFlag) {
            g_sessionInstance.fireEvent(31);
            this.destroyEngineConnect();
            g_sessionInstance.fireEvent(32);
            g_engineQuitFlag = false;
            g_sessionInstance = null;
        }
    }

    private static void handleOutput(String string) throws RemoteException {
        if (string != null) {
            SplusWinSessionImpl.addOutputToBuffer(null, 0, string);
        }
    }

    private static void handleOutput(byte[] byArray, int n) throws RemoteException {
        SplusWinSessionImpl.addOutputToBuffer(byArray, n, null);
    }

    private static void sendOutputToSessionInstance(String string) throws RemoteException {
        if (g_sessionInstance != null && SplusWinSessionImpl.g_sessionInstance.outputHandler != null) {
            g_sessionInstance.fireEvent(10);
            SplusWinSessionImpl.g_sessionInstance.outputHandler.write(string, false);
        } else if (b_interactive_commandline || b_print_startup) {
            if (g_stdoutBuffer == null) {
                g_stdoutBuffer = new StringBuffer();
            }
            g_stdoutBuffer.append(string);
        }
    }

    private static void sendOutputToSessionInstance(byte[] byArray, int n) throws RemoteException {
        if (byArray != null && n > 0) {
            try {
                String string = new String(byArray, 0, n, "UTF-8");
                SplusWinSessionImpl.sendOutputToSessionInstance(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SplusWinSessionImpl.sendOutputToSessionInstance(String.valueOf(unsupportedEncodingException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushOutputBuffer() throws RemoteException {
        byte[] byArray = m_outputBuffer;
        synchronized (m_outputBuffer) {
            SplusWinSessionImpl.sendOutputToSessionInstance(m_outputBuffer, m_outputBufferLength);
            m_outputBufferLength = 0;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addOutputToBuffer(byte[] byArray, int n, String string) throws RemoteException {
        byte[] byArray2 = m_outputBuffer;
        synchronized (m_outputBuffer) {
            if (string != null) {
                SplusWinSessionImpl.sendOutputToSessionInstance(m_outputBuffer, m_outputBufferLength);
                m_outputBufferLength = 0;
                SplusWinSessionImpl.sendOutputToSessionInstance(byArray, n);
                if (string.length() > 0) {
                    SplusWinSessionImpl.sendOutputToSessionInstance(string);
                }
                Thread.yield();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (byArray != null && n > 0) {
                if (m_outputBufferLength + n > 5000) {
                    SplusWinSessionImpl.sendOutputToSessionInstance(m_outputBuffer, m_outputBufferLength);
                    m_outputBufferLength = 0;
                    if (n > 5000) {
                        SplusWinSessionImpl.sendOutputToSessionInstance(byArray, n);
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
                System.arraycopy(byArray, 0, m_outputBuffer, m_outputBufferLength, n);
                m_outputBufferLength += n;
                if (m_splusOutputFlush == null) {
                    m_splusOutputFlush = new SplusOutputFlush();
                    m_splusOutputFlush.start();
                }
                m_splusOutputFlush.pokeFlush();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static String getPendingInput() {
        return g_sessionInstance.getPendingInputString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPendingInputString() {
        String string = CALLBACK_RESPONSE_IF_NOT_INTERACTIVE;
        if (!b_interactive_commandline) {
            try {
                SplusWinSessionImpl.handleOutput(CALLBACK_MESSAGE_IF_NOT_INTERACTIVE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.fireEvent(21);
            Object object = this.g_buffer_lock;
            synchronized (object) {
                string = this.stdinBuffer.toString();
                this.stdinBuffer.delete(0, this.stdinBuffer.length() + 1);
            }
            while (string.length() == 0) {
                try {
                    Thread.sleep(50L);
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                object = this.g_buffer_lock;
                synchronized (object) {
                    string = this.stdinBuffer.toString();
                    this.stdinBuffer.delete(0, this.stdinBuffer.length() + 1);
                    this.m_waitingForInteractiveInput = string.length() == 0;
                }
            }
            this.fireEvent(22);
        }
        return string;
    }

    public String getCertFilename() throws RemoteException {
        return null;
    }

    public char[] getCertAccess() throws RemoteException {
        return null;
    }

    public ClientUtilities getClientUtilities() throws RemoteException {
        return new ClientUtilitiesImpl();
    }

    public static native boolean isWindowsGUILoaded();

    public static native boolean isWindowsGUIClosing();

    public static native void setExecutingScriptThreaded(boolean var0);

    public static native void setDialogRegister(int var0, boolean var1);

    public static native void setDialogActivated(int var0, boolean var1);

    public void addListener(SplusWinSessionListener splusWinSessionListener) {
        this.m_listeners.add(splusWinSessionListener);
    }

    public void removeListener(SplusWinSessionListener splusWinSessionListener) {
        this.m_listeners.remove(splusWinSessionListener);
    }

    private void fireEvent(int n) {
        SplusWinSessionEvent splusWinSessionEvent = new SplusWinSessionEvent(n);
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            try {
                ((SplusWinSessionListener)this.m_listeners.get(i)).eventOccurred(splusWinSessionEvent);
                continue;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    static {
        g_stdoutBuffer = null;
        g_engineQuitFlag = false;
        if (System.getProperty("os.name", "unknown").toLowerCase().indexOf("windows") >= 0) {
            String string = System.getProperty("splus.shome");
            if (string == null) {
                throw new RuntimeException("Java system property 'splus.shome' not set.  This must be set to the directory containing S-PLUS.");
            }
            String[] stringArray = new String[]{"SpPosix.dll", "stadev32.dll", "Szlib1.dll", "zlib1.dll", "iconv.dll", "libxml2.dll", "statrn32.dll", "stodbc32.dll", "SpLaPack.dll", "Sqpe.dll", "sconnect.dll", "Spl.dll", "SapiObj.dll"};
            for (int i = 0; i < stringArray.length; ++i) {
                System.load(string + "/cmd/" + stringArray[i]);
            }
            System.load(string + "/library/winjava/Swinjava.dll");
            SplusWin32Tools.putenv("SHOME", string);
            SplusWin32Tools.putenv("S_HOME", string);
            String string2 = SplusWin32Tools.getenv("PATH");
            string2 = string + "/cmd" + ";" + string2;
            SplusWin32Tools.putenv("PATH", string2);
        } else {
            boolean bl = System.getProperty("os.name", "unknown").toLowerCase().indexOf("hp") != -1;
            String string = System.getProperty("splus.shome");
            String string3 = bl ? ".sl" : ".so";
            String[] stringArray = new String[]{"libSplJava"};
            for (int i = 0; i < stringArray.length; ++i) {
                System.load(string + "/newfun/lib/" + stringArray[i] + string3);
            }
        }
        m_outputBuffer = new byte[5000];
        m_outputBufferLength = 0;
        m_splusOutputFlush = null;
        b_interactive_commandline = System.getProperty("splus.interactive.commandline", "F").toUpperCase().startsWith("T");
        b_print_startup = System.getProperty("splus.print.startup", "F").toUpperCase().startsWith("T");
    }

    private class EvalThread
    extends Thread {
        String str = "";

        public EvalThread(String string) {
            this.str = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SplusWinSessionImpl.this.m_doingEval = true;
            SplusWinSessionImpl.this.fireEvent(1);
            do {
                try {
                    SplusWinSessionImpl.this.syncParseEvalFlush(this.str);
                }
                catch (Throwable throwable) {
                    try {
                        SplusWinSessionImpl.handleOutput("java exception in syncParseEval: " + throwable + "\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (SplusWinSessionImpl.this.g_prompt) {
                        SplusWinSessionImpl.handleOutput("> ");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object object = SplusWinSessionImpl.this.g_buffer_lock;
                synchronized (object) {
                    this.str = SplusWinSessionImpl.this.stdinBuffer.toString();
                    SplusWinSessionImpl.this.stdinBuffer.delete(0, SplusWinSessionImpl.this.stdinBuffer.length() + 1);
                }
            } while (this.str.length() > 0);
            SplusWinSessionImpl.this.checkAndHandleQuit();
            SplusWinSessionImpl.this.m_doingEval = false;
            SplusWinSessionImpl.this.fireEvent(2);
        }
    }

    private static class SplusOutputFlush
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pokeFlush() {
            SplusOutputFlush splusOutputFlush = this;
            synchronized (splusOutputFlush) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            SplusOutputFlush splusOutputFlush = this;
            // MONITORENTER : splusOutputFlush
            this.setPriority(1);
            this.setName("SplusOutputFlush");
            // MONITOREXIT : splusOutputFlush
            while (true) {
                boolean bl = false;
                Object object = m_outputBuffer;
                // MONITORENTER : object
                if (m_outputBufferLength > 0) {
                    bl = true;
                    try {
                        int n = m_outputBufferLength;
                        m_outputBufferLength = 0;
                        SplusWinSessionImpl.sendOutputToSessionInstance(m_outputBuffer, n);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : object
                try {
                    if (!bl) {
                        SplusOutputFlush splusOutputFlush2 = this;
                        object = splusOutputFlush2;
                        // MONITORENTER : splusOutputFlush2
                        this.wait();
                        // MONITOREXIT : object
                    }
                    SplusOutputFlush.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

