/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.SubsetBuilderDialog;
import com.insightful.splus.statdlg.SurvivalFormulaDialog;
import com.insightful.splus.statdlg.TruncationFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class LifeTestingDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox weightsColumn;
    SplusSubsetField subsetRows;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;
    SplusButton subsetButton;
    SplusButton truncButton;
    SplusComboBox threshMethod;
    SplusTextField threshValue;
    SplusTextField truncField;
    SplusCheckBox plotProbFailure;
    SplusCheckBox plotStress;
    SplusCheckBox probMaxLik;
    SplusCheckBox probLegend;
    SplusCheckBox probGrid;
    SplusCheckBox stressLegend;
    SplusCheckBox stressJitter;
    SplusCheckBox predictSaveProbs;
    SplusCheckBox predictSaveResp;
    SplusComboBox probMethod;
    SplusTextField probBands;
    SplusTextField probCoverage;
    SplusTextField stressProbs;
    SplusTextField predictProbValues;
    SplusTextField predictProbConfLevel;
    SplusTextField predictRespValues;
    SplusTextField predictRespConfLevel;
    SplusTextField probPlotAt;

    public LifeTestingDialog() {
        super("Life Testing");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuCensorReg");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        this.subsetRows = new SplusSubsetField();
        splusGroupPanel.add(this.subsetRows);
        splusFunctionInfo.add(this.subsetRows, "subset");
        this.subsetButton = new SplusButton("Create Subset", 'B');
        this.subsetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SubsetBuilderDialog(LifeTestingDialog.this.subsetRows, LifeTestingDialog.this.dataSet).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.subsetButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel.add(Box.createVerticalStrut(5));
        splusGroupPanel.add(box5);
        splusGroupPanel.add(Box.createVerticalStrut(5));
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Threshold Parameter");
        box3.add(splusGroupPanel2);
        this.threshMethod = new SplusComboBox("Methods", 'T', new String[]{"Value", "Linearized-qq"});
        this.threshMethod.setEditable(false);
        this.threshMethod.setValue("Value");
        splusGroupPanel2.add(this.threshMethod);
        splusFunctionInfo.add(this.threshMethod, "threshold", true);
        this.threshValue = new SplusTextField("Value", 'V');
        this.threshValue.setValue("0");
        splusGroupPanel2.add(this.threshValue);
        splusFunctionInfo.add(this.threshValue, "threshold.value");
        this.threshMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LifeTestingDialog.this.threshValue.setEnabled(LifeTestingDialog.this.threshMethod.getValue().equals("Value"));
            }
        });
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Model");
        box4.add(splusGroupPanel3);
        SplusComboBox splusComboBox = new SplusComboBox("Distribution", 'I', new String[]{"Extreme", "Weibull", "Normal(gaussian)", "Lognormal", "Logistic", "Loglogistic", "Exponential", "Logexponential", "Rayleigh", "Lograyleigh"});
        splusComboBox.setValue("Weibull");
        splusComboBox.setEditable(false);
        splusGroupPanel3.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "distribution", true);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Truncation");
        box4.add(splusGroupPanel4);
        this.truncField = new SplusTextField("Formula", 'F');
        splusGroupPanel4.add(this.truncField);
        splusFunctionInfo.add(this.truncField, "truncation");
        this.truncButton = new SplusButton("Create Formula", 'C');
        this.truncButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new TruncationFormulaDialog(LifeTestingDialog.this.truncField, LifeTestingDialog.this.dataSet).show();
            }
        });
        Box box6 = new Box(0);
        box6.add(Box.createHorizontalStrut(5));
        box6.add(this.truncButton);
        box6.add(Box.createHorizontalGlue());
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        splusGroupPanel4.add(box6);
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel5);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel5.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        box4.add(new SplusBoxFiller(5));
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Formula");
        box2.add(splusGroupPanel6);
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel6.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SurvivalFormulaDialog(LifeTestingDialog.this.formulaField, LifeTestingDialog.this.dataSet, 4).show();
            }
        });
        Box box7 = new Box(0);
        box7.add(Box.createHorizontalStrut(5));
        box7.add(this.formulaButton);
        box7.add(Box.createHorizontalGlue());
        splusGroupPanel6.add(Box.createVerticalStrut(5));
        splusGroupPanel6.add(box7);
        splusGroupPanel6.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box8);
        jPanel2.add(box9);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Optimization Parameters");
        box8.add(splusGroupPanel7);
        SplusTextField splusTextField2 = new SplusTextField("Convergence Tolerance", 'T');
        splusTextField2.setValue("0.0001");
        splusGroupPanel7.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "eps");
        SplusTextField splusTextField3 = new SplusTextField("Max Iterations", 'I');
        splusTextField3.setValue("500");
        splusGroupPanel7.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "iter.max");
        box8.add(new SplusBoxFiller());
        box9.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box10);
        jPanel3.add(box11);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Printed Results");
        box10.add(splusGroupPanel8);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel8.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.short");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Long Output", 'L');
        splusCheckBox3.setValue("T");
        splusGroupPanel8.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.long");
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Saved Results");
        box11.add(splusGroupPanel9);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel9.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.name", true);
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel9.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "save.fit.p");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Standardized Residuals", 'T');
        splusGroupPanel9.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "save.resid.p");
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Deviance Residuals", 'D');
        splusGroupPanel9.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "save.resid.deviance.p");
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Pearson Residuals", 'P');
        splusGroupPanel9.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "save.resid.pearson.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Response Residuals", 'R');
        splusGroupPanel9.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "save.resid.response.p");
        box11.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box12 = new Box(1);
        Box box13 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box12);
        jPanel4.add(box13);
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Plots");
        box12.add(splusGroupPanel10);
        this.plotProbFailure = new SplusCheckBox("Probability Plot of Failure Time", 'Y');
        splusGroupPanel10.add(this.plotProbFailure);
        splusFunctionInfo.add(this.plotProbFailure, "plotQQ.p");
        this.plotStress = new SplusCheckBox("Stress vs Failure Time", 'S');
        splusGroupPanel10.add(this.plotStress);
        splusFunctionInfo.add(this.plotStress, "plotSN.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Six Distributions Plot", 'X');
        splusGroupPanel10.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "plotSixDistributions.p");
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel10.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel10.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel10.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Probability Plot of Residuals", 'U');
        splusGroupPanel10.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "plotProbVsResid.p");
        box12.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("Probability Plot Options");
        box13.add(splusGroupPanel11);
        this.probMaxLik = new SplusCheckBox("Add Maximum Likelihood Estimate", 'K');
        this.probMaxLik.setValue("T");
        this.probMaxLik.setEnabled(false);
        splusGroupPanel11.add(this.probMaxLik);
        splusFunctionInfo.add(this.probMaxLik, "mle");
        this.probLegend = new SplusCheckBox("Add Legend", 'E');
        this.probLegend.setValue("T");
        this.probLegend.setEnabled(false);
        splusGroupPanel11.add(this.probLegend);
        splusFunctionInfo.add(this.probLegend, "qqplot.add.legend");
        this.probGrid = new SplusCheckBox("Add Grid Lines", 'G');
        this.probGrid.setEnabled(false);
        splusGroupPanel11.add(this.probGrid);
        splusFunctionInfo.add(this.probGrid, "grid");
        this.probMethod = new SplusComboBox("Plot Method", 'D', new String[]{"km", "separate", "factor", "regression", "one", "none"});
        this.probMethod.setValue("km");
        this.probMethod.setEditable(false);
        this.probMethod.setEnabled(false);
        splusGroupPanel11.add(this.probMethod);
        splusFunctionInfo.add(this.probMethod, "probplot.method", true);
        this.probBands = new SplusTextField("Confidence Bands", 'N');
        this.probBands.setEnabled(false);
        splusGroupPanel11.add(this.probBands);
        splusFunctionInfo.add(this.probBands, "mle.interval");
        this.probPlotAt = new SplusTextField("Plot At", 'T');
        this.probPlotAt.setEnabled(false);
        splusGroupPanel11.add(this.probPlotAt);
        splusFunctionInfo.add(this.probPlotAt, "plotat", true);
        this.probCoverage = new SplusTextField("Coverage", 'V');
        this.probCoverage.setValue("0.95");
        this.probCoverage.setEnabled(false);
        splusGroupPanel11.add(this.probCoverage);
        splusFunctionInfo.add(this.probCoverage, "coverage");
        this.plotProbFailure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LifeTestingDialog.this.plotProbFailure.getValue().equals("T");
                LifeTestingDialog.this.probMaxLik.setEnabled(bl);
                LifeTestingDialog.this.probLegend.setEnabled(bl);
                LifeTestingDialog.this.probGrid.setEnabled(bl);
                LifeTestingDialog.this.probMethod.setEnabled(bl);
                LifeTestingDialog.this.probBands.setEnabled(bl);
                LifeTestingDialog.this.probPlotAt.setEnabled(bl);
                LifeTestingDialog.this.probCoverage.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("Stress Plot Options");
        box13.add(splusGroupPanel12);
        this.stressLegend = new SplusCheckBox("Add Legend", 'D');
        this.stressLegend.setValue("T");
        this.stressLegend.setEnabled(false);
        splusGroupPanel12.add(this.stressLegend);
        splusFunctionInfo.add(this.stressLegend, "snplot.add.legend");
        this.stressJitter = new SplusCheckBox("Jitter Data", 'J');
        this.stressJitter.setEnabled(false);
        splusGroupPanel12.add(this.stressJitter);
        splusFunctionInfo.add(this.stressJitter, "jitter");
        this.stressProbs = new SplusTextField("Failure Probabilities", 'F');
        this.stressProbs.setValue("0.01,0.05,0.1,0.5");
        this.stressProbs.setEnabled(false);
        splusGroupPanel12.add(this.stressProbs);
        splusFunctionInfo.add(this.stressProbs, "reliabilities", true);
        this.plotStress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LifeTestingDialog.this.plotStress.getValue().equals("T");
                LifeTestingDialog.this.stressLegend.setEnabled(bl);
                LifeTestingDialog.this.stressJitter.setEnabled(bl);
                LifeTestingDialog.this.stressProbs.setEnabled(bl);
            }
        });
        box13.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        jTabbedPane.addTab("Predict", jPanel5);
        Box box14 = new Box(1);
        Box box15 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box14);
        jPanel5.add(box15);
        SplusGroupPanel splusGroupPanel13 = new SplusGroupPanel("");
        box14.add(splusGroupPanel13);
        SplusDataSetComboBox splusDataSetComboBox2 = new SplusDataSetComboBox("New Data", 'N');
        splusDataSetComboBox2.setValue("");
        splusGroupPanel13.add(splusDataSetComboBox2);
        splusFunctionInfo.add(splusDataSetComboBox2, "X");
        SplusGroupPanel splusGroupPanel14 = new SplusGroupPanel("Save");
        box14.add(splusGroupPanel14);
        SplusDataSetComboBox splusDataSetComboBox3 = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox3.setValue("");
        splusGroupPanel14.add(splusDataSetComboBox3);
        splusFunctionInfo.add(splusDataSetComboBox3, "predictsavein", true);
        this.predictSaveProbs = new SplusCheckBox("Probabilities", 'P');
        splusGroupPanel14.add(this.predictSaveProbs);
        splusFunctionInfo.add(this.predictSaveProbs, "predictreliability");
        this.predictSaveResp = new SplusCheckBox("Response", 'R');
        splusGroupPanel14.add(this.predictSaveResp);
        splusFunctionInfo.add(this.predictSaveProbs, "predictlifetime");
        SplusGroupPanel splusGroupPanel15 = new SplusGroupPanel("");
        box14.add(splusGroupPanel15);
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Print Results", 'P');
        splusGroupPanel15.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "predictprint");
        box14.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel16 = new SplusGroupPanel("Probability Options");
        box15.add(splusGroupPanel16);
        this.predictProbValues = new SplusTextField("Response Values", 'V');
        this.predictProbValues.setEnabled(false);
        splusGroupPanel16.add(this.predictProbValues);
        splusFunctionInfo.add(this.predictProbValues, "atlifetime", true);
        this.predictProbConfLevel = new SplusTextField("Confidence Level", 'F');
        this.predictProbConfLevel.setValue("0.95");
        this.predictProbConfLevel.setEnabled(false);
        splusGroupPanel16.add(this.predictProbConfLevel);
        splusFunctionInfo.add(this.predictProbConfLevel, "rcover");
        this.predictSaveProbs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LifeTestingDialog.this.predictSaveProbs.getValue().equals("T");
                LifeTestingDialog.this.predictProbValues.setEnabled(bl);
                LifeTestingDialog.this.predictProbConfLevel.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel17 = new SplusGroupPanel("Response Options");
        box15.add(splusGroupPanel17);
        this.predictRespValues = new SplusTextField("Probability Values", 'V');
        this.predictRespValues.setValue("0.1, 0.5, 0.9");
        this.predictRespValues.setEnabled(false);
        splusGroupPanel17.add(this.predictRespValues);
        splusFunctionInfo.add(this.predictRespValues, "at.reliability", true);
        this.predictRespConfLevel = new SplusTextField("Confidence Level", 'F');
        this.predictRespConfLevel.setValue("0.95");
        this.predictRespConfLevel.setEnabled(false);
        splusGroupPanel17.add(this.predictRespConfLevel);
        splusFunctionInfo.add(this.predictRespConfLevel, "lcover");
        this.predictSaveResp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LifeTestingDialog.this.predictSaveResp.getValue().equals("T");
                LifeTestingDialog.this.predictRespValues.setEnabled(bl);
                LifeTestingDialog.this.predictRespConfLevel.setEnabled(bl);
            }
        });
        box15.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }
}

