/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RobustMMRegressionDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox weightsColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;
    SplusComboBox estimator;
    SplusComboBox finalLoss;
    SplusComboBox resampAlg;
    SplusTextField efficiency;
    SplusTextField infConfLevel;
    SplusTextField popSize;
    SplusTextField ranSamp;
    SplusTextField maxObs;
    SplusTextField births;
    SplusTextField mutationProb;
    SplusTextField stocks;
    SplusTextField stockProb;
    SplusTextField subsamp;
    SplusTextField seed;
    SplusCheckBox longOutput;
    SplusCheckBox correlationMatrix;

    public RobustMMRegressionDialog() {
        super("Robust MM Linear Regression");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuLmRobMM");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        box4.add(new SplusBoxFiller(3));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel2);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Variables");
        box2.add(splusGroupPanel3);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel3.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel3.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel3.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RobustMMRegressionDialog.this.formulaField.setDependentValue(RobustMMRegressionDialog.this.dependentColumn.getValue());
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RobustMMRegressionDialog.this.formulaField.setIndependentValue(RobustMMRegressionDialog.this.independentColumnList.getValue());
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(RobustMMRegressionDialog.this.formulaField, RobustMMRegressionDialog.this.dataSet, 2).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.formulaButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box5);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box6);
        jPanel2.add(box7);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Estimation Method");
        box6.add(splusGroupPanel4);
        this.estimator = new SplusComboBox("Estimator", 'E', new String[]{"Test Based", "Initial Robust", "Final Robust"});
        this.estimator.setValue("Test Based");
        this.estimator.setEditable(false);
        splusGroupPanel4.add(this.estimator);
        splusFunctionInfo.add(this.estimator, "estimates.p", true);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Loss Functions");
        box6.add(splusGroupPanel5);
        SplusComboBox splusComboBox = new SplusComboBox("Initial Robust", 'I', new String[]{"Optimal", "Bisquare"});
        splusComboBox.setValue("Optimal");
        splusComboBox.setEditable(false);
        splusGroupPanel5.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "weight1.p", true);
        this.finalLoss = new SplusComboBox("Final Robust", 'I', new String[]{"Optimal", "Bisquare"});
        this.finalLoss.setValue("Optimal");
        this.finalLoss.setEditable(false);
        splusGroupPanel5.add(this.finalLoss);
        splusFunctionInfo.add(this.finalLoss, "weight2.p", true);
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Inference");
        box6.add(splusGroupPanel6);
        this.efficiency = new SplusTextField("Efficiency", 'E');
        this.efficiency.setValue("0.85");
        splusGroupPanel6.add(this.efficiency);
        splusFunctionInfo.add(this.efficiency, "eff.p");
        this.infConfLevel = new SplusTextField("Confidence Level", 'L');
        this.infConfLevel.setValue("0.10");
        splusGroupPanel6.add(this.infConfLevel);
        splusFunctionInfo.add(this.infConfLevel, "level.p");
        this.estimator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !RobustMMRegressionDialog.this.estimator.getValue().equals("Initial Robust");
                RobustMMRegressionDialog.this.efficiency.setEnabled(bl);
                RobustMMRegressionDialog.this.infConfLevel.setEnabled(bl);
                RobustMMRegressionDialog.this.finalLoss.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Optimization");
        box6.add(splusGroupPanel7);
        SplusTextField splusTextField2 = new SplusTextField("Max. Iterations", 'I');
        splusTextField2.setValue("Auto");
        splusGroupPanel7.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "mxi.p", true);
        SplusTextField splusTextField3 = new SplusTextField("Tolerance", 'T');
        splusTextField3.setValue("Auto");
        splusGroupPanel7.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "tol.p", true);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Resampling");
        box6.add(splusGroupPanel8);
        this.resampAlg = new SplusComboBox("Algorithm", 'A', new String[]{"Auto", "Exhaustive", "Genetic", "Random"});
        this.resampAlg.setValue("Auto");
        this.resampAlg.setEditable(false);
        splusGroupPanel8.add(this.resampAlg);
        splusFunctionInfo.add(this.resampAlg, "sampling.p", true);
        box6.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Genetic Algorithm");
        box7.add(splusGroupPanel9);
        this.popSize = new SplusTextField("Population Size", 'Z');
        this.popSize.setValue("Auto");
        this.popSize.setEnabled(false);
        splusGroupPanel9.add(this.popSize);
        splusFunctionInfo.add(this.popSize, "popsize.p", true);
        this.ranSamp = new SplusTextField("Random Samples", 'O');
        this.ranSamp.setValue("Auto");
        this.ranSamp.setEnabled(false);
        splusGroupPanel9.add(this.ranSamp);
        splusFunctionInfo.add(this.ranSamp, "randomn.p", true);
        this.maxObs = new SplusTextField("Max Observations", 'X');
        this.maxObs.setValue("Auto");
        this.maxObs.setEnabled(false);
        splusGroupPanel9.add(this.maxObs);
        splusFunctionInfo.add(this.maxObs, "maxslen.p", true);
        this.births = new SplusTextField("Genetic Births", 'B');
        this.births.setValue("Auto");
        this.births.setEnabled(false);
        splusGroupPanel9.add(this.births);
        splusFunctionInfo.add(this.births, "births.p", true);
        this.mutationProb = new SplusTextField("Mutation Prob.", 'P');
        this.mutationProb.setValue("Auto");
        this.mutationProb.setEnabled(false);
        splusGroupPanel9.add(this.mutationProb);
        splusFunctionInfo.add(this.mutationProb, "mprob.p", true);
        this.stocks = new SplusTextField("Stocks", 'K');
        this.stocks.setValue("Auto");
        this.stocks.setEnabled(false);
        splusGroupPanel9.add(this.stocks);
        splusFunctionInfo.add(this.stocks, "stock.p", true);
        this.stockProb = new SplusTextField("Stock Prob", 'T');
        this.stockProb.setValue("Auto");
        this.stockProb.setEnabled(false);
        splusGroupPanel9.add(this.stockProb);
        splusFunctionInfo.add(this.stockProb, "stockp.p", true);
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Random Resampling");
        box7.add(splusGroupPanel10);
        this.subsamp = new SplusTextField("Subsamples", 'U');
        this.subsamp.setValue("Auto");
        this.subsamp.setEnabled(false);
        splusGroupPanel10.add(this.subsamp);
        splusFunctionInfo.add(this.subsamp, "nrep.p", true);
        this.seed = new SplusTextField("Random Seed", 'D');
        this.seed.setValue("1313");
        this.seed.setEnabled(false);
        splusGroupPanel10.add(this.seed);
        splusFunctionInfo.add(this.seed, "seed.p");
        this.resampAlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = RobustMMRegressionDialog.this.resampAlg.getValue();
                boolean bl = string.equals("Genetic");
                boolean bl2 = string.equals("Random");
                RobustMMRegressionDialog.this.popSize.setEnabled(bl);
                RobustMMRegressionDialog.this.ranSamp.setEnabled(bl);
                RobustMMRegressionDialog.this.maxObs.setEnabled(bl);
                RobustMMRegressionDialog.this.births.setEnabled(bl);
                RobustMMRegressionDialog.this.mutationProb.setEnabled(bl);
                RobustMMRegressionDialog.this.stocks.setEnabled(bl);
                RobustMMRegressionDialog.this.stockProb.setEnabled(bl);
                RobustMMRegressionDialog.this.subsamp.setEnabled(bl2);
                RobustMMRegressionDialog.this.seed.setEnabled(bl2);
            }
        });
        box7.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box8);
        jPanel3.add(box9);
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("Printed Results");
        box8.add(splusGroupPanel11);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel11.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.short.p");
        this.longOutput = new SplusCheckBox("Long Output", 'L');
        this.longOutput.setValue("T");
        splusGroupPanel11.add(this.longOutput);
        splusFunctionInfo.add(this.longOutput, "print.long.p");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("ANOVA Table", 'A');
        splusGroupPanel11.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.anova.p");
        this.correlationMatrix = new SplusCheckBox("Correlation Matrix of Estimates", 'C');
        splusGroupPanel11.add(this.correlationMatrix);
        splusFunctionInfo.add(this.correlationMatrix, "print.correlation.p");
        this.longOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RobustMMRegressionDialog.this.correlationMatrix.setEnabled(RobustMMRegressionDialog.this.longOutput.getValue().equals("T"));
            }
        });
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Comparison with LS Fit", 'F');
        splusGroupPanel11.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "print.cmpr.p");
        box8.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("Saved Results");
        box9.add(splusGroupPanel12);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel12.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.name", true);
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel12.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "save.fit.p");
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Residuals", 'R');
        splusGroupPanel12.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "save.resid.p");
        box9.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box10);
        jPanel4.add(box11);
        SplusGroupPanel splusGroupPanel13 = new SplusGroupPanel("Plots");
        box10.add(splusGroupPanel13);
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel13.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel13.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel13.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel13.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotQQ.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Residual-Fit Spread", 'S');
        splusGroupPanel13.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotRFSpread.p");
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel14 = new SplusGroupPanel("Options");
        box11.add(splusGroupPanel14);
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Include Smooth", 'M');
        splusCheckBox12.setValue("T");
        splusGroupPanel14.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "smooths.p");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Include Rugplot", 'G');
        splusGroupPanel14.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "rugplot.p");
        SplusTextField splusTextField4 = new SplusTextField("Number of Extreme Points to Identify:", 'X');
        splusTextField4.setValue("3");
        splusGroupPanel14.add(splusTextField4);
        splusFunctionInfo.add(splusTextField4, "id.n");
        SplusGroupPanel splusGroupPanel15 = new SplusGroupPanel("Comparison Plots with LS Fit");
        box11.add(splusGroupPanel15);
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Residuals Normal QQ", 'E');
        splusGroupPanel15.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "plotRQQ.p");
        SplusCheckBox splusCheckBox15 = new SplusCheckBox("Compare Residual Densities", 'D');
        splusGroupPanel15.add(splusCheckBox15);
        splusFunctionInfo.add(splusCheckBox15, "plotRDensity.p");
        SplusCheckBox splusCheckBox16 = new SplusCheckBox("Residuals vs Fit", 'I');
        splusGroupPanel15.add(splusCheckBox16);
        splusFunctionInfo.add(splusCheckBox16, "plotRResid.p");
        SplusCheckBox splusCheckBox17 = new SplusCheckBox("Response vs Fit", 'F');
        splusGroupPanel15.add(splusCheckBox17);
        splusFunctionInfo.add(splusCheckBox17, "plotRResp.p");
        box11.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        jTabbedPane.addTab("Predict", jPanel5);
        Box box12 = new Box(1);
        Box box13 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box12);
        jPanel5.add(box13);
        SplusGroupPanel splusGroupPanel16 = new SplusGroupPanel("");
        box12.add(splusGroupPanel16);
        SplusDataSetComboBox splusDataSetComboBox2 = new SplusDataSetComboBox("New Data", 'N');
        splusDataSetComboBox2.setValue("");
        splusGroupPanel16.add(splusDataSetComboBox2);
        splusFunctionInfo.add(splusDataSetComboBox2, "newdata");
        SplusGroupPanel splusGroupPanel17 = new SplusGroupPanel("Save");
        box12.add(splusGroupPanel17);
        SplusDataSetComboBox splusDataSetComboBox3 = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox3.setValue("");
        splusGroupPanel17.add(splusDataSetComboBox3);
        splusFunctionInfo.add(splusDataSetComboBox3, "predobj.name", true);
        SplusCheckBox splusCheckBox18 = new SplusCheckBox("Predictions", 'P');
        splusGroupPanel17.add(splusCheckBox18);
        splusFunctionInfo.add(splusCheckBox18, "predict.p");
        SplusCheckBox splusCheckBox19 = new SplusCheckBox("Confidence Intervals", 'C');
        splusGroupPanel17.add(splusCheckBox19);
        splusFunctionInfo.add(splusCheckBox19, "ci.p");
        SplusCheckBox splusCheckBox20 = new SplusCheckBox("Standard Errors", 'S');
        splusGroupPanel17.add(splusCheckBox20);
        splusFunctionInfo.add(splusCheckBox20, "se.p");
        box12.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel18 = new SplusGroupPanel("Options");
        box13.add(splusGroupPanel18);
        SplusTextField splusTextField5 = new SplusTextField("Confidence Level", 'L');
        splusTextField5.setValue("0.95");
        splusGroupPanel18.add(splusTextField5);
        splusFunctionInfo.add(splusTextField5, "conf.level");
        box13.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }
}

