/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusWin32Tools;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.util.ClassUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class SplusDialog
extends JDialog
implements WindowListener {
    public static final String OK_ACTION_CMD = "OK";
    public static final String CANCEL_ACTION_CMD = "Cancel";
    public static final String HELP_ACTION_CMD = "Help";
    public static final String APPLY_ACTION_CMD = "Apply";
    JPanel buttonPanel;
    ButtonListener buttonListener;
    LocalButton okButton;
    LocalButton cancelButton;
    LocalButton applyButton;
    LocalButton helpButton;
    Vector closeListeners = new Vector();
    SplusFunctionInfo funcInfo = new SplusFunctionInfo();
    private static final Dimension labelDimension = SplusControlMetrics.getLabelDimension();
    private static final Dimension fullDimension = SplusControlMetrics.getFullDimension();
    private static final int buttonHeight = SplusDialog.labelDimension.height;
    private static final int buttonWidth = (int)((double)SplusDialog.labelDimension.width * 0.75);
    private static final Dimension buttonDimension = new Dimension(buttonWidth, buttonHeight);
    private static final int buttonPanelHeight = buttonHeight + 15;
    private static final int buttonPanelWidth = SplusDialog.fullDimension.width * 2 + 15;
    private static final Dimension buttonPanelDimension = new Dimension(buttonPanelWidth, buttonPanelHeight);
    private int m_hwnd = 0;

    public SplusDialog() {
        this(SplusSystem.getDefaultFrame(), "");
    }

    public SplusDialog(String string) {
        this(SplusSystem.getDefaultFrame(), string);
    }

    public SplusDialog(Frame frame, String string) {
        super(frame, string);
        if (SplusSystem.getEngineQueryHandler() != null) {
            SplusDataSetComboBox.updateDataSetList();
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setPreferredSize(buttonPanelDimension);
        this.buttonPanel.setMinimumSize(buttonPanelDimension);
        this.buttonListener = new ButtonListener();
        this.okButton = new LocalButton(OK_ACTION_CMD);
        this.okButton.setPreferredSize(buttonDimension);
        this.okButton.addActionListener(this.buttonListener);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new LocalButton(CANCEL_ACTION_CMD);
        this.cancelButton.setPreferredSize(buttonDimension);
        this.cancelButton.addActionListener(this.buttonListener);
        this.cancelButton.registerKeyboardAction(this.buttonListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.isAltDown() && keyEvent.isMetaDown()) {
                    keyEvent.setModifiers(8);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAltDown() && keyEvent.isMetaDown()) {
                    keyEvent.setModifiers(8);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.isAltDown() && keyEvent.isMetaDown()) {
                    keyEvent.setModifiers(8);
                }
            }
        });
        this.applyButton = new LocalButton(APPLY_ACTION_CMD);
        this.applyButton.setPreferredSize(buttonDimension);
        this.applyButton.addActionListener(this.buttonListener);
        this.helpButton = new LocalButton(HELP_ACTION_CMD);
        this.helpButton.setPreferredSize(buttonDimension);
        this.helpButton.addActionListener(this.buttonListener);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.helpButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.addWindowListener(this);
    }

    public SplusFunctionInfo getFunctionInfo() {
        return this.funcInfo;
    }

    public void setFunctionInfo(SplusFunctionInfo splusFunctionInfo) {
        this.funcInfo = splusFunctionInfo;
    }

    public void setCenterPanel(JComponent jComponent) {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)jComponent, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0)), "North");
        this.getContentPane().add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0)), "East");
        this.getContentPane().add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0)), "West");
        Dimension dimension = this.getRootPane().getMinimumSize();
        int n = dimension.height + SplusDialog.labelDimension.height * 2;
        int n2 = dimension.width + 30;
        Dimension dimension2 = new Dimension(n2, n);
        this.setSize(dimension2);
        if (this.getOwner() != null) {
            SplusDialog.centerComponent(this, this.getOwner());
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (System.getProperty("splus.use.win32") != null) {
            // empty if block
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (System.getProperty("splus.use.win32") != null) {
            // empty if block
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (System.getProperty("splus.use.win32") != null) {
            SplusWinSessionImpl.setDialogRegister(this.m_hwnd, false);
            SplusWinSessionImpl.setExecutingScriptThreaded(false);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (System.getProperty("splus.use.win32") != null) {
            // empty if block
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void show() {
        super.show();
        if (System.getProperty("splus.use.win32") != null) {
            this.m_hwnd = SplusWin32Tools.getHwnd(this);
            SplusWinSessionImpl.setExecutingScriptThreaded(true);
            SplusWinSessionImpl.setDialogRegister(this.m_hwnd, true);
        }
        Component component = this.getContentPane().getComponent(0);
        FocusManager.getCurrentManager().focusNextComponent(component);
    }

    public void addButtonListener(SplusDialogButtonListener splusDialogButtonListener) {
        this.closeListeners.add(splusDialogButtonListener);
    }

    public void removeButtonListener(SplusDialogButtonListener splusDialogButtonListener) {
        this.closeListeners.remove(splusDialogButtonListener);
    }

    public void notifyButtonListeners(String string) {
        for (int i = 0; i < this.closeListeners.size(); ++i) {
            ((SplusDialogButtonListener)this.closeListeners.get(i)).splusDialogButtonPressed(this, string);
        }
    }

    public void performOk() {
        if (this.isComplete()) {
            this.sendCommand();
            if (System.getProperty("splus.use.win32") != null) {
                SplusWinSessionImpl.setDialogRegister(this.m_hwnd, false);
                SplusWinSessionImpl.setExecutingScriptThreaded(false);
            }
            this.dispose();
        }
    }

    public void performApply() {
        if (this.isComplete()) {
            this.sendCommand();
        }
    }

    public void performCancel() {
        if (System.getProperty("splus.use.win32") != null) {
            SplusWinSessionImpl.setDialogRegister(this.m_hwnd, false);
            SplusWinSessionImpl.setExecutingScriptThreaded(false);
        }
        this.dispose();
    }

    public boolean isComplete() {
        return true;
    }

    public boolean warnIfEmpty(SplusControlMethods splusControlMethods) {
        if (splusControlMethods.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, splusControlMethods.getText() + " field requires a value.", "Required Field Empty", 2);
            return false;
        }
        return true;
    }

    public void performHelp() {
        String string = this.getTitle();
        string = string.replace(' ', '_');
        string = string.replace('\'', '_');
        string = string.replace('&', '_');
        string = string.replace('-', '_');
        string = string.replace('(', '_');
        string = string.replace(')', '_');
        if (SplusSystem.getHelpQueryHandler() != null) {
            SplusSystem.getHelpQueryHandler().displayHelpOnTopic(string);
        }
    }

    public void sendCommand() {
        if (SplusSystem.getEngineQueryHandler() != null) {
            SplusSystem.getEngineQueryHandler().processDialogCommand(this.funcInfo.getFunctionCall());
        }
    }

    public void setApplyVisible(boolean bl) {
        this.applyButton.setVisible(bl);
    }

    public static JMenuBar getMainMenuBar() {
        return SplusSystem.getMainMenuBar();
    }

    public static ActionListener getMainActionListener() {
        return SplusSystem.getMainActionListener();
    }

    public static void showNewDialog(String string) throws ClassNotFoundException {
        string = string.replace('/', '.');
        final Class clazz = ClassUtilities.getClassForName(string);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.yield();
                    SplusDialog splusDialog = (SplusDialog)clazz.newInstance();
                    splusDialog.show();
                    splusDialog.repaint();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), exception.toString(), "Dialog Display Error", 0);
                }
            }
        });
        thread.start();
    }

    public static final void centerComponent(Component component, Component component2) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component2.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = component2.getLocation();
        point.translate((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        point.x = Math.max(0, Math.min(point.x, dimension3.width - dimension.width));
        point.y = Math.max(0, Math.min(point.y, dimension3.height - dimension2.height));
        component.setLocation(point.x, point.y);
    }

    private class LocalButton
    extends JButton {
        LocalButton(String string) {
            super(string);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (keyEvent.getID() == 401) {
                    keyEvent.consume();
                }
                this.doClick();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LocalButton localButton = (LocalButton)actionEvent.getSource();
            if (localButton == SplusDialog.this.okButton) {
                SplusDialog.this.performOk();
            } else if (localButton == SplusDialog.this.cancelButton) {
                SplusDialog.this.performCancel();
            } else if (localButton == SplusDialog.this.applyButton) {
                SplusDialog.this.performApply();
            } else if (localButton == SplusDialog.this.helpButton) {
                SplusDialog.this.performHelp();
            }
            SplusDialog.this.notifyButtonListeners(localButton.getActionCommand());
        }
    }

    public static interface SplusDialogButtonListener {
        public void splusDialogButtonPressed(SplusDialog var1, String var2);
    }
}

