/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusListBox;
import com.insightful.splus.ActiveDocument;
import com.insightful.splus.ActiveDocumentListener;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class WindowArranger
implements ActiveDocumentListener {
    JDesktopPane m_desktop;
    JInternalFrame[] m_aFrames;
    int m_cIcons;
    Rectangle m_rcDesktop;
    JMenu m_windowMenu;
    private static final int SET_CY_MIN = 80;
    private static final int SET_CX_MIN = 80;
    private static final int C_CASCADED_WINDOW_POSITIONS = 12;

    public WindowArranger(JDesktopPane jDesktopPane) {
        this.m_desktop = jDesktopPane;
        this.m_aFrames = jDesktopPane.getAllFrames();
        ActiveDocument.addActiveDocumentListener(this);
        this.m_windowMenu = new JMenu("Window");
        this.m_windowMenu.setMnemonic(87);
        this.rebuildWindowMenu();
    }

    public JMenu getWindowMenu() {
        return this.m_windowMenu;
    }

    public void tile() {
        this.setupListOfFrames();
        this.arrangeIcons();
        int n = this.m_aFrames.length - this.m_cIcons;
        if (n > 0) {
            int n2 = 1;
            while (n2 * n2 < n) {
                ++n2;
            }
            int n3 = n / n2;
            int n4 = n - n3 * n2;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = this.m_rcDesktop.width / n2;
            int n10 = this.m_rcDesktop.height / n3;
            for (int i = this.m_cIcons; i < this.m_aFrames.length; ++i) {
                this.m_aFrames[i].setBounds(n7, n8, n9, n6 == n3 - 1 ? this.m_rcDesktop.height - n8 : n10);
                n8 += n10;
                if (++n6 < n3) continue;
                n6 = 0;
                n8 = 0;
                n7 += n9;
                if (++n5 == n2 - n4) {
                    n10 = this.m_rcDesktop.height / ++n3;
                }
                if (n5 != n2 - 1) continue;
                n9 = this.m_rcDesktop.width - n7;
            }
        }
    }

    public void cascade() {
        this.setupListOfFrames();
        this.arrangeIcons();
        int n = Math.min(80, this.m_rcDesktop.height);
        int n2 = Math.min(80, this.m_rcDesktop.width);
        int n3 = Math.min(this.m_rcDesktop.height - n, this.m_rcDesktop.width - n2);
        Insets insets = this.m_aFrames[this.m_cIcons].getInsets();
        Rectangle rectangle = this.m_aFrames[this.m_cIcons].getContentPane().getBounds();
        Rectangle rectangle2 = this.m_aFrames[this.m_cIcons].getBounds();
        int n4 = rectangle2.height - rectangle.height - insets.bottom;
        n3 = Math.min(n4 * 12, n3);
        n3 = Math.min(n3, n4 * (this.m_aFrames.length - this.m_cIcons));
        Rectangle rectangle3 = new Rectangle(0, 0, this.m_rcDesktop.width - n3, this.m_rcDesktop.height - n3);
        for (int i = this.m_cIcons; i < this.m_aFrames.length; ++i) {
            try {
                this.m_aFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_aFrames[i].toFront();
            this.m_aFrames[i].setBounds(rectangle3);
            rectangle3.x += n4;
            rectangle3.y += n4;
            if (rectangle3.x < n3) continue;
            rectangle3.x = 0;
            rectangle3.y = 0;
        }
    }

    private void arrangeIcons() {
        int n = 0;
        Rectangle rectangle = new Rectangle();
        int n2 = 1;
        for (int i = 0; i < this.m_aFrames.length && n < this.m_cIcons; ++i) {
            if (!this.m_aFrames[i].isIcon()) continue;
            rectangle = this.m_aFrames[n].getBounds();
            n2 = this.m_rcDesktop.width / (rectangle.width + 8);
            try {
                this.m_aFrames[i].setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_aFrames[n].setBounds(new Rectangle(8 + rectangle.width * n, this.m_rcDesktop.height - (rectangle.height + 8) * (1 + n / n2), rectangle.width, rectangle.height));
            ++n;
        }
        if (n > 0) {
            this.m_rcDesktop.height -= (rectangle.height + 8) * (1 + n / n2);
        }
    }

    private void setupListOfFrames() {
        this.m_rcDesktop = this.m_desktop.getBounds();
        this.m_cIcons = 0;
        for (int i = 0; i < this.m_aFrames.length; ++i) {
            JInternalFrame jInternalFrame = this.m_aFrames[i];
            if (jInternalFrame.isClosed() || !jInternalFrame.isIcon()) continue;
            JInternalFrame jInternalFrame2 = this.m_aFrames[this.m_cIcons];
            this.m_aFrames[this.m_cIcons] = jInternalFrame;
            this.m_aFrames[i] = jInternalFrame2;
            ++this.m_cIcons;
        }
    }

    private void rebuildWindowMenu() {
        int n;
        int n2;
        this.m_windowMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Tile", 84);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowArranger.this.tile();
            }
        });
        this.m_windowMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Cascade", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowArranger.this.cascade();
            }
        });
        this.m_windowMenu.add(jMenuItem);
        this.m_windowMenu.addSeparator();
        JInternalFrame[] jInternalFrameArray = this.m_desktop.getAllFrames();
        int n3 = 0;
        for (int i = 0; i < this.m_aFrames.length; ++i) {
            n2 = 0;
            for (n = 0; n < jInternalFrameArray.length; ++n) {
                if (this.m_aFrames[i] != jInternalFrameArray[n]) continue;
                if (i != n + n3) {
                    jInternalFrameArray[n] = jInternalFrameArray[i + n3];
                    jInternalFrameArray[i + n3] = this.m_aFrames[i];
                }
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            --n3;
        }
        this.m_aFrames = jInternalFrameArray;
        JInternalFrame jInternalFrame = ActiveDocument.get();
        n2 = 0;
        for (n = 0; n < this.m_aFrames.length && n2 < 10; ++n) {
            if (!this.m_aFrames[n].isVisible()) continue;
            if (++n2 < 10) {
                jMenuItem = new JRadioButtonMenuItem(Integer.toString(n2) + " " + this.m_aFrames[n].getTitle(), this.m_aFrames[n] == jInternalFrame);
                jMenuItem.setMnemonic(48 + n2);
                jMenuItem.addActionListener(new DocumentActivator(this.m_aFrames[n]));
                this.m_windowMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = new JMenuItem("More Windows...", 77);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new SelectWindowDialog().show();
                }
            });
            this.m_windowMenu.add(jMenuItem);
        }
    }

    void rebuildWindowMenuEventually() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowArranger.this.rebuildWindowMenu();
            }
        });
    }

    public void documentAdded(JInternalFrame jInternalFrame) {
        this.rebuildWindowMenuEventually();
    }

    public void documentActivated(JInternalFrame jInternalFrame) {
        this.rebuildWindowMenuEventually();
    }

    public void documentClosed(JInternalFrame jInternalFrame) {
        this.rebuildWindowMenuEventually();
    }

    private class SelectWindowDialog
    extends SplusDialog {
        SplusListBox listBox;

        public SelectWindowDialog() {
            super("Select Window");
            this.setModal(true);
            String[] stringArray = new String[WindowArranger.this.m_aFrames.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = WindowArranger.this.m_aFrames[i].getTitle();
            }
            this.listBox = new SplusListBox("Window:", 'W', stringArray);
            this.listBox.setSelectionMode(0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(new EmptyBorder(jPanel.getInsets()));
            jPanel.add(this.listBox);
            jPanel.add(Box.createHorizontalGlue());
            this.setCenterPanel(jPanel);
        }

        public void performOk() {
            this.activateWindow();
            this.dispose();
        }

        public void performApply() {
            this.activateWindow();
        }

        private void activateWindow() {
            int n = this.listBox.getSelectedIndex();
            new DocumentActivator(WindowArranger.this.m_aFrames[n]).actionPerformed(null);
        }
    }

    private class DocumentActivator
    implements ActionListener {
        JInternalFrame jif;

        DocumentActivator(JInternalFrame jInternalFrame) {
            this.jif = jInternalFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        DocumentActivator.this.jif.setIcon(false);
                        DocumentActivator.this.jif.setSelected(true);
                    }
                    catch (Exception exception) {
                        DocumentActivator.this.jif.show();
                    }
                }
            });
        }
    }
}

