/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.util;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class StringMatrixTableModel
extends AbstractTableModel {
    String dataExpression;
    private int numRows;
    private int numCols;
    private String[] rowNames;
    private String[] colNames;
    private String[] dataValues;

    public StringMatrixTableModel(String string) {
        this.dataExpression = string;
        this.refresh();
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public Object getValueAt(int n, int n2) {
        return this.dataValues[this.numRows * n2 + n];
    }

    public String getRowName(int n) {
        return this.rowNames[n];
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public String[] getColumnNames() {
        return this.colNames;
    }

    public void refresh() {
        boolean bl = false;
        try {
            SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(this.dataExpression);
            if (splusDataResult == null) {
                bl = true;
            } else {
                int n;
                String[] stringArray = splusDataResult.getStringData();
                this.numRows = new Integer(stringArray[0]);
                this.numCols = new Integer(stringArray[1]);
                int n2 = 2;
                this.rowNames = new String[this.numRows];
                for (n = 0; n < this.numRows; ++n) {
                    this.rowNames[n] = stringArray[n2];
                    ++n2;
                }
                this.colNames = new String[this.numCols];
                for (n = 0; n < this.numCols; ++n) {
                    this.colNames[n] = stringArray[n2];
                    ++n2;
                }
                n = this.numRows * this.numCols;
                this.dataValues = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.dataValues[i] = stringArray[n2];
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.numRows = 1;
            this.numCols = 1;
            this.rowNames = new String[]{""};
            this.colNames = new String[]{""};
            this.dataValues = new String[]{""};
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Query for table values failed.  Creating and empty table.", "Table Creation Error", 2);
        }
        this.fireTableStructureChanged();
    }
}

