/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.CorrelationsEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CorrelationsDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane correlationScrollPane;
    private NodeDialog.SortingScrollPane targetScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDList correlationList;
    private NodeDialog.DNDListModel correlationListModel;
    private NodeDialog.DNDList targetList;
    private NodeDialog.DNDListModel targetListModel;
    private HashMap inTargetList;
    private HashMap inCorrelationList;
    private JRadioButton correlationsCheckBox;
    private JRadioButton covariancesCheckBox;
    private AbstractAction addAction;
    private AbstractAction removeAction;
    private AbstractAction addTargetAction;
    private AbstractAction removeTargetAction;
    private static CorrelationsDialog instance = null;

    public static CorrelationsDialog getInstance() {
        if (instance == null) {
            instance = new CorrelationsDialog();
        }
        return instance;
    }

    private CorrelationsDialog() {
        this.setResizable(true);
        this.setMinimumSize(new Dimension(375, 400));
    }

    public void restoreProperties() {
        String name;
        NodeDialog.ColumnInformationObject info;
        int i;
        XTMetaData metaData;
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.correlationListModel.removeAllElements();
        this.targetListModel.removeAllElements();
        this.inCorrelationList = new HashMap();
        this.inTargetList = new HashMap();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propCorrelation = props.getSubProperties(CorrelationsEngineNode.CORRELATION_COLUMNS_ATTRIBUTE_TAG);
        Vector propTarget = props.getSubProperties(CorrelationsEngineNode.TARGET_COLUMNS_ATTRIBUTE_TAG);
        int length = names.size();
        HashMap<String, NodeDialog.ColumnInformationObject> others = new HashMap<String, NodeDialog.ColumnInformationObject>();
        for (i = 0; i < length; ++i) {
            String name2 = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            if (!type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) continue;
            NodeDialog.ColumnInformationObject info2 = new NodeDialog.ColumnInformationObject(name2, type, role, false, i);
            this.availableListModel.addElement(info2);
            others.put(name2, info2);
        }
        for (i = 0; i < propCorrelation.size(); ++i) {
            info = (NodeDialog.ColumnInformationObject)others.get(propCorrelation.get(i));
            if (info == null) continue;
            this.correlationListModel.addElement(info);
            name = info.getText();
            this.inCorrelationList.put(name, name);
        }
        for (i = 0; i < propTarget.size(); ++i) {
            info = (NodeDialog.ColumnInformationObject)others.get(propTarget.get(i));
            if (info == null) continue;
            this.targetListModel.addElement(info);
            name = info.getText();
            this.inTargetList.put(name, name);
        }
        this.correlationsCheckBox.setSelected(props.getBoolean(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, true));
        this.covariancesCheckBox.setSelected(props.getBoolean(CorrelationsEngineNode.COVARIANCE_ATTRIBUTE_TAG, false));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        NodeDialog.ColumnInformationObject object;
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{CorrelationsEngineNode.CORRELATION_COLUMNS_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{CorrelationsEngineNode.TARGET_COLUMNS_ATTRIBUTE_TAG});
        Enumeration correlationColumns = this.correlationListModel.elements();
        while (correlationColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)correlationColumns.nextElement();
            props.set(CorrelationsEngineNode.CORRELATION_COLUMNS_ATTRIBUTE_TAG, object.getText(), "");
        }
        correlationColumns = null;
        Enumeration targetColumns = this.targetListModel.elements();
        while (targetColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)targetColumns.nextElement();
            props.set(CorrelationsEngineNode.TARGET_COLUMNS_ATTRIBUTE_TAG, object.getText(), "");
        }
        targetColumns = null;
        props.set(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, this.correlationsCheckBox.isSelected());
        props.set(CorrelationsEngineNode.COVARIANCE_ATTRIBUTE_TAG, this.covariancesCheckBox.isSelected());
    }

    public void createActions() {
        super.createActions();
        this.addAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!CorrelationsDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = CorrelationsDialog.this.availableList.getSelectedValues();
                    CorrelationsDialog.this.correlationListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        if (CorrelationsDialog.this.inCorrelationList.get(name) != null) continue;
                        CorrelationsDialog.this.correlationListModel.addElement(values[i]);
                        CorrelationsDialog.this.inCorrelationList.put(name, name);
                    }
                    CorrelationsDialog.this.correlationListModel.undoRemoveListDataListeners();
                    CorrelationsDialog.this.correlationScrollPane.sort();
                    CorrelationsDialog.this.correlationListModel.listContentsChanged();
                    Object var2_2 = null;
                }
            }
        };
        this.removeAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!CorrelationsDialog.this.correlationList.isSelectionEmpty()) {
                    int[] indices = CorrelationsDialog.this.correlationList.getSelectedIndices();
                    Object[] values = CorrelationsDialog.this.correlationList.getSelectedValues();
                    CorrelationsDialog.this.correlationList.getSelectionModel().clearSelection();
                    CorrelationsDialog.this.correlationListModel.removeListDataListeners();
                    for (int i = 0; i < indices.length; ++i) {
                        CorrelationsDialog.this.correlationListModel.removeElementAt(indices[i] - i);
                        CorrelationsDialog.this.inCorrelationList.remove(((NodeDialog.ColumnInformationObject)values[i]).getText());
                    }
                    CorrelationsDialog.this.correlationListModel.undoRemoveListDataListeners();
                    CorrelationsDialog.this.correlationListModel.listContentsChanged();
                    indices = null;
                    Object var3_3 = null;
                }
            }
        };
        this.addTargetAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!CorrelationsDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = CorrelationsDialog.this.availableList.getSelectedValues();
                    CorrelationsDialog.this.targetListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        String name = ((NodeDialog.ColumnInformationObject)values[i]).getText();
                        if (CorrelationsDialog.this.inTargetList.get(name) != null) continue;
                        CorrelationsDialog.this.targetListModel.addElement(values[i]);
                        CorrelationsDialog.this.inTargetList.put(name, name);
                    }
                    CorrelationsDialog.this.targetListModel.undoRemoveListDataListeners();
                    CorrelationsDialog.this.targetListModel.listContentsChanged();
                    CorrelationsDialog.this.targetScrollPane.sort();
                    Object var2_2 = null;
                }
            }
        };
        this.removeTargetAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!CorrelationsDialog.this.targetList.isSelectionEmpty()) {
                    Object[] values = CorrelationsDialog.this.targetList.getSelectedValues();
                    int[] indices = CorrelationsDialog.this.targetList.getSelectedIndices();
                    CorrelationsDialog.this.targetList.getSelectionModel().clearSelection();
                    CorrelationsDialog.this.targetListModel.removeListDataListeners();
                    for (int i = 0; i < indices.length; ++i) {
                        CorrelationsDialog.this.targetListModel.removeElementAt(indices[i] - i);
                        CorrelationsDialog.this.inTargetList.remove(((NodeDialog.ColumnInformationObject)values[i]).getText());
                    }
                    CorrelationsDialog.this.targetListModel.undoRemoveListDataListeners();
                    CorrelationsDialog.this.targetListModel.listContentsChanged();
                    values = null;
                    Object var3_3 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CorrelationsDialog_selectColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel(MinerApp.getText("CorrelationsDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addButton = new JButton(this.addAction);
        JButton removeButton = new JButton(this.removeAction);
        JButton addTargetButton = new JButton(this.addTargetAction);
        JButton removeTargetButton = new JButton(this.removeTargetAction);
        constraints.gridx = 5;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeButton, constraints);
        constraints.gridy = 7;
        selectColumnsPanel.add((Component)addTargetButton, constraints);
        constraints.gridy = 8;
        selectColumnsPanel.add((Component)removeTargetButton, constraints);
        JLabel correlationLabel = new JLabel(MinerApp.getText("CorrelationsDialog_correlationColumns"));
        correlationLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.correlationListModel = new NodeDialog.DNDListModel();
        this.correlationList = new NodeDialog.DNDList(this.correlationListModel);
        this.correlationList.setCellRenderer(renderer);
        this.correlationScrollPane = new NodeDialog.SortingScrollPane(this.correlationList);
        this.correlationScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel targetLabel = new JLabel(MinerApp.getText("CorrelationsDialog_targetColumns"));
        targetLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.targetListModel = new NodeDialog.DNDListModel();
        this.targetList = new NodeDialog.DNDList(this.targetListModel);
        this.targetList.setCellRenderer(renderer);
        this.targetScrollPane = new NodeDialog.SortingScrollPane(this.targetList);
        this.targetScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)correlationLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.correlationScrollPane, constraints);
        constraints.gridy = 6;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)targetLabel, constraints);
        constraints.gridy = 7;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.targetScrollPane, constraints);
        JPanel checkBoxPanel = new JPanel(new GridLayout(2, 1));
        checkBoxPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CorrelationsDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.correlationsCheckBox = new JRadioButton(MinerApp.getText("CorrelationsDialog_correlations"));
        this.correlationsCheckBox.setMnemonic(MinerApp.getText("CorrelationsDialog_correlationsHotkey").charAt(0));
        this.covariancesCheckBox = new JRadioButton(MinerApp.getText("CorrelationsDialog_covariances"));
        this.covariancesCheckBox.setMnemonic(MinerApp.getText("CorrelationsDialog_covariancesHotkey").charAt(0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.correlationsCheckBox);
        group.add(this.covariancesCheckBox);
        checkBoxPanel.add(this.correlationsCheckBox);
        checkBoxPanel.add(this.covariancesCheckBox);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)selectColumnsPanel, "Center");
        optionsPanel.add((Component)checkBoxPanel, "South");
        return optionsPanel;
    }
}

