/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FixedFormatDictionary {
    private Vector m_names = null;
    private LinkedList m_orderedNames = null;
    private HashMap m_entries = null;
    public static String COLUMN_NODE_TAG = "Column";
    public static String DICTIONARY_NODE_TAG = "Dictionary";
    public static String NAME_ATTRIBUTE_TAG = "name";
    public static String ROLE_ATTRIBUTE_TAG = "role";
    public static String TYPE_ATTRIBUTE_TAG = "type";
    public static String START_ATTRIBUTE_TAG = "start";
    public static String WIDTH_ATTRIBUTE_TAG = "width";
    public static String DECIMALS_ATTRIBUTE_TAG = "decimals";
    private static Pattern m_splusFormatPattern = null;

    public FixedFormatDictionary() {
        this.m_names = new Vector();
        this.m_orderedNames = new LinkedList();
        this.m_entries = new HashMap();
    }

    public FixedFormatDictionary(File file) {
        this();
        try {
            FileInputStream istream = new FileInputStream(file);
            this.initTextFile(istream);
            ((InputStream)istream).close();
            if (this.isEmpty()) {
                istream = new FileInputStream(file);
                this.initXMLFile(istream);
                ((InputStream)istream).close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addEntry(Entry entry) {
        Object obj = this.m_entries.get(entry.name);
        entry.type = this.addProperType(entry.type);
        entry.role = this.addProperRole(entry.role);
        if (obj == null) {
            this.m_names.add(entry.name);
            this.m_entries.put(entry.name, entry);
            this.addToSortedList(entry);
        } else {
            boolean diffStart;
            Entry newEntry = (Entry)obj;
            boolean bl = diffStart = entry.start != newEntry.start;
            if (diffStart) {
                this.moveInSortedList(entry);
            }
            newEntry.role = entry.role;
            newEntry.type = entry.type;
            newEntry.start = entry.start;
            newEntry.width = entry.width;
            newEntry.decimals = entry.decimals;
        }
    }

    public void addEntry(String name, String type, String role, Integer start, Integer width, Integer decimals) {
        Entry entry = new Entry();
        entry.name = name;
        if (role != null && role.length() > 0) {
            entry.role = role;
        }
        if (type != null && type.length() > 0) {
            entry.type = type;
        }
        if (start != null) {
            entry.start = start;
        }
        if (width != null) {
            entry.width = width;
        }
        if (decimals != null) {
            entry.decimals = decimals;
        }
        this.addEntry(entry);
    }

    private String addProperRole(String role) {
        if (role == null) {
            return null;
        }
        if (role.compareToIgnoreCase(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG;
        }
        if (role.compareToIgnoreCase(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG;
        }
        if (role.compareToIgnoreCase(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG;
        }
        if (role.compareToIgnoreCase(XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG;
        }
        return null;
    }

    private String addProperType(String type) {
        if (type == null) {
            return null;
        }
        if (type.compareToIgnoreCase(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
        }
        if (type.compareToIgnoreCase(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.STRING_TYPE_ATTRIBUTE_TAG;
        }
        if (type.compareToIgnoreCase(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
        }
        if (type.compareToIgnoreCase(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) == 0) {
            return XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG;
        }
        return null;
    }

    private void addToSortedList(Entry entry) {
        if (entry.start == -1) {
            this.m_orderedNames.add(entry.name);
            return;
        }
        Iterator iterator = this.m_orderedNames.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Entry thisEntry = (Entry)this.m_entries.get(name);
            if (thisEntry.start >= entry.start) {
                this.m_orderedNames.add(index, entry.name);
                return;
            }
            ++index;
        }
        this.m_orderedNames.addLast(entry.name);
    }

    private void moveInSortedList(Entry entry) {
        Iterator iterator = this.m_orderedNames.iterator();
        boolean removed = false;
        boolean added = false;
        int index = 0;
        int remIndex = -1;
        int addIndex = -1;
        while (!(!iterator.hasNext() || removed && added)) {
            Entry thisEntry = (Entry)this.m_entries.get(iterator.next());
            if (entry.start != -1 && added && thisEntry.start >= entry.start) {
                if (thisEntry.name.equals(entry.name)) {
                    return;
                }
                addIndex = index;
                added = true;
            } else if (!removed && thisEntry.name.equals(entry.name)) {
                remIndex = index;
                removed = true;
            }
            ++index;
        }
        this.m_orderedNames.remove(remIndex);
        if (!added) {
            this.m_orderedNames.addLast(entry.name);
        } else if (addIndex > remIndex) {
            this.m_orderedNames.add(addIndex - 1, entry.name);
        } else {
            this.m_orderedNames.add(addIndex, entry.name);
        }
    }

    public boolean isEmpty() {
        return this.m_names.size() == 0;
    }

    public List getNames() {
        return (List)this.m_names.clone();
    }

    public List getOrderedNames() {
        return (List)this.m_orderedNames.clone();
    }

    public String getType(int num) {
        return this.getType((String)this.m_names.get(num));
    }

    public String getType(String name) {
        Object obj = this.m_entries.get(name);
        if (obj == null) {
            return null;
        }
        return ((Entry)obj).type;
    }

    public String getOrderedType(int num) {
        return this.getType((String)this.m_orderedNames.get(num));
    }

    public String getOrderedType(String name) {
        return this.getType(name);
    }

    public String getRole(int num) {
        return this.getRole((String)this.m_names.get(num));
    }

    public String getRole(String name) {
        Object obj = this.m_entries.get(name);
        if (obj == null) {
            return null;
        }
        return ((Entry)obj).role;
    }

    public String getOrderedRole(int num) {
        return this.getRole((String)this.m_orderedNames.get(num));
    }

    public String getOrderedRole(String name) {
        return this.getRole(name);
    }

    public int getStart(int num) {
        return this.getStart((String)this.m_names.get(num));
    }

    public int getStart(String name) {
        Object obj = this.m_entries.get(name);
        if (obj == null) {
            return -1;
        }
        return ((Entry)obj).start;
    }

    public int getOrderedStart(int num) {
        return this.getStart((String)this.m_orderedNames.get(num));
    }

    public int getOrderedStart(String name) {
        return this.getStart(name);
    }

    public int getWidth(int num) {
        return this.getWidth((String)this.m_names.get(num));
    }

    public int getWidth(String name) {
        Object obj = this.m_entries.get(name);
        if (obj == null) {
            return -1;
        }
        return ((Entry)obj).width;
    }

    public int getOrderedWidth(int num) {
        return this.getWidth((String)this.m_orderedNames.get(num));
    }

    public int getOrderedWidth(String name) {
        return this.getWidth(name);
    }

    public int getDecimals(int num) {
        return this.getDecimals((String)this.m_names.get(num));
    }

    public int getDecimals(String name) {
        Object obj = this.m_entries.get(name);
        if (obj == null || ((Entry)obj).decimals == -1) {
            return 0;
        }
        return ((Entry)obj).decimals;
    }

    public int getOrderedDecimals(int num) {
        return this.getDecimals((String)this.m_orderedNames.get(num));
    }

    public int getOrderedDecimals(String name) {
        return this.getDecimals(name);
    }

    public void appendToModifyColumnsProps(XTProps ret) {
        String[] path = new String[]{"columns", "", ""};
        for (int i = 0; i < this.m_names.size(); ++i) {
            path[1] = (String)this.m_names.get(i);
            Entry entry = (Entry)this.m_entries.get(path[1]);
            if (entry.type != null) {
                path[2] = "datatype";
                ret.set(path, entry.type);
            }
            if (entry.role == null) continue;
            path[2] = "role";
            ret.set(path, entry.role);
        }
    }

    public void setXTMetaData(XTMetaData ret) {
        for (int i = 0; i < this.m_names.size(); ++i) {
            String name = (String)this.m_names.get(i);
            Entry entry = (Entry)this.m_entries.get(name);
            if (entry.type != null) {
                if (entry.type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendCategoricalDataField(name, new String[0]);
                } else if (entry.type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendContinousDataField(name);
                } else if (entry.type.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendDateTimeDataField(name);
                } else if (entry.type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendStringDataField(name, 33);
                }
            }
            if (entry.role == null) continue;
            ret.setDataFieldRole(name, entry.role);
        }
    }

    public XTMetaData getXTMetaData() {
        try {
            XTMetaData ret = new XTMetaData();
            this.setXTMetaData(ret);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FixedFormatDictionary) {
            FixedFormatDictionary ffd = (FixedFormatDictionary)obj;
            return XTMetaData.nullCognizantCompare(this.m_names, ffd.m_names) && XTMetaData.nullCognizantCompare(this.m_entries, ffd.m_entries);
        }
        return false;
    }

    private static HashMap copyHashMap(HashMap orig, boolean deep) {
        if (!deep) {
            return new HashMap(orig);
        }
        HashMap<String, Entry> copy = new HashMap<String, Entry>();
        Set keys = orig.keySet();
        for (String key : keys) {
            Entry e = (Entry)orig.get(key);
            copy.put(key, e.copy());
        }
        return copy;
    }

    public static void test() {
        try {
            File text = new File("d:\\dataDictionary.txt");
            FixedFormatDictionary ffd_text = new FixedFormatDictionary(text);
            File xml = new File("d:\\dataDictionary.xml");
            FixedFormatDictionary ffd_xml = new FixedFormatDictionary(xml);
            System.out.println("XML equals TXT? " + ffd_text.equals(ffd_xml));
            System.out.println(ffd_xml.getXTMetaData().writeToString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed.");
        }
    }

    private FixedFormatDictionary(FixedFormatDictionary ffd) {
        this.m_names = (Vector)ffd.m_names.clone();
        this.m_orderedNames = (LinkedList)ffd.m_orderedNames.clone();
        this.m_entries = FixedFormatDictionary.copyHashMap(ffd.m_entries, true);
    }

    protected void writeEntryInfoXML(String name, Entry entry, Writer writer) throws IOException {
        String type = entry.type == null ? "" : entry.type;
        String role = entry.role == null ? "" : entry.role;
        writer.write(NAME_ATTRIBUTE_TAG + "=\"" + name + "\" ");
        writer.write(TYPE_ATTRIBUTE_TAG + "=\"" + type + "\" ");
        writer.write(ROLE_ATTRIBUTE_TAG + "=\"" + role + "\" ");
        writer.write(START_ATTRIBUTE_TAG + "=\"" + entry.start + "\" ");
        writer.write(WIDTH_ATTRIBUTE_TAG + "=\"" + entry.width + "\" ");
        writer.write(DECIMALS_ATTRIBUTE_TAG + "=\"" + entry.decimals + "\" ");
    }

    protected void writeEntryInfoCSV(String name, Entry entry, Writer writer) throws IOException {
        String type = entry.type == null ? "" : entry.type;
        String role = entry.role == null ? "" : entry.role;
        writer.write(name);
        writer.write(", " + type);
        writer.write(", " + role);
        writer.write(", " + entry.start);
        writer.write(", " + entry.width);
        writer.write(", " + entry.decimals);
    }

    public void saveCSV(OutputStream outs) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outs);
            String name = null;
            Entry entry = null;
            for (int i = 0; i < this.m_names.size(); ++i) {
                name = (String)this.m_names.get(i);
                entry = (Entry)this.m_entries.get(name);
                this.writeEntryInfoCSV(name, entry, writer);
                writer.write("\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveXML(OutputStream outs) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outs, "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            if (this.m_names.size() == 0) {
                writer.write("<" + DICTIONARY_NODE_TAG + "/>\n");
            } else {
                String name = null;
                Entry entry = null;
                writer.write("<" + DICTIONARY_NODE_TAG + ">\n");
                for (int i = 0; i < this.m_names.size(); ++i) {
                    name = (String)this.m_names.get(i);
                    entry = (Entry)this.m_entries.get(name);
                    writer.write("\t<" + COLUMN_NODE_TAG + " ");
                    this.writeEntryInfoXML(name, entry, writer);
                    writer.write("/>\n");
                }
                writer.write("</" + DICTIONARY_NODE_TAG + ">\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initTextFile(InputStream ins) {
        BufferedReader dis = new BufferedReader(new InputStreamReader(ins));
        try {
            String str;
            while ((str = dis.readLine()) != null) {
                Entry entry = new Entry();
                this.handleEntryFromCSV(str, entry);
                if (entry.name == null) continue;
                this.addEntry(entry);
            }
        }
        catch (IOException e) {
        }
    }

    protected void handleEntryFromCSV(String str, Entry entry) {
        int position = str.indexOf(44);
        int length = str.length();
        if (position != -1) {
            entry.name = str.substring(0, position);
            int newPosition = str.indexOf(44, position + 1);
            String temp = "";
            if (newPosition == -1) {
                temp = str.substring(position + 1, length).trim();
                if (temp.length() > 0) {
                    entry.type = temp;
                }
            } else {
                temp = str.substring(position + 1, newPosition).trim();
                if (temp.length() > 0) {
                    entry.type = temp;
                }
                if ((newPosition = str.indexOf(44, (position = newPosition) + 1)) == -1) {
                    temp = str.substring(position + 1, length).trim();
                    if (temp.length() > 0) {
                        entry.role = temp;
                    }
                } else {
                    temp = str.substring(position + 1, newPosition).trim();
                    if (temp.length() > 0) {
                        entry.role = temp;
                    }
                    if ((newPosition = str.indexOf(44, (position = newPosition) + 1)) == -1) {
                        temp = str.substring(position + 1, length).trim();
                        if (temp.length() > 0) {
                            entry.start = Integer.parseInt(temp);
                        }
                    } else {
                        temp = str.substring(position + 1, newPosition).trim();
                        if (temp.length() > 0) {
                            entry.start = Integer.parseInt(temp);
                        }
                        if ((newPosition = str.indexOf(44, (position = newPosition) + 1)) == -1) {
                            temp = str.substring(position + 1, length).trim();
                            if (temp.length() > 0) {
                                entry.width = Integer.parseInt(temp);
                            }
                        } else {
                            int endPos;
                            temp = str.substring(position + 1, newPosition).trim();
                            if (temp.length() > 0) {
                                entry.width = Integer.parseInt(temp);
                            }
                            if ((temp = str.substring(position + 1, endPos = (newPosition = str.indexOf(44, (position = newPosition) + 1)) == -1 ? length : newPosition).trim()).length() > 0) {
                                entry.decimals = Integer.parseInt(temp);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void handleEntryFromXML(Attributes attributes, Entry entry) {
        String temp = null;
        entry.name = attributes.getValue(NAME_ATTRIBUTE_TAG);
        temp = attributes.getValue(TYPE_ATTRIBUTE_TAG);
        if (temp != null) {
            entry.type = temp;
        }
        if ((temp = attributes.getValue(ROLE_ATTRIBUTE_TAG)) != null) {
            entry.role = temp;
        }
        if ((temp = attributes.getValue(START_ATTRIBUTE_TAG)) != null) {
            entry.start = Integer.parseInt(temp);
        }
        if ((temp = attributes.getValue(WIDTH_ATTRIBUTE_TAG)) != null) {
            entry.width = Integer.parseInt(temp);
        }
        if ((temp = attributes.getValue(DECIMALS_ATTRIBUTE_TAG)) != null) {
            entry.decimals = Integer.parseInt(temp);
        }
        temp = attributes.getValue("new_name");
        temp = null;
    }

    private void initXMLFile(InputStream ins) {
        try {
            DictionarySaxHandler customHandler = new DictionarySaxHandler(this);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(ins, (DefaultHandler)customHandler);
            ins.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FixedFormatDictionary createFixedFormatDictionaryFromSplusFormatString(String format) {
        FixedFormatDictionary ffd = new FixedFormatDictionary();
        int readPos = 1;
        int varNum = 1;
        boolean start = false;
        if (m_splusFormatPattern == null) {
            m_splusFormatPattern = Pattern.compile("%([0-9]*)[.]?([0-9]*)([^ ,]*)", 32);
        }
        Matcher m = m_splusFormatPattern.matcher(format);
        while (m.find()) {
            String widthString = m.group(1);
            String decString = m.group(2);
            String cmd = m.group(3);
            int width = 0;
            int dec = -1;
            try {
                width = Integer.parseInt(widthString);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                dec = Integer.parseInt(decString);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String type = null;
            switch (cmd.length() < 1 ? 115 : (int)cmd.charAt(0)) {
                case 100: 
                case 102: {
                    type = XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
                    break;
                }
                case 68: {
                    type = XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG;
                    break;
                }
                case 42: {
                    type = null;
                    break;
                }
                default: {
                    type = XTMetaData.STRING_TYPE_ATTRIBUTE_TAG;
                }
            }
            if (type != null) {
                ffd.addEntry("var" + varNum, type, null, new Integer(readPos), new Integer(width), dec < 0 ? null : new Integer(dec));
                ++varNum;
            }
            readPos += width;
        }
        return ffd;
    }

    public class DictionarySaxHandler
    extends DefaultHandler {
        private FixedFormatDictionary m_ffd = null;

        public DictionarySaxHandler(FixedFormatDictionary ffd) {
            this.m_ffd = ffd;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals(COLUMN_NODE_TAG)) {
                Entry entry = new Entry();
                FixedFormatDictionary.this.handleEntryFromXML(attributes, entry);
                FixedFormatDictionary.this.addEntry(entry);
            }
        }
    }

    protected class Entry {
        public String name = null;
        public String type = null;
        public String role = null;
        public int start = -1;
        public int width = -1;
        public int decimals = -1;

        public Entry() {
        }

        public Entry(String n, String t, String r, int s, int w, int d) {
            this.name = n;
            this.type = t;
            this.role = r;
            this.start = s;
            this.width = w;
            this.decimals = d;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return ((Entry)obj).start == this.start && ((Entry)obj).width == this.width && ((Entry)obj).decimals == this.decimals && XTMetaData.nullCognizantCompare(((Entry)obj).name, this.name) && XTMetaData.nullCognizantCompare(((Entry)obj).type, this.type) && XTMetaData.nullCognizantCompare(((Entry)obj).role, this.role);
            }
            return false;
        }

        public Entry copy() {
            return new Entry(this.name, this.type, this.role, this.start, this.width, this.decimals);
        }
    }
}

