/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.HelpActor;
import com.insightful.miner.MinerApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.MalformedURLException;
import javax.help.HelpSetException;
import javax.swing.UIManager;

public class HelpProxy {
    static final String helpsetName = "iminer.hs";
    static HelpActor jhmanager;
    static boolean jhmanagerActive;
    private BufferedReader input;
    private PrintWriter output;
    private StreamTokenizer tokenizer;
    static Thread xSelect;
    private static final String errMsg = "Help System Startup Failed\n\nCheck that your iminer.hs help set has been installed.";

    public HelpProxy() throws HelpSetException, MalformedURLException {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.out));
    }

    public HelpProxy(Reader in, Writer out) throws HelpSetException, MalformedURLException {
        this.input = !(in instanceof BufferedReader) ? new BufferedReader(in) : (BufferedReader)in;
        this.output = !(out instanceof PrintWriter) ? new PrintWriter(out) : (PrintWriter)out;
        this.tokenizer = new StreamTokenizer(this.input);
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.quoteChar(38);
        this.createJhelp();
    }

    public void readingInput() throws HelpSetException, InterruptedException, IOException {
        int i = 0;
        boolean finished = false;
        String[] buffer = new String[3];
        int toknum = 0;
        while (!finished) {
            int tokflag;
            for (i = 0; i < 3; ++i) {
                buffer[i] = "";
            }
            toknum = 0;
            while ((tokflag = this.tokenizer.nextToken()) != 10) {
                switch (tokflag) {
                    case 38: {
                        if (toknum >= 3) break;
                        buffer[toknum] = this.tokenizer.sval;
                        ++toknum;
                        break;
                    }
                    case -2: {
                        if (toknum >= 3) break;
                        buffer[toknum] = String.valueOf((int)this.tokenizer.nval);
                        ++toknum;
                        break;
                    }
                    case -3: {
                        if (this.tokenizer.sval.equals("exitJh")) {
                            System.exit(0);
                            break;
                        }
                        if (toknum >= 3) break;
                        buffer[toknum] = this.tokenizer.sval;
                        ++toknum;
                        break;
                    }
                    case -1: {
                        System.exit(0);
                        break;
                    }
                    default: {
                        System.out.print("Unknown command" + buffer[0] + " " + buffer[1] + " " + buffer[2] + "\n");
                    }
                }
                Thread.sleep(200L);
            }
            this.processing(toknum, buffer);
        }
    }

    public void processing(int toknum, String[] buffer) throws HelpSetException, MalformedURLException {
        switch (toknum) {
            case 1: {
                if (buffer[0].equals("openJhelp")) {
                    HelpActor.openJhelp();
                    break;
                }
                if (!buffer[0].equals("closeJhelp")) break;
                HelpActor.closeJhelp();
                break;
            }
            case 2: {
                if (buffer[0].equals("displayJhelp")) {
                    HelpActor.displayJhelp(buffer[1]);
                    break;
                }
                if (buffer[0].equals("openJhelp")) {
                    HelpActor.openJhelp(buffer[1]);
                    break;
                }
                if (!buffer[0].equals("removeHelpset")) break;
                HelpActor.removeHelpSet(buffer[1]);
                break;
            }
            case 3: {
                if (!buffer[0].equals("addHelpset")) break;
                HelpActor.addHelpSet(buffer[1], buffer[2]);
            }
        }
    }

    public void createJhelp() throws HelpSetException, MalformedURLException {
        String hostname = System.getProperty("sprime.server.host");
        String helplink = System.getProperty("sprime.server.helplink");
        jhmanager = new HelpActor(hostname, helplink);
        HelpActor.createJhelp(helpsetName);
    }

    public static void main(String[] args) {
        try {
            new HelpProxy().readingInput();
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(null, errMsg, MinerApp.getText("HelpProxy_msg_helpError"), 0);
            System.exit(1);
        }
    }

    static {
        jhmanagerActive = false;
        xSelect = null;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String os = System.getProperty("os.name", "unknown").toLowerCase();
        if (os.indexOf("windows") >= 0 || os.startsWith("mac")) {
            // empty if block
        }
    }
}

