/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.LiftChartFrame;
import com.insightful.miner.MinerApp;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.XYDataset;
import java.util.ResourceBundle;
import java.util.Vector;

public class LiftChartBuilder {
    private static ResourceBundle chartBundles = null;
    private double[][] x_cum_gain;
    private double[][] y_cum_gain;
    private double[][] y_lift;
    private double[][] x_roc;
    private Vector inputNames;
    private double yLiftMaxVal;
    public LiftChartFrame frame = null;

    public LiftChartBuilder(Vector inputs, double[][] xCumGain, double[][] yCumGain, double[][] yLift, double[][] xROC) {
        this.x_cum_gain = xCumGain;
        this.y_cum_gain = yCumGain;
        this.y_lift = this.replaceBadVals(yLift);
        this.x_roc = xROC;
        this.inputNames = inputs;
        this.yLiftMaxVal = this.getMaxVal(this.y_lift);
        this.x_cum_gain = this.addInitialVals(this.x_cum_gain, false);
        this.y_cum_gain = this.addInitialVals(this.y_cum_gain, false);
        this.y_lift = this.addInitialVals(this.y_lift, true);
        this.x_roc = this.addInitialVals(this.x_roc, false);
    }

    private double[][] replaceBadVals(double[][] liftVals) {
        int counter = 0;
        for (int i = 0; i < liftVals.length; ++i) {
            for (int j = 0; j < liftVals[i].length; ++j) {
                if (!Double.isNaN(liftVals[i][j])) continue;
                ++counter;
            }
            if (counter > 0) {
                double maxval = 0.0;
                if (counter < liftVals[i].length - 1) {
                    maxval = liftVals[i][counter + 1];
                }
                for (int k = 0; k < counter; ++k) {
                    liftVals[i][k] = maxval * 4.0;
                }
            }
            counter = 0;
        }
        return liftVals;
    }

    private double[][] addInitialVals(double[][] array, boolean isYLift) {
        double[][] finaldata = new double[array.length][array[0].length + 1];
        for (int i = 0; i < array.length; ++i) {
            finaldata[i][0] = !isYLift ? 0.0 : array[i][0];
            for (int j = 0; j < array[0].length; ++j) {
                finaldata[i][j + 1] = array[i][j];
            }
        }
        return finaldata;
    }

    public XYDataset[] createDatasets(int chartType) {
        XYDataset[] finaldata;
        switch (chartType) {
            case 0: {
                finaldata = this.buildXYDatasets(this.x_cum_gain, this.y_cum_gain);
                break;
            }
            case 1: {
                finaldata = this.buildLiftDatasets(this.x_cum_gain, this.y_lift);
                break;
            }
            case 2: {
                finaldata = this.buildXYDatasets(this.divideByHundred(this.x_roc), this.divideByHundred(this.y_cum_gain));
                break;
            }
            default: {
                finaldata = this.buildXYDatasets(this.x_cum_gain, this.y_cum_gain);
            }
        }
        return finaldata;
    }

    public double[][] divideByHundred(double[][] array) {
        double[][] resultArray = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                resultArray[i][j] = Double.isNaN(array[i][j]) ? Double.NaN : array[i][j] / 100.0;
            }
        }
        return resultArray;
    }

    private XYDataset[] buildXYDatasets(double[][] xvals, double[][] yvals) {
        int numLines = Math.min(xvals.length, yvals.length);
        int[] numVals = new int[numLines];
        for (int i = 0; i < numLines; ++i) {
            numVals[i] = Math.min(xvals[i].length, yvals[i].length);
        }
        XYDataset[] xydataset = new XYDataset[numLines];
        for (int i = 0; i < numLines; ++i) {
            Object[][][] finaldata = new Object[1][numVals[i]][2];
            for (int j = 0; j < numVals[i]; ++j) {
                finaldata[0][j][0] = new Double(xvals[i][j]);
                finaldata[0][j][1] = new Double(yvals[i][j]);
            }
            xydataset[i] = new DefaultXYDataset(finaldata);
        }
        return xydataset;
    }

    private XYDataset[] buildLiftDatasets(double[][] xvals, double[][] yvals) {
        double[][] startWith10s = new double[xvals.length][xvals[0].length];
        for (int j = 0; j < xvals.length; ++j) {
            startWith10s[j][0] = 10.0;
            for (int i = 1; i < xvals[0].length; ++i) {
                startWith10s[j][i] = xvals[j][i];
            }
        }
        return this.buildXYDatasets(startWith10s, yvals);
    }

    public XYDataset buildRefDataset(int chartType) {
        Object[][][] finaldata = null;
        if (chartType == 0) {
            finaldata = new Object[][][]{{{new Double(0.01), new Double(0.01)}, {new Double(100.0), new Double(100.0)}}};
        } else if (chartType == 1) {
            finaldata = new Object[][][]{{{new Double(0.01), new Double(1.0)}, {new Double(100.0), new Double(1.0)}}};
        } else if (chartType == 2) {
            finaldata = new Object[][][]{{{new Double(0.01), new Double(0.01)}, {new Double(1.0), new Double(1.0)}}};
        }
        return new DefaultXYDataset(finaldata);
    }

    public double getMaxVal(double[][] array) {
        double max = 0.0;
        for (int j = 0; j < array.length; ++j) {
            for (int k = 0; k < array[j].length; ++k) {
                if (!(max < array[j][k])) continue;
                max = array[j][k];
            }
        }
        return max;
    }

    public double getMaxLiftChartVal() {
        return this.yLiftMaxVal;
    }

    public String getInputName(int index) {
        if (index < this.inputNames.size()) {
            return (String)this.inputNames.elementAt(index);
        }
        return Integer.toString(index);
    }

    public static String getText(String key) {
        if (chartBundles == null) {
            chartBundles = MinerApp.getBundle("liftChartBundles");
        }
        String string = MinerApp.getBundleString(chartBundles, key);
        return string;
    }

    public XYDataset createTestDataset() {
        Object[][][] finaldata = new Object[][][]{{{new Double(this.x_roc[0][14]), new Double(this.y_cum_gain[0][14])}, {new Double(this.x_roc[0][15]), new Double(this.y_cum_gain[0][15])}, {new Double(this.x_roc[0][16]), new Double(this.y_cum_gain[0][16])}, {new Double(this.x_roc[0][17]), new Double(this.y_cum_gain[0][17])}, {new Double(this.x_roc[0][18]), new Double(this.y_cum_gain[0][18])}}};
        DefaultXYDataset xydataset = new DefaultXYDataset(finaldata);
        return xydataset;
    }
}

