/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class NormalizeEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private XTMetaData m_metaData;
    private Vector m_columns = null;
    private boolean m_scaleRange;
    private boolean m_centerMean;
    private boolean m_centerMedian;
    private boolean m_scaleStdDev;
    private int[] m_columnNums = null;
    private boolean[] m_normalizeColumn = null;
    private double[] m_columnCenter = null;
    private double[] m_columnScale = null;
    private long m_totalRowCount;
    private boolean m_firstPass;
    private int m_kValue = 100;
    private ByColumnStatisticAccumulator m_bCS = null;
    public static String COLUMNS_ATTRIBUTE_TAG = "outgoingColumns";
    public static String CENTER_METHOD_ATTRIBUTE_TAG = "center";
    public static String NONE_ATTRIBUTE_TAG = "none";
    public static String RANGE_ATTRIBUTE_TAG = "range";
    public static String MEAN_ATTRIBUTE_TAG = "mean";
    public static String MEDIAN_ATTRIBUTE_TAG = "median";
    public static String SCALE_ATTRIBUTE_TAG = "scale";
    public static String STD_DEV_ATTRIBUTE_TAG = "stdDev";
    public static String K_VALUE_ATTRIBUTE_TAG = "kValue";
    public static int DEFAULT_K_VALUE = 100;
    public static String SCALE_METHOD_DEFAULT = STD_DEV_ATTRIBUTE_TAG;
    public static String CENTER_METHOD_DEFAULT = MEAN_ATTRIBUTE_TAG;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        int i;
        XTProps props = this.getNodeProperties();
        this.m_metaData = this.getInputMetaData(0);
        this.m_centerMean = props.getValue(CENTER_METHOD_ATTRIBUTE_TAG, CENTER_METHOD_DEFAULT).equals(MEAN_ATTRIBUTE_TAG);
        this.m_centerMedian = props.getValue(CENTER_METHOD_ATTRIBUTE_TAG, CENTER_METHOD_DEFAULT).equals(MEDIAN_ATTRIBUTE_TAG);
        this.m_scaleStdDev = props.getValue(SCALE_ATTRIBUTE_TAG, SCALE_METHOD_DEFAULT).equals(STD_DEV_ATTRIBUTE_TAG);
        this.m_scaleRange = props.getValue(SCALE_ATTRIBUTE_TAG, SCALE_METHOD_DEFAULT).equals(RANGE_ATTRIBUTE_TAG);
        this.m_kValue = props.getInt(K_VALUE_ATTRIBUTE_TAG, DEFAULT_K_VALUE);
        this.m_columns = this.m_metaData.getColumnNames();
        int numColumns = this.m_columns.size();
        this.m_normalizeColumn = new boolean[numColumns];
        this.m_columnCenter = new double[numColumns];
        this.m_columnScale = new double[numColumns];
        for (int i2 = 0; i2 < numColumns; ++i2) {
            this.m_normalizeColumn[i2] = false;
            this.m_columnCenter[i2] = 0.0;
            this.m_columnScale[i2] = 1.0;
        }
        Vector tempColumns = props.getSubProperties(COLUMNS_ATTRIBUTE_TAG);
        if (tempColumns.size() > 0) {
            this.m_columns = tempColumns;
        } else {
            for (i = numColumns - 1; i >= 0; --i) {
                if (this.m_metaData.isContinuousColumn(i)) continue;
                this.m_columns.remove(i);
            }
        }
        numColumns = this.m_columns.size();
        this.m_columnNums = new int[numColumns];
        for (i = 0; i < numColumns; ++i) {
            this.m_columnNums[i] = this.m_metaData.nameToOrdinal((String)this.m_columns.get(i));
            this.m_normalizeColumn[this.m_columnNums[i]] = true;
            if (this.m_centerMean) {
                this.m_columnCenter[this.m_columnNums[i]] = this.m_metaData.getColumnMean(this.m_columnNums[i]);
            }
            if (this.m_scaleStdDev) {
                this.m_columnScale[this.m_columnNums[i]] = this.m_metaData.getColumnStandardDeviation(this.m_columnNums[i]);
                continue;
            }
            if (!this.m_scaleRange) continue;
            this.m_columnScale[this.m_columnNums[i]] = this.m_metaData.getColumnMax(this.m_columnNums[i]) - this.m_metaData.getColumnMin(this.m_columnNums[i]);
        }
        if (this.m_centerMedian) {
            try {
                this.m_bCS = new ByColumnStatisticAccumulator(new Vector(), this.m_columns, 4, this.m_kValue, this.m_metaData);
            }
            catch (Exception e) {
                this.printlnError(e.getMessage());
            }
            this.m_firstPass = true;
        }
        this.m_totalRowCount = this.m_metaData.getNumRows();
    }

    public void execute(CNKProcJavaTransform proc) {
        int nrowBlock = proc.getChunkInputRows(0);
        if (this.m_centerMedian && this.m_firstPass) {
            this.calculateMedian(proc);
            proc.setChunkOutputReleaseRows(0, 0);
            if (this.m_totalRowCount == proc.getChunkInputPosition(0) + (long)nrowBlock) {
                proc.setChunkNextInputPosition(0, 0L);
            }
            return;
        }
        int numCols = this.m_metaData.getNumColumns();
        for (int col = 0; col < numCols; ++col) {
            if (this.m_normalizeColumn[col]) {
                double[] ibuf = proc.getChunkInputColumnData(0, col);
                double[] obuf = proc.getChunkOutputColumnData(0, col);
                for (int row = 0; row < nrowBlock; ++row) {
                    double newVal;
                    obuf[row] = newVal = (ibuf[row] - this.m_columnCenter[col]) / this.m_columnScale[col];
                }
                continue;
            }
            proc.copyColumnData(0, col, 0, 0, col, 0, nrowBlock);
        }
    }

    private void calculateMedian(CNKProcJavaTransform proc) {
        int nrowBlock = proc.getChunkInputRows(0);
        double[][] byColumns = new double[0][0];
        double[][] interestColumns = new double[this.m_columnNums.length][];
        for (int i = 0; i < this.m_columnNums.length; ++i) {
            interestColumns[i] = proc.getChunkInputColumnData(0, this.m_columnNums[i]);
        }
        this.m_bCS.updateStatistics(byColumns, interestColumns, nrowBlock);
        if (this.m_totalRowCount == proc.getChunkInputPosition(0) + (long)nrowBlock) {
            try {
                XTProps stats = this.m_bCS.outputColumnStats();
                int numColumns = this.m_columns.size();
                String[] path = new String[]{"", ByColumnStatisticAccumulator.STATS_ATTRIBUTE_TAG, ByColumnStatisticAccumulator.QUANTILES_ATTRIBUTE_TAG, "1"};
                for (int i = 0; i < numColumns; ++i) {
                    path[0] = (String)this.m_columns.get(i);
                    this.m_columnCenter[this.m_columnNums[i]] = stats.getDouble(path, Double.NaN);
                }
                stats = null;
                this.m_bCS = null;
                this.m_firstPass = false;
            }
            catch (Exception e) {
                this.printlnError(e.getMessage());
            }
        }
    }
}

