/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.ReadOtherFileDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReadPMMLFileDialog
extends NodeDialog {
    protected JTextField m_fileNameTextField;
    protected AbstractAction m_browseAction;
    protected PredictionPanel.ModelPanel m_modelPanel;
    protected static String[] m_typeDescriptionList = new String[]{"XML files (*.xml)"};
    protected static String[][] m_extensionList = new String[][]{{".xml"}};
    private static ReadPMMLFileDialog m_ReadPMMLFileDialog = null;

    public static ReadPMMLFileDialog getReadPMMLFileDialog() {
        if (m_ReadPMMLFileDialog == null) {
            m_ReadPMMLFileDialog = new ReadPMMLFileDialog();
        }
        return m_ReadPMMLFileDialog;
    }

    protected ReadPMMLFileDialog() {
        Dimension min = new Dimension(450, 450);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public void restoreProperties() {
        super.restoreProperties();
        if (this.m_modelPanel != null) {
            this.m_modelPanel.predictModelRestore(this.getNodeModel());
        }
        String str = this.getNodeModel().getXTProps().getValue("filePath");
        this.m_fileNameTextField.setText(str);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        String str = this.m_fileNameTextField.getText();
        if (str.length() > 0) {
            this.getNodeModel().getXTProps().set("filePath", str);
        }
    }

    public void createActions() {
        super.createActions();
        this.m_browseAction = new AbstractAction(MinerApp.getText("ReadPMMLFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_ReadPMMLFileDialog, ReadPMMLFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        };
    }

    protected String getFilenameLabelText() {
        return MinerApp.getText("ReadPMMLFileDialog_filename");
    }

    protected char getFilenameLabelHotkey() {
        return MinerApp.getText("ReadPMMLFileDialog_filenameHotkey").charAt(0);
    }

    public JPanel createOptionsPanel() {
        return this.createReadWriteOptionsPanel(false);
    }

    protected JPanel createReadWriteOptionsPanel(boolean write) {
        JLabel label = new JLabel(this.getFilenameLabelText());
        label.setDisplayedMnemonic(this.getFilenameLabelHotkey());
        this.m_fileNameTextField = new JTextField(10);
        label.setLabelFor(this.m_fileNameTextField);
        JButton browse = new JButton(this.m_browseAction);
        browse.setMnemonic(MinerApp.getText("ReadPMMLFileDialog_browseHotkey").charAt(0));
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = write ? 0.0 : 1.0;
        optionsPanel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        optionsPanel.add((Component)this.m_fileNameTextField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        optionsPanel.add((Component)browse, gbc);
        if (write) {
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            this.m_modelPanel = new PredictionPanel.ModelPanel();
            optionsPanel.add((Component)this.m_modelPanel, gbc);
        } else {
            this.m_modelPanel = null;
        }
        return optionsPanel;
    }
}

